/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed.implementation.models;

import com.azure.storage.blob.changefeed.implementation.models.ChangefeedTypeValidator;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEventData;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import java.util.Map;
import java.util.Objects;

public class InternalBlobChangefeedEventData
implements BlobChangefeedEventData {
    private final String api;
    private final String clientRequestId;
    private final String requestId;
    private final String eTag;
    private final String contentType;
    private final Long contentLength;
    private final BlobType blobType;
    private final Long contentOffset;
    private final String destinationUrl;
    private final String sourceUrl;
    private final String blobUrl;
    private final boolean recursive;
    private final String sequencer;

    public InternalBlobChangefeedEventData(String api, String clientRequestId, String requestId, String eTag, String contentType, Long contentLength, BlobType blobType, Long contentOffset, String destinationUrl, String sourceUrl, String blobUrl, boolean recursive, String sequencer) {
        this.api = api;
        this.clientRequestId = clientRequestId;
        this.requestId = requestId;
        this.eTag = eTag;
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.blobType = blobType;
        this.contentOffset = contentOffset;
        this.destinationUrl = destinationUrl;
        this.sourceUrl = sourceUrl;
        this.blobUrl = blobUrl;
        this.recursive = recursive;
        this.sequencer = sequencer;
    }

    static InternalBlobChangefeedEventData fromRecord(Object d) {
        AvroSchema.checkType((String)"data", (Object)d, Map.class);
        Map data = (Map)d;
        if (!data.get("$record").equals("BlobChangeEventData")) {
            throw new IllegalArgumentException("Not a valid BlobChangefeedEventData.");
        }
        Object api = data.get("api");
        Object clientRequestId = data.get("clientRequestId");
        Object requestId = data.get("requestId");
        Object eTag = data.get("etag");
        Object contentType = data.get("contentType");
        Object contentLength = data.get("contentLength");
        Object blobType = data.get("blobType");
        Object contentOffset = data.get("contentOffset");
        Object destinationUrl = data.get("destinationUrl");
        Object sourceUrl = data.get("sourceUrl");
        Object blobUrl = data.get("url");
        Object recursive = data.get("recursive");
        Object sequencer = data.get("sequencer");
        return new InternalBlobChangefeedEventData(ChangefeedTypeValidator.nullOr("api", api, String.class), ChangefeedTypeValidator.nullOr("clientRequestId", clientRequestId, String.class), ChangefeedTypeValidator.nullOr("requestId", requestId, String.class), ChangefeedTypeValidator.nullOr("etag", eTag, String.class), ChangefeedTypeValidator.nullOr("contentType", contentType, String.class), ChangefeedTypeValidator.nullOr("contentLength", contentLength, Long.class), ChangefeedTypeValidator.isNull(blobType) ? null : BlobType.fromString((String)ChangefeedTypeValidator.nullOr("blobType", blobType, String.class)), ChangefeedTypeValidator.nullOr("contentOffset", contentOffset, Long.class), ChangefeedTypeValidator.nullOr("destinationUrl", destinationUrl, String.class), ChangefeedTypeValidator.nullOr("sourceUrl", sourceUrl, String.class), ChangefeedTypeValidator.nullOr("url", blobUrl, String.class), Boolean.TRUE.equals(ChangefeedTypeValidator.nullOr("recursive", recursive, Boolean.class)), ChangefeedTypeValidator.nullOr("sequencer", sequencer, String.class));
    }

    @Override
    public String getApi() {
        return this.api;
    }

    @Override
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public BlobType getBlobType() {
        return this.blobType;
    }

    @Override
    public Long getContentOffset() {
        return this.contentOffset;
    }

    @Override
    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    @Override
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @Override
    public String getBlobUrl() {
        return this.blobUrl;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public String getSequencer() {
        return this.sequencer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalBlobChangefeedEventData)) {
            return false;
        }
        InternalBlobChangefeedEventData that = (InternalBlobChangefeedEventData)o;
        return Objects.equals(this.getApi(), that.getApi()) && Objects.equals(this.getClientRequestId(), that.getClientRequestId()) && Objects.equals(this.getRequestId(), that.getRequestId()) && Objects.equals(this.getETag(), that.getETag()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getContentLength(), that.getContentLength()) && this.getBlobType() == that.getBlobType() && Objects.equals(this.getContentOffset(), that.getContentOffset()) && Objects.equals(this.getDestinationUrl(), that.getDestinationUrl()) && Objects.equals(this.getSourceUrl(), that.getSourceUrl()) && Objects.equals(this.getBlobUrl(), that.getBlobUrl()) && Objects.equals(this.isRecursive(), that.isRecursive()) && Objects.equals(this.getSequencer(), that.getSequencer());
    }

    public int hashCode() {
        return Objects.hash(this.getApi(), this.getClientRequestId(), this.getRequestId(), this.getETag(), this.getContentType(), this.getContentLength(), this.getBlobType(), this.getContentOffset(), this.getDestinationUrl(), this.getSourceUrl(), this.getBlobUrl(), this.isRecursive(), this.getSequencer());
    }

    public String toString() {
        return "BlobChangefeedEventData{api='" + this.api + '\'' + ", clientRequestId='" + this.clientRequestId + '\'' + ", requestId='" + this.requestId + '\'' + ", eTag='" + this.eTag + '\'' + ", contentType='" + this.contentType + '\'' + ", contentLength=" + this.contentLength + ", blobType=" + this.blobType + ", contentOffset=" + this.contentOffset + ", destinationUrl='" + this.destinationUrl + '\'' + ", sourceUrl='" + this.sourceUrl + '\'' + ", blobUrl='" + this.blobUrl + '\'' + ", recursive=" + this.recursive + ", sequencer='" + this.sequencer + '\'' + '}';
    }
}

