/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.changefeed;

import com.azure.core.http.rest.ResponseBase;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.implementation.util.ChunkedDownloadUtils;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.common.ParallelTransferOptions;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class BlobChunkedDownloader {
    private final BlobAsyncClient client;
    private final long blockSize;
    private final BlobRange range;

    BlobChunkedDownloader(BlobAsyncClient client, long blockSize, long offset) {
        this.client = client;
        this.blockSize = blockSize;
        this.range = new BlobRange(offset);
    }

    BlobChunkedDownloader(BlobAsyncClient client, long totalSize) {
        this.client = client;
        this.blockSize = totalSize;
        this.range = new BlobRange(0L, Long.valueOf(totalSize));
    }

    public Flux<ByteBuffer> download() {
        ParallelTransferOptions options = new ParallelTransferOptions().setBlockSizeLong(Long.valueOf(this.blockSize));
        BlobRequestConditions requestConditions = new BlobRequestConditions();
        BiFunction<BlobRange, BlobRequestConditions, Mono> downloadFunc = (range, conditions) -> this.client.downloadWithResponse(range, null, conditions, false);
        return ChunkedDownloadUtils.downloadFirstChunk((BlobRange)this.range, (ParallelTransferOptions)options, (BlobRequestConditions)requestConditions, downloadFunc, (boolean)false).flatMapMany(setupTuple3 -> {
            long newCount = (Long)setupTuple3.getT1();
            BlobRequestConditions finalConditions = (BlobRequestConditions)setupTuple3.getT2();
            int numChunks = ChunkedDownloadUtils.calculateNumBlocks((long)newCount, (long)options.getBlockSizeLong());
            numChunks = numChunks == 0 ? 1 : numChunks;
            BlobDownloadAsyncResponse initialResponse = (BlobDownloadAsyncResponse)setupTuple3.getT3();
            return Flux.range((int)0, (int)numChunks).concatMap(chunkNum -> ChunkedDownloadUtils.downloadChunk((Integer)chunkNum, (BlobDownloadAsyncResponse)initialResponse, (BlobRange)this.range, (ParallelTransferOptions)options, (BlobRequestConditions)finalConditions, (long)newCount, (BiFunction)downloadFunc, ResponseBase::getValue));
        });
    }
}

