/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.specialized.cryptography.CryptographyConstants;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlob;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClientBuilder;
import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EncryptedBlobClientBuilder.class, isAsync=true)
public class EncryptedBlobAsyncClient
extends BlobAsyncClient {
    static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    private final ClientLogger logger = new ClientLogger(EncryptedBlobAsyncClient.class);
    private final AsyncKeyEncryptionKey keyWrapper;
    private final String keyWrapAlgorithm;

    EncryptedBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, AsyncKeyEncryptionKey key, String keyWrapAlgorithm, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.keyWrapper = key;
        this.keyWrapAlgorithm = keyWrapAlgorithm;
    }

    public EncryptedBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new EncryptedBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.keyWrapper, this.keyWrapAlgorithm, this.getVersionId());
    }

    public EncryptedBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new EncryptedBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.keyWrapper, this.keyWrapAlgorithm, this.getVersionId());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        try {
            return this.upload(data, parallelTransferOptions, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        try {
            Mono uploadTask = this.uploadWithResponse(data, parallelTransferOptions, null, null, null, null).flatMap(FluxUtil::toMono);
            if (overwrite) {
                return uploadTask;
            }
            return this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : uploadTask);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.uploadWithResponse(new BlobParallelUploadOptions(data).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(BlobParallelUploadOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            HashMap<String, String> metadataFinal = options.getMetadata() == null ? new HashMap() : options.getMetadata();
            Flux data = options.getDataFlux() == null ? Utility.convertStreamToByteBuffer((InputStream)options.getDataStream(), (long)options.getLength(), (int)0x400000, (boolean)false) : options.getDataFlux();
            Flux<ByteBuffer> dataFinal = this.prepareToSendEncryptedRequest((Flux<ByteBuffer>)data, metadataFinal);
            return super.uploadWithResponse(new BlobParallelUploadOptions(dataFinal).setParallelTransferOptions(options.getParallelTransferOptions()).setHeaders(options.getHeaders()).setMetadata(metadataFinal).setTags(options.getTags()).setTier(options.getTier()).setRequestConditions(options.getRequestConditions()).setComputeMd5(options.isComputeMd5()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath) {
        try {
            return this.uploadFromFile(filePath, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, boolean overwrite) {
        try {
            Mono<Void> uploadTask = this.uploadFromFile(filePath, null, null, null, null, null);
            if (overwrite) {
                return uploadTask;
            }
            return this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : uploadTask);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadFromFileWithResponse(BlobUploadFromFileOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return Mono.using(() -> UploadUtils.uploadFileResourceSupplier((String)options.getFilePath(), (ClientLogger)this.logger), channel -> this.uploadWithResponse(new BlobParallelUploadOptions(FluxUtil.readFile((AsynchronousFileChannel)channel)).setParallelTransferOptions(options.getParallelTransferOptions()).setHeaders(options.getHeaders()).setMetadata(options.getMetadata()).setTags(options.getTags()).setTier(options.getTier()).setRequestConditions(options.getRequestConditions())).doOnTerminate(() -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
                }
            }), channel -> UploadUtils.uploadFileCleanup((AsynchronousFileChannel)channel, (ClientLogger)this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<EncryptedBlob> encryptBlob(Flux<ByteBuffer> plainTextFlux) {
        Objects.requireNonNull(this.keyWrapper, "keyWrapper cannot be null");
        try {
            SecretKey aesKey = this.generateSecretKey();
            Cipher cipher = this.generateCipher(aesKey);
            HashMap<String, String> keyWrappingMetadata = new HashMap<String, String>();
            keyWrappingMetadata.put("EncryptionLibrary", CryptographyConstants.AGENT_METADATA_VALUE);
            return this.keyWrapper.getKeyId().flatMap(keyId -> this.keyWrapper.wrapKey(this.keyWrapAlgorithm, aesKey.getEncoded()).map(encryptedKey -> {
                WrappedKey wrappedKey = new WrappedKey((String)keyId, (byte[])encryptedKey, this.keyWrapAlgorithm);
                EncryptionData encryptionData = new EncryptionData().setEncryptionMode("FullBlob").setEncryptionAgent(new EncryptionAgent("1.0", EncryptionAlgorithm.AES_CBC_256)).setKeyWrappingMetadata(keyWrappingMetadata).setContentEncryptionIV(cipher.getIV()).setWrappedContentKey(wrappedKey);
                Flux encryptedTextFlux = plainTextFlux.map(plainTextBuffer -> {
                    int encryptedBytes;
                    int outputSize = cipher.getOutputSize(plainTextBuffer.remaining());
                    ByteBuffer encryptedTextBuffer = ByteBuffer.allocate(outputSize);
                    try {
                        encryptedBytes = cipher.update((ByteBuffer)plainTextBuffer, encryptedTextBuffer);
                    }
                    catch (ShortBufferException e) {
                        throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
                    }
                    encryptedTextBuffer.position(0);
                    encryptedTextBuffer.limit(encryptedBytes);
                    return encryptedTextBuffer;
                });
                encryptedTextFlux = Flux.concat((Publisher[])new Publisher[]{encryptedTextFlux, Mono.fromCallable(() -> ByteBuffer.wrap(cipher.doFinal()))});
                return new EncryptedBlob(encryptionData, (Flux<ByteBuffer>)encryptedTextFlux);
            }));
        }
        catch (GeneralSecurityException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        return keyGen.generateKey();
    }

    Cipher generateCipher(SecretKey aesKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, aesKey);
        return cipher;
    }

    private Flux<ByteBuffer> prepareToSendEncryptedRequest(Flux<ByteBuffer> plainText, Map<String, String> metadata) {
        return this.encryptBlob(plainText).flatMapMany(encryptedBlob -> {
            try {
                metadata.put("encryptiondata", encryptedBlob.getEncryptionData().toJsonString());
                return encryptedBlob.getCiphertextFlux();
            }
            catch (JsonProcessingException e) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
        });
    }

    public Flux<ByteBuffer> query(String expression) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side"));
    }

    public Mono<BlobQueryAsyncResponse> queryWithResponse(BlobQueryOptions queryOptions) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side"));
    }
}

