/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobAsyncClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EncryptedBlobClientBuilder.class)
public class EncryptedBlobClient
extends BlobClient {
    private final ClientLogger logger = new ClientLogger(EncryptedBlobClient.class);
    private final EncryptedBlobAsyncClient encryptedBlobAsyncClient;

    EncryptedBlobClient(EncryptedBlobAsyncClient encryptedBlobAsyncClient) {
        super((BlobAsyncClient)encryptedBlobAsyncClient);
        this.encryptedBlobAsyncClient = encryptedBlobAsyncClient;
    }

    public EncryptedBlobClient getEncryptionScopeClient(String encryptionScope) {
        return new EncryptedBlobClient(this.encryptedBlobAsyncClient.getEncryptionScopeAsyncClient(encryptionScope));
    }

    public EncryptedBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new EncryptedBlobClient(this.encryptedBlobAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey));
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(false);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.exists().booleanValue()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.getBlobOutputStream(null, null, null, null, requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(new BlockBlobOutputStreamOptions().setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    public BlobOutputStream getBlobOutputStream(BlockBlobOutputStreamOptions options) {
        return BlobOutputStream.blockBlobOutputStream((BlobAsyncClient)this.encryptedBlobAsyncClient, (BlockBlobOutputStreamOptions)options, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, boolean overwrite) {
        if (!overwrite && this.exists().booleanValue()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
        }
        this.uploadFromFile(filePath, null, null, null, null, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) throws UncheckedIOException {
        this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadFromFileWithResponse(BlobUploadFromFileOptions options, Duration timeout, Context context) throws UncheckedIOException {
        Mono upload = this.encryptedBlobAsyncClient.uploadFromFileWithResponse(options).subscriberContext(FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)e);
        }
    }

    public AppendBlobClient getAppendBlobClient() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as an append blob client"));
    }

    public BlockBlobClient getBlockBlobClient() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as a block blob client"));
    }

    public PageBlobClient getPageBlobClient() {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as an page blob client"));
    }

    public InputStream openQueryInputStream(String expression) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public Response<InputStream> openQueryInputStreamWithResponse(BlobQueryOptions queryOptions) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public void query(OutputStream stream, String expression) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public BlobQueryResponse queryWithResponse(BlobQueryOptions queryOptions, Duration timeout, Context context) {
        throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }
}

