/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.BlobRange;

final class EncryptedBlobRange {
    private final BlobRange originalRange;
    private final int offsetAdjustment;
    private Long adjustedDownloadCount;

    static EncryptedBlobRange getEncryptedBlobRangeFromHeader(String stringRange) {
        BlobRange range;
        if (CoreUtils.isNullOrEmpty((CharSequence)stringRange)) {
            return new EncryptedBlobRange(null);
        }
        String trimmed = stringRange.substring(stringRange.indexOf("=") + 1);
        String[] pieces = trimmed.split("-");
        long offset = Long.parseLong(pieces[0]);
        if (pieces.length == 1) {
            range = new BlobRange(offset);
        } else {
            long rangeEnd = Long.parseLong(pieces[1]);
            long count = rangeEnd - offset + 1L;
            range = new BlobRange(offset, Long.valueOf(count));
        }
        return new EncryptedBlobRange(range);
    }

    EncryptedBlobRange(BlobRange originalRange) {
        if (originalRange == null) {
            this.originalRange = new BlobRange(0L);
            this.offsetAdjustment = 0;
            return;
        }
        this.originalRange = originalRange;
        int tempOffsetAdjustment = 0;
        this.adjustedDownloadCount = this.originalRange.getCount();
        if (originalRange.getOffset() != 0L) {
            if (originalRange.getOffset() % 16L != 0L) {
                long diff = this.originalRange.getOffset() % 16L;
                tempOffsetAdjustment = (int)((long)tempOffsetAdjustment + diff);
                if (this.adjustedDownloadCount != null) {
                    this.adjustedDownloadCount = this.adjustedDownloadCount + diff;
                }
            }
            if (this.originalRange.getOffset() >= 16L) {
                tempOffsetAdjustment += 16;
                if (this.adjustedDownloadCount != null) {
                    this.adjustedDownloadCount = this.adjustedDownloadCount + 16L;
                }
            }
        }
        this.offsetAdjustment = tempOffsetAdjustment;
        if (this.adjustedDownloadCount != null) {
            this.adjustedDownloadCount = this.adjustedDownloadCount + (long)(16 - (int)(this.adjustedDownloadCount % 16L));
        }
    }

    BlobRange getOriginalRange() {
        return this.originalRange;
    }

    int getOffsetAdjustment() {
        return this.offsetAdjustment;
    }

    Long getAdjustedDownloadCount() {
        return this.adjustedDownloadCount;
    }

    void setAdjustedDownloadCount(long count) {
        this.adjustedDownloadCount = count;
    }

    BlobRange toBlobRange() {
        return new BlobRange(this.originalRange.getOffset() - (long)this.offsetAdjustment, this.adjustedDownloadCount);
    }
}

