/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

final class EncryptionData {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @JsonProperty(value="EncryptionMode")
    private String encryptionMode;
    @JsonProperty(value="WrappedContentKey", required=true)
    private WrappedKey wrappedContentKey;
    @JsonProperty(value="EncryptionAgent", required=true)
    private EncryptionAgent encryptionAgent;
    @JsonProperty(value="ContentEncryptionIV", required=true)
    private byte[] contentEncryptionIV;
    @JsonProperty(value="KeyWrappingMetadata", required=true)
    private Map<String, String> keyWrappingMetadata;

    EncryptionData() {
    }

    EncryptionData(String encryptionMode, WrappedKey wrappedContentKey, EncryptionAgent encryptionAgent, byte[] contentEncryptionIV, Map<String, String> keyWrappingMetadata) {
        this.encryptionMode = encryptionMode;
        this.wrappedContentKey = wrappedContentKey;
        this.encryptionAgent = encryptionAgent;
        this.contentEncryptionIV = contentEncryptionIV;
        this.keyWrappingMetadata = keyWrappingMetadata;
    }

    String getEncryptionMode() {
        return this.encryptionMode;
    }

    WrappedKey getWrappedContentKey() {
        return this.wrappedContentKey;
    }

    EncryptionAgent getEncryptionAgent() {
        return this.encryptionAgent;
    }

    byte[] getContentEncryptionIV() {
        return this.contentEncryptionIV;
    }

    Map<String, String> getKeyWrappingMetadata() {
        return this.keyWrappingMetadata;
    }

    EncryptionData setEncryptionMode(String encryptionMode) {
        this.encryptionMode = encryptionMode;
        return this;
    }

    EncryptionData setWrappedContentKey(WrappedKey wrappedContentKey) {
        this.wrappedContentKey = wrappedContentKey;
        return this;
    }

    EncryptionData setEncryptionAgent(EncryptionAgent encryptionAgent) {
        this.encryptionAgent = encryptionAgent;
        return this;
    }

    EncryptionData setContentEncryptionIV(byte[] contentEncryptionIV) {
        this.contentEncryptionIV = contentEncryptionIV;
        return this;
    }

    EncryptionData setKeyWrappingMetadata(Map<String, String> keyWrappingMetadata) {
        this.keyWrappingMetadata = keyWrappingMetadata;
        return this;
    }

    String toJsonString() throws JsonProcessingException {
        return MAPPER.writeValueAsString((Object)this);
    }

    static EncryptionData fromJsonString(String jsonString) throws JsonProcessingException {
        return (EncryptionData)MAPPER.readValue(jsonString, EncryptionData.class);
    }
}

