/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.EncryptionVersion;
import com.azure.storage.blob.specialized.cryptography.EncryptorV1;
import com.azure.storage.blob.specialized.cryptography.EncryptorV2;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Map;
import javax.crypto.SecretKey;
import reactor.core.publisher.Flux;

abstract class Encryptor {
    private static final ClientLogger LOGGER = new ClientLogger(Encryptor.class);
    protected final SecretKey aesKey;

    protected Encryptor(SecretKey aesKey) {
        this.aesKey = aesKey;
    }

    abstract byte[] getKeyToWrap();

    protected abstract Flux<ByteBuffer> encrypt(Flux<ByteBuffer> var1) throws GeneralSecurityException;

    protected EncryptionData buildEncryptionData(Map<String, String> keyWrappingMetadata, WrappedKey wrappedKey) {
        return new EncryptionData().setEncryptionMode("FullBlob").setKeyWrappingMetadata(keyWrappingMetadata).setWrappedContentKey(wrappedKey);
    }

    static Encryptor getEncryptor(EncryptionVersion version, SecretKey aesKey) throws GeneralSecurityException {
        switch (version) {
            case V1: {
                return new EncryptorV1(aesKey);
            }
            case V2: {
                return new EncryptorV2(aesKey);
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid encryption version: " + (Object)((Object)version)));
    }
}

