/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadContentAsyncResponse;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.specialized.cryptography.CryptographyConstants;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlob;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClientBuilder;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.EncryptionVersion;
import com.azure.storage.blob.specialized.cryptography.Encryptor;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=EncryptedBlobClientBuilder.class, isAsync=true)
public class EncryptedBlobAsyncClient
extends BlobAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptedBlobAsyncClient.class);
    private final AsyncKeyEncryptionKey keyWrapper;
    private final String keyWrapAlgorithm;
    private final EncryptionVersion encryptionVersion;
    private final boolean requiresEncryption;

    EncryptionScope getEncryptionScopeInternal() {
        return this.encryptionScope;
    }

    AsyncKeyEncryptionKey getKeyWrapper() {
        return this.keyWrapper;
    }

    String getKeyWrapAlgorithm() {
        return this.keyWrapAlgorithm;
    }

    EncryptionVersion getEncryptionVersion() {
        return this.encryptionVersion;
    }

    boolean isRequiresEncryption() {
        return this.requiresEncryption;
    }

    EncryptedBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, AsyncKeyEncryptionKey key, String keyWrapAlgorithm, String versionId, EncryptionVersion encryptionVersion, boolean requiresEncryption) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.keyWrapper = key;
        this.keyWrapAlgorithm = keyWrapAlgorithm;
        this.encryptionVersion = encryptionVersion;
        this.requiresEncryption = requiresEncryption;
    }

    public EncryptedBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new EncryptedBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.keyWrapper, this.keyWrapAlgorithm, this.getVersionId(), this.encryptionVersion, this.requiresEncryption);
    }

    public EncryptedBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new EncryptedBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.keyWrapper, this.keyWrapAlgorithm, this.getVersionId(), this.encryptionVersion, this.requiresEncryption);
    }

    boolean isEncryptionRequired() {
        return this.requiresEncryption;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        return this.upload(data, parallelTransferOptions, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        Mono uploadTask = this.uploadWithResponse(data, parallelTransferOptions, null, null, null, null).flatMap(FluxUtil::toMono);
        if (overwrite) {
            return uploadTask;
        }
        return this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : uploadTask);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        try {
            return this.uploadWithResponse(new BlobParallelUploadOptions(data).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(BlobParallelUploadOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            HashMap<String, String> metadataFinal = options.getMetadata() == null ? new HashMap() : options.getMetadata();
            ParallelTransferOptions parallelTransferOptions = ModelHelper.populateAndApplyDefaults((ParallelTransferOptions)options.getParallelTransferOptions());
            Flux data = options.getDataFlux();
            data = UploadUtils.extractByteBuffer((Flux)data, (Long)options.getOptionalLength(), (Long)parallelTransferOptions.getBlockSizeLong(), (InputStream)options.getDataStream());
            Flux<ByteBuffer> dataFinal = this.prepareToSendEncryptedRequest((Flux<ByteBuffer>)data, metadataFinal);
            return super.uploadWithResponse(new BlobParallelUploadOptions(dataFinal).setParallelTransferOptions(options.getParallelTransferOptions()).setHeaders(options.getHeaders()).setMetadata(metadataFinal).setTags(options.getTags()).setTier(options.getTier()).setRequestConditions(options.getRequestConditions()).setComputeMd5(options.isComputeMd5()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath) {
        return this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, boolean overwrite) {
        Mono<Void> uploadTask = this.uploadFromFile(filePath, null, null, null, null, null);
        if (overwrite) {
            return uploadTask;
        }
        return this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : uploadTask);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        try {
            return this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions)).then();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadFromFileWithResponse(BlobUploadFromFileOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            return Mono.using(() -> UploadUtils.uploadFileResourceSupplier((String)options.getFilePath(), (ClientLogger)LOGGER), channel -> this.uploadWithResponse(new BlobParallelUploadOptions(FluxUtil.readFile((AsynchronousFileChannel)channel)).setParallelTransferOptions(options.getParallelTransferOptions()).setHeaders(options.getHeaders()).setMetadata(options.getMetadata()).setTags(options.getTags()).setTier(options.getTier()).setRequestConditions(options.getRequestConditions())).doFinally(ignored -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
                }
            }), channel -> UploadUtils.uploadFileCleanup((AsynchronousFileChannel)channel, (ClientLogger)LOGGER));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<EncryptedBlob> encryptBlob(Flux<ByteBuffer> plainTextFlux) {
        Objects.requireNonNull(this.keyWrapper, "keyWrapper cannot be null");
        try {
            Encryptor encryptor = Encryptor.getEncryptor(this.encryptionVersion, this.generateSecretKey());
            HashMap<String, String> keyWrappingMetadata = new HashMap<String, String>();
            keyWrappingMetadata.put("EncryptionLibrary", CryptographyConstants.AGENT_METADATA_VALUE);
            byte[] keyToWrap = encryptor.getKeyToWrap();
            return this.keyWrapper.getKeyId().flatMap(keyId -> this.keyWrapper.wrapKey(this.keyWrapAlgorithm, keyToWrap).map(encryptedKey -> {
                Flux<ByteBuffer> encryptedTextFlux;
                EncryptionData encryptionData;
                WrappedKey wrappedKey = new WrappedKey((String)keyId, (byte[])encryptedKey, this.keyWrapAlgorithm);
                try {
                    encryptionData = encryptor.buildEncryptionData(keyWrappingMetadata, wrappedKey);
                    encryptedTextFlux = encryptor.encrypt(plainTextFlux);
                }
                catch (GeneralSecurityException e) {
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
                return new EncryptedBlob(encryptionData, encryptedTextFlux);
            }));
        }
        catch (GeneralSecurityException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        return keyGen.generateKey();
    }

    private Flux<ByteBuffer> prepareToSendEncryptedRequest(Flux<ByteBuffer> plainText, Map<String, String> metadata) {
        return this.encryptBlob(plainText).flatMapMany(encryptedBlob -> {
            try {
                metadata.put("encryptiondata", encryptedBlob.getEncryptionData().toJsonString());
                return encryptedBlob.getCiphertextFlux();
            }
            catch (JsonProcessingException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
        });
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ByteBuffer> download() {
        return this.downloadStream();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ByteBuffer> downloadStream() {
        return this.downloadStreamWithResponse(null, null, null, false).flatMapMany(ResponseBase::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> downloadContent() {
        return this.downloadContentWithResponse(null, null).flatMap(response -> BinaryData.fromFlux((Flux)((BinaryData)response.getValue()).toFluxByteBuffer()));
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobDownloadAsyncResponse> downloadWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5) {
        return this.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobDownloadAsyncResponse> downloadStreamWithResponse(BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5) {
        if (EncryptedBlobClient.isRangeRequest(range)) {
            return this.populateRequestConditionsAndContext(requestConditions, () -> super.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5));
        }
        return super.downloadStreamWithResponse(range, options, requestConditions, getRangeContentMd5);
    }

    private <T> Mono<T> populateRequestConditionsAndContext(BlobRequestConditions requestConditions, Supplier<Mono<T>> downloadCall) {
        return this.getPropertiesWithResponse(requestConditions).flatMap(response -> {
            BlobRequestConditions requestConditionsFinal = requestConditions == null ? new BlobRequestConditions() : requestConditions;
            requestConditionsFinal.setIfMatch(((BlobProperties)response.getValue()).getETag());
            Mono result = (Mono)downloadCall.get();
            if (((BlobProperties)response.getValue()).getMetadata().get("encryptiondata") != null) {
                result = result.contextWrite(context -> context.put((Object)"encryptiondata", (Object)EncryptionData.getAndValidateEncryptionData((String)((BlobProperties)response.getValue()).getMetadata().get("encryptiondata"), this.requiresEncryption)));
            }
            return result;
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobDownloadContentAsyncResponse> downloadContentWithResponse(DownloadRetryOptions options, BlobRequestConditions requestConditions) {
        return this.populateRequestConditionsAndContext(requestConditions, () -> super.downloadContentWithResponse(options, requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobProperties> downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobProperties> downloadToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, options, requestConditions, rangeGetContentMd5, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobProperties>> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions) {
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions((ParallelTransferOptions)ModelHelper.populateAndApplyDefaults((ParallelTransferOptions)parallelTransferOptions));
        return this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(options).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlobProperties>> downloadToFileWithResponse(BlobDownloadToFileOptions options) {
        options.setRequestConditions(options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions());
        return this.populateRequestConditionsAndContext(options.getRequestConditions(), () -> super.downloadToFileWithResponse(options));
    }

    public Flux<ByteBuffer> query(String expression) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side"));
    }

    public Mono<BlobQueryAsyncResponse> queryWithResponse(BlobQueryOptions queryOptions) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side"));
    }
}

