/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobDownloadContentResponse;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryResponse;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobDownloadToFileOptions;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.options.BlobQueryOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobAsyncClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClientBuilder;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@ServiceClient(builder=EncryptedBlobClientBuilder.class)
public class EncryptedBlobClient
extends BlobClient {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptedBlobClient.class);
    final EncryptedBlobAsyncClient encryptedBlobAsyncClient;

    EncryptedBlobClient(EncryptedBlobAsyncClient encryptedBlobAsyncClient) {
        super((BlobAsyncClient)encryptedBlobAsyncClient);
        this.encryptedBlobAsyncClient = encryptedBlobAsyncClient;
    }

    public EncryptedBlobClient getEncryptionScopeClient(String encryptionScope) {
        return new EncryptedBlobClient(this.encryptedBlobAsyncClient.getEncryptionScopeAsyncClient(encryptionScope));
    }

    public EncryptedBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new EncryptedBlobClient(this.encryptedBlobAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey));
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(false);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        return this.getBlobOutputStream(null, null, null, null, requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.getBlobOutputStream(new BlockBlobOutputStreamOptions().setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    public BlobOutputStream getBlobOutputStream(BlockBlobOutputStreamOptions options) {
        return BlobOutputStream.blockBlobOutputStream((BlobAsyncClient)this.encryptedBlobAsyncClient, (BlockBlobOutputStreamOptions)options, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, boolean overwrite) {
        if (!overwrite && this.exists().booleanValue()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
        }
        this.uploadFromFile(filePath, null, null, null, null, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) throws UncheckedIOException {
        this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadFromFileWithResponse(BlobUploadFromFileOptions options, Duration timeout, Context context) throws UncheckedIOException {
        Mono upload = this.encryptedBlobAsyncClient.uploadFromFileWithResponse(options).contextWrite((ContextView)FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath) {
        return this.downloadToFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobProperties downloadToFile(String filePath, boolean overwrite) {
        HashSet<OpenOption> openOptions = null;
        if (overwrite) {
            openOptions = new HashSet<OpenOption>();
            openOptions.add(StandardOpenOption.CREATE);
            openOptions.add(StandardOpenOption.TRUNCATE_EXISTING);
            openOptions.add(StandardOpenOption.READ);
            openOptions.add(StandardOpenOption.WRITE);
        }
        return (BlobProperties)this.downloadToFileWithResponse(filePath, null, null, null, null, false, openOptions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Duration timeout, Context context) {
        return this.downloadToFileWithResponse(filePath, range, parallelTransferOptions, downloadRetryOptions, requestConditions, rangeGetContentMd5, null, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(String filePath, BlobRange range, ParallelTransferOptions parallelTransferOptions, DownloadRetryOptions downloadRetryOptions, BlobRequestConditions requestConditions, boolean rangeGetContentMd5, Set<OpenOption> openOptions, Duration timeout, Context context) {
        com.azure.storage.common.ParallelTransferOptions finalParallelTransferOptions = ModelHelper.wrapBlobOptions((ParallelTransferOptions)ModelHelper.populateAndApplyDefaults((ParallelTransferOptions)parallelTransferOptions));
        return this.downloadToFileWithResponse(new BlobDownloadToFileOptions(filePath).setRange(range).setParallelTransferOptions(finalParallelTransferOptions).setDownloadRetryOptions(downloadRetryOptions).setRequestConditions(requestConditions).setRetrieveContentRangeMd5(rangeGetContentMd5).setOpenOptions(openOptions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobProperties> downloadToFileWithResponse(BlobDownloadToFileOptions options, Duration timeout, Context context) {
        context = context == null ? Context.NONE : context;
        options.setRequestConditions(options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions());
        context = this.populateRequestConditionsAndContext(options.getRequestConditions(), timeout, context);
        return super.downloadToFileWithResponse(options, timeout, context);
    }

    public BlobInputStream openInputStream() {
        return this.openInputStream((BlobRange)null, null);
    }

    public BlobInputStream openInputStream(BlobRange range, BlobRequestConditions requestConditions) {
        return this.openInputStream(new BlobInputStreamOptions().setRange(range).setRequestConditions(requestConditions));
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options) {
        return this.openInputStream(options, null);
    }

    public BlobInputStream openInputStream(BlobInputStreamOptions options, Context context) {
        context = context == null ? Context.NONE : context;
        options.setRequestConditions(options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions());
        context = this.populateRequestConditionsAndContext(options.getRequestConditions(), null, context);
        return super.openInputStream(options, context);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void download(OutputStream stream) {
        this.downloadStream(stream);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadStream(OutputStream stream) {
        this.downloadStreamWithResponse(stream, null, null, null, false, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData downloadContent() {
        return (BinaryData)this.downloadContentWithResponse(null, null, null, null).getValue();
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        return this.downloadStreamWithResponse(stream, range, options, requestConditions, getRangeContentMd5, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadResponse downloadStreamWithResponse(OutputStream stream, BlobRange range, DownloadRetryOptions options, BlobRequestConditions requestConditions, boolean getRangeContentMd5, Duration timeout, Context context) {
        if (EncryptedBlobClient.isRangeRequest(range)) {
            context = context == null ? Context.NONE : context;
            requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
            context = this.populateRequestConditionsAndContext(requestConditions, timeout, context);
        }
        return super.downloadStreamWithResponse(stream, range, options, requestConditions, getRangeContentMd5, timeout, context);
    }

    static boolean isRangeRequest(BlobRange range) {
        return range != null && (range.getOffset() != 0L || range.getCount() != null);
    }

    private Context populateRequestConditionsAndContext(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        BlobProperties initialProperties = (BlobProperties)this.getPropertiesWithResponse(requestConditions, timeout, context).getValue();
        requestConditions.setIfMatch(initialProperties.getETag());
        if (initialProperties.getMetadata().get("encryptiondata") != null) {
            context = context.addData((Object)"encryptiondata", (Object)EncryptionData.getAndValidateEncryptionData((String)initialProperties.getMetadata().get("encryptiondata"), this.encryptedBlobAsyncClient.isEncryptionRequired()));
        }
        return context;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobDownloadContentResponse downloadContentWithResponse(DownloadRetryOptions options, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        context = context == null ? Context.NONE : context;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = this.populateRequestConditionsAndContext(requestConditions, timeout, context);
        return super.downloadContentWithResponse(options, requestConditions, timeout, context);
    }

    public AppendBlobClient getAppendBlobClient() {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as an append blob client"));
    }

    public BlockBlobClient getBlockBlobClient() {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as a block blob client"));
    }

    public PageBlobClient getPageBlobClient() {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot get an encrypted client as an page blob client"));
    }

    public InputStream openQueryInputStream(String expression) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public Response<InputStream> openQueryInputStreamWithResponse(BlobQueryOptions queryOptions) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public void query(OutputStream stream, String expression) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }

    public BlobQueryResponse queryWithResponse(BlobQueryOptions queryOptions, Duration timeout, Context context) {
        throw LOGGER.logExceptionAsError((RuntimeException)new UnsupportedOperationException("Cannot query data encrypted on client side."));
    }
}

