/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.CryptographyConstants;
import com.azure.storage.blob.specialized.cryptography.EncryptedRegionInfo;
import com.azure.storage.blob.specialized.cryptography.EncryptionAgent;
import com.azure.storage.blob.specialized.cryptography.EncryptionAlgorithm;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import com.azure.storage.blob.specialized.cryptography.Encryptor;
import com.azure.storage.blob.specialized.cryptography.WrappedKey;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.BufferAggregator;
import com.azure.storage.common.implementation.BufferStagingArea;
import com.azure.storage.common.implementation.UploadUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class EncryptorV2
extends Encryptor {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptorV2.class);

    protected EncryptorV2(SecretKey aesKey) {
        super(aesKey);
    }

    @Override
    byte[] getKeyToWrap() {
        try {
            ByteArrayOutputStream keyStream = new ByteArrayOutputStream(40);
            keyStream.write("2.0".getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < 5; ++i) {
                keyStream.write(0);
            }
            keyStream.write(this.aesKey.getEncoded());
            return keyStream.toByteArray();
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    protected EncryptionData buildEncryptionData(Map<String, String> keyWrappingMetadata, WrappedKey wrappedKey) {
        return super.buildEncryptionData(keyWrappingMetadata, wrappedKey).setEncryptionAgent(new EncryptionAgent("2.0", EncryptionAlgorithm.AES_GCM_256)).setEncryptedRegionInfo(new EncryptedRegionInfo(0x400000, 12));
    }

    private Cipher getCipher(int index) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        byte[] iv = ByteBuffer.allocate(12).putLong(index).array();
        cipher.init(1, (Key)this.aesKey, new GCMParameterSpec(128, iv));
        return cipher;
    }

    @Override
    protected Flux<ByteBuffer> encrypt(Flux<ByteBuffer> plainTextFlux) {
        BufferStagingArea stagingArea = new BufferStagingArea(0x400000L, 0x400000L);
        Flux encryptedTextFlux = UploadUtils.chunkSource(plainTextFlux, (ParallelTransferOptions)new ParallelTransferOptions().setBlockSizeLong(Long.valueOf(0x400000L))).flatMapSequential(arg_0 -> ((BufferStagingArea)stagingArea).write(arg_0), 1, 1).concatWith((Publisher)Flux.defer(() -> ((BufferStagingArea)stagingArea).flush())).index().flatMapSequential(tuple -> {
            Cipher gcmCipher;
            try {
                gcmCipher = this.getCipher(((Long)tuple.getT1()).intValue());
            }
            catch (GeneralSecurityException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
            ByteBuffer encryptedRegion = ByteBuffer.allocate(0x400010);
            Flux cipherTextWithTag = ((BufferAggregator)tuple.getT2()).asFlux().map(buffer -> {
                try {
                    gcmCipher.update((ByteBuffer)buffer, encryptedRegion);
                }
                catch (ShortBufferException e) {
                    throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
                }
                return encryptedRegion;
            }).then(Mono.fromCallable(() -> {
                gcmCipher.doFinal(CryptographyConstants.EMPTY_BUFFER, encryptedRegion);
                encryptedRegion.flip();
                return encryptedRegion;
            })).flux();
            return Flux.concat((Publisher[])new Publisher[]{Flux.just((Object)ByteBuffer.wrap(gcmCipher.getIV())), cipherTextWithTag});
        }, 1, 1);
        return encryptedTextFlux;
    }
}

