/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.BlobUserAgentModificationPolicy;
import com.azure.storage.blob.implementation.util.BuilderHelper;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.specialized.cryptography.BlobDecryptionPolicy;
import com.azure.storage.blob.specialized.cryptography.CryptographyConstants;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobAsyncClient;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobClient;
import com.azure.storage.blob.specialized.cryptography.EncryptionVersion;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.BuilderUtils;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.implementation.credentials.CredentialValidator;
import com.azure.storage.common.policy.MetadataValidationPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ServiceClientBuilder(serviceClients={EncryptedBlobAsyncClient.class, EncryptedBlobClient.class})
public final class EncryptedBlobClientBuilder
implements TokenCredentialTrait<EncryptedBlobClientBuilder>,
ConnectionStringTrait<EncryptedBlobClientBuilder>,
AzureNamedKeyCredentialTrait<EncryptedBlobClientBuilder>,
AzureSasCredentialTrait<EncryptedBlobClientBuilder>,
HttpTrait<EncryptedBlobClientBuilder>,
ConfigurationTrait<EncryptedBlobClientBuilder>,
EndpointTrait<EncryptedBlobClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptedBlobClientBuilder.class);
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-storage-blob-cryptography.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");
    private static final String BLOB_CLIENT_NAME = CryptographyConstants.USER_AGENT_PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String BLOB_CLIENT_VERSION = CryptographyConstants.USER_AGENT_PROPERTIES.getOrDefault("version", "UnknownVersion");
    private static final String USER_AGENT_MODIFICATION_REGEX = "(.*? )?(azsdk-java-azure-storage-blob/12\\.\\d{1,2}\\.\\d{1,2}(?:-beta\\.\\d{1,2})?)( .*?)?";
    private String endpoint;
    private String accountName;
    private String containerName;
    private String blobName;
    private String snapshot;
    private String versionId;
    private boolean requiresEncryption;
    private final EncryptionVersion encryptionVersion;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private AsyncKeyEncryptionKey keyWrapper;
    private AsyncKeyEncryptionKeyResolver keyResolver;
    private String keyWrapAlgorithm;
    private BlobServiceVersion version;
    private CpkInfo customerProvidedKey;
    private EncryptionScope encryptionScope;

    @Deprecated
    public EncryptedBlobClientBuilder() {
        this.logOptions = EncryptedBlobClientBuilder.getDefaultHttpLogOptions();
        this.encryptionVersion = EncryptionVersion.V1;
        LOGGER.warning("Client is being configured to use v1 of client side encryption, which is no longer considered secure. The default is v1 for compatibility reasons, but it is highlyrecommended the version be set to v2 using the constructor");
    }

    public EncryptedBlobClientBuilder(EncryptionVersion version) {
        Objects.requireNonNull(version);
        this.logOptions = EncryptedBlobClientBuilder.getDefaultHttpLogOptions();
        this.encryptionVersion = version;
        if (EncryptionVersion.V1.equals((Object)this.encryptionVersion)) {
            LOGGER.warning("Client is being configured to use v1 of client side encryption, which is no longer considered secure. The default is v1 for compatibility reasons, but it is highlyrecommended the version be set to v2 using the constructor");
        }
    }

    public EncryptedBlobClient buildEncryptedBlobClient() {
        return new EncryptedBlobClient(this.buildEncryptedBlobAsyncClient());
    }

    public EncryptedBlobAsyncClient buildEncryptedBlobAsyncClient() {
        Objects.requireNonNull(this.blobName, "'blobName' cannot be null.");
        this.checkValidEncryptionParameters();
        if (CoreUtils.isNullOrEmpty((CharSequence)this.containerName)) {
            this.containerName = "$root";
        }
        BlobServiceVersion serviceVersion = this.version != null ? this.version : BlobServiceVersion.getLatest();
        return new EncryptedBlobAsyncClient(this.addBlobUserAgentModificationPolicy(this.getHttpPipeline()), this.endpoint, serviceVersion, this.accountName, this.containerName, this.blobName, this.snapshot, this.customerProvidedKey, this.encryptionScope, this.keyWrapper, this.keyWrapAlgorithm, this.versionId, this.encryptionVersion, this.requiresEncryption);
    }

    private HttpPipeline addBlobUserAgentModificationPolicy(HttpPipeline pipeline) {
        ArrayList<Object> policies = new ArrayList<Object>();
        for (int i = 0; i < pipeline.getPolicyCount(); ++i) {
            HttpPipelinePolicy currPolicy = pipeline.getPolicy(i);
            policies.add(currPolicy);
            if (!(currPolicy instanceof UserAgentPolicy)) continue;
            policies.add(new BlobUserAgentModificationPolicy(CLIENT_NAME, CLIENT_VERSION));
        }
        return new HttpPipelineBuilder().httpClient(pipeline.getHttpClient()).policies(policies.toArray(new HttpPipelinePolicy[0])).tracer(pipeline.getTracer()).build();
    }

    private String modifyUserAgentString(String applicationId, Configuration userAgentConfiguration) {
        Pattern pattern = Pattern.compile(USER_AGENT_MODIFICATION_REGEX);
        String userAgent = UserAgentUtil.toUserAgentString((String)applicationId, (String)BLOB_CLIENT_NAME, (String)BLOB_CLIENT_VERSION, (Configuration)userAgentConfiguration);
        Matcher matcher = pattern.matcher(userAgent);
        String version = this.encryptionVersion == EncryptionVersion.V2 ? "2.0" : "1.0";
        String stringToAppend = "azstorage-clientsideencryption/" + version;
        if (matcher.matches() && !userAgent.contains(stringToAppend)) {
            String segment1 = matcher.group(1) == null ? "" : matcher.group(1);
            String segment2 = matcher.group(2) == null ? "" : matcher.group(2);
            String segment3 = matcher.group(3) == null ? "" : matcher.group(3);
            userAgent = segment1 + stringToAppend + " " + segment2 + segment3;
        }
        return userAgent;
    }

    private HttpPipeline getHttpPipeline() {
        CredentialValidator.validateSingleCredentialIsPresent((StorageSharedKeyCredential)this.storageSharedKeyCredential, (TokenCredential)this.tokenCredential, (AzureSasCredential)this.azureSasCredential, (String)this.sasToken, (ClientLogger)LOGGER);
        if (this.httpPipeline != null) {
            ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
            boolean decryptionPolicyPresent = false;
            for (int i = 0; i < this.httpPipeline.getPolicyCount(); ++i) {
                HttpPipelinePolicy currPolicy = this.httpPipeline.getPolicy(i);
                if (currPolicy instanceof BlobDecryptionPolicy) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The passed pipeline was already configured for encryption/decryption in a way that might conflict with the passed key information. Please ensure that the passed pipeline is not already configured for encryption/decryption"));
                }
                policies.add(currPolicy);
            }
            policies.add(0, new BlobDecryptionPolicy(this.keyWrapper, this.keyResolver, this.requiresEncryption));
            return new HttpPipelineBuilder().httpClient(this.httpPipeline.getHttpClient()).tracer(this.httpPipeline.getTracer()).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
        }
        Configuration userAgentConfiguration = this.configuration == null ? Configuration.NONE : this.configuration;
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new BlobDecryptionPolicy(this.keyWrapper, this.keyResolver, this.requiresEncryption));
        String applicationId = this.clientOptions.getApplicationId() != null ? this.clientOptions.getApplicationId() : this.logOptions.getApplicationId();
        String modifiedUserAgent = this.modifyUserAgentString(applicationId, userAgentConfiguration);
        policies.add(new UserAgentPolicy(modifiedUserAgent));
        policies.add(new RequestIdPolicy());
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(BuilderUtils.createRetryPolicy((RequestRetryOptions)this.retryOptions, (RetryOptions)this.coreRetryOptions, (ClientLogger)LOGGER));
        policies.add(new AddDatePolicy());
        HttpHeaders headers = new HttpHeaders();
        this.clientOptions.getHeaders().forEach(header -> headers.put(header.getName(), header.getValue()));
        if (headers.getSize() > 0) {
            policies.add(new AddHeadersPolicy(headers));
        }
        policies.add(new MetadataValidationPolicy());
        if (this.storageSharedKeyCredential != null) {
            policies.add(new StorageSharedKeyCredentialPolicy(this.storageSharedKeyCredential));
        } else if (this.tokenCredential != null) {
            BuilderHelper.httpsValidation((Object)this.tokenCredential, (String)"bearer token", (String)this.endpoint, (ClientLogger)LOGGER);
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{"https://storage.azure.com/.default"}));
        } else if (this.azureSasCredential != null) {
            policies.add(new AzureSasCredentialPolicy(this.azureSasCredential, false));
        } else if (this.sasToken != null) {
            policies.add(new AzureSasCredentialPolicy(new AzureSasCredential(this.sasToken), false));
        }
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").addOptionalEcho("x-ms-encryption-key-sha256").build());
        policies.add(new HttpLoggingPolicy(this.logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer(BuilderHelper.createTracer((ClientOptions)this.clientOptions)).build();
    }

    public EncryptedBlobClientBuilder key(AsyncKeyEncryptionKey key, String keyWrapAlgorithm) {
        this.keyWrapper = key;
        this.keyWrapAlgorithm = keyWrapAlgorithm;
        return this;
    }

    public EncryptedBlobClientBuilder keyResolver(AsyncKeyEncryptionKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
        return this;
    }

    private void checkValidEncryptionParameters() {
        if (this.keyWrapper == null && this.keyResolver == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key and KeyResolver cannot both be null"));
        }
        if (this.keyWrapper != null && this.keyWrapAlgorithm == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Key Wrap Algorithm must be specified with a Key."));
        }
    }

    public EncryptedBlobClientBuilder credential(StorageSharedKeyCredential credential) {
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public EncryptedBlobClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential((AzureNamedKeyCredential)credential));
    }

    public EncryptedBlobClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public EncryptedBlobClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public EncryptedBlobClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public EncryptedBlobClientBuilder setAnonymousAccess() {
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        this.sasToken = null;
        return this;
    }

    public EncryptedBlobClientBuilder connectionString(String connectionString) {
        StorageAuthenticationSettings authSettings;
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)LOGGER);
        StorageEndpoint endpoint = storageConnectionString.getBlobEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive blob service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        if (storageConnectionString.getAccountName() != null) {
            this.accountName = storageConnectionString.getAccountName();
        }
        if ((authSettings = storageConnectionString.getStorageAuthSettings()).getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new StorageSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public EncryptedBlobClientBuilder endpoint(String endpoint) {
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse((URL)url);
            this.accountName = parts.getAccountName();
            this.endpoint = BuilderHelper.getEndpoint((BlobUrlParts)parts);
            this.containerName = parts.getBlobContainerName() == null ? this.containerName : parts.getBlobContainerName();
            this.blobName = parts.getBlobName() == null ? this.blobName : parts.getBlobName();
            this.snapshot = parts.getSnapshot();
            this.versionId = parts.getVersionId();
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty((CharSequence)sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Storage Blob endpoint url is malformed.", ex));
        }
        return this;
    }

    public EncryptedBlobClientBuilder containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public EncryptedBlobClientBuilder blobName(String blobName) {
        this.blobName = Objects.requireNonNull(blobName, "'blobName' cannot be null.");
        return this;
    }

    public EncryptedBlobClientBuilder snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public EncryptedBlobClientBuilder versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    public EncryptedBlobClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public EncryptedBlobClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public EncryptedBlobClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    public EncryptedBlobClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public EncryptedBlobClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public EncryptedBlobClientBuilder retryOptions(RetryOptions retryOptions) {
        this.coreRetryOptions = retryOptions;
        return this;
    }

    public EncryptedBlobClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public EncryptedBlobClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public EncryptedBlobClientBuilder serviceVersion(BlobServiceVersion version) {
        this.version = version;
        return this;
    }

    public EncryptedBlobClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        this.customerProvidedKey = customerProvidedKey == null ? null : new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        return this;
    }

    public EncryptedBlobClientBuilder encryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope == null ? null : new EncryptionScope().setEncryptionScope(encryptionScope);
        return this;
    }

    public EncryptedBlobClientBuilder blobClient(BlobClient blobClient) {
        Objects.requireNonNull(blobClient);
        return this.client(blobClient.getHttpPipeline(), blobClient.getBlobUrl(), blobClient.getServiceVersion());
    }

    public EncryptedBlobClientBuilder blobAsyncClient(BlobAsyncClient blobAsyncClient) {
        Objects.requireNonNull(blobAsyncClient);
        return this.client(blobAsyncClient.getHttpPipeline(), blobAsyncClient.getBlobUrl(), blobAsyncClient.getServiceVersion());
    }

    private EncryptedBlobClientBuilder client(HttpPipeline httpPipeline, String endpoint, BlobServiceVersion version) {
        this.endpoint(endpoint);
        this.serviceVersion(version);
        return this.pipeline(httpPipeline);
    }

    public EncryptedBlobClientBuilder requiresEncryption(boolean requiresEncryption) {
        this.requiresEncryption = requiresEncryption;
        return this;
    }
}

