/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.azure.core.cryptography.AsyncKeyEncryptionKeyResolver;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.specialized.cryptography.Decryptor;
import com.azure.storage.blob.specialized.cryptography.EncryptedBlobRange;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

class DecryptorV1
extends Decryptor {
    private static final ClientLogger LOGGER = new ClientLogger(DecryptorV1.class);

    protected DecryptorV1(AsyncKeyEncryptionKeyResolver keyResolver, AsyncKeyEncryptionKey keyWrapper, EncryptionData encryptionData) {
        super(keyResolver, keyWrapper, encryptionData);
    }

    @Override
    Flux<ByteBuffer> decrypt(Flux<ByteBuffer> encryptedFlux, EncryptedBlobRange encryptedBlobRange, boolean padding, String requestUri, AtomicLong totalInputBytes, byte[] contentEncryptionKey) {
        Cipher cipher;
        LOGGER.warning("Downloaded data found to be encrypted with v1 encryption, which is no longer secure. Path: " + requestUri);
        byte[] iv = encryptedBlobRange.getOffsetAdjustment() <= 16 ? this.encryptionData.getContentEncryptionIV() : new byte[16];
        try {
            cipher = this.getCipher(contentEncryptionKey, iv, padding);
        }
        catch (InvalidKeyException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
        return encryptedFlux.map(encryptedByteBuffer -> {
            ByteBuffer plaintextByteBuffer = ByteBuffer.allocate(cipher.getOutputSize(encryptedByteBuffer.remaining()));
            int bytesToInput = encryptedByteBuffer.remaining();
            try {
                if (totalInputBytes.longValue() + (long)bytesToInput >= encryptedBlobRange.getAdjustedDownloadCount()) {
                    cipher.doFinal((ByteBuffer)encryptedByteBuffer, plaintextByteBuffer);
                } else {
                    cipher.update((ByteBuffer)encryptedByteBuffer, plaintextByteBuffer);
                }
            }
            catch (GeneralSecurityException e) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
            totalInputBytes.addAndGet(bytesToInput);
            plaintextByteBuffer.flip();
            return plaintextByteBuffer;
        });
    }

    @Override
    protected Cipher getCipher(byte[] contentEncryptionKey, byte[] iv, boolean padding) throws InvalidKeyException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(contentEncryptionKey, 0, contentEncryptionKey.length, "AES");
            Cipher cipher = padding ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance("AES/CBC/NoPadding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)keySpec, ivParameterSpec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }
}

