/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized.cryptography;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.specialized.cryptography.EncryptionData;

final class EncryptedBlobRange {
    private static final ClientLogger LOGGER = new ClientLogger(EncryptedBlobRange.class);
    private final BlobRange originalRange;
    private final int offsetAdjustment;
    private Long adjustedDownloadCount;
    private final long amountPlaintextToSkip;

    static EncryptedBlobRange getEncryptedBlobRangeFromHeader(String stringRange, EncryptionData encryptionData) {
        BlobRange range;
        if (encryptionData == null) {
            return null;
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)stringRange)) {
            return new EncryptedBlobRange(null, null);
        }
        String trimmed = stringRange.substring(stringRange.indexOf("=") + 1);
        String[] pieces = trimmed.split("-");
        long offset = Long.parseLong(pieces[0]);
        if (pieces.length == 1) {
            range = new BlobRange(offset);
        } else {
            long rangeEnd = Long.parseLong(pieces[1]);
            long count = rangeEnd - offset + 1L;
            range = new BlobRange(offset, Long.valueOf(count));
        }
        return new EncryptedBlobRange(range, encryptionData);
    }

    EncryptedBlobRange(BlobRange originalRange, EncryptionData encryptionData) {
        if (originalRange == null) {
            this.originalRange = new BlobRange(0L);
            this.offsetAdjustment = 0;
            this.amountPlaintextToSkip = 0L;
            return;
        }
        this.originalRange = originalRange;
        int tempOffsetAdjustment = 0;
        this.adjustedDownloadCount = this.originalRange.getCount();
        switch (encryptionData.getEncryptionAgent().getProtocol()) {
            case "1.0": {
                if (originalRange.getOffset() != 0L) {
                    if (originalRange.getOffset() % 16L != 0L) {
                        long diff = this.originalRange.getOffset() % 16L;
                        tempOffsetAdjustment = (int)((long)tempOffsetAdjustment + diff);
                        if (this.adjustedDownloadCount != null) {
                            this.adjustedDownloadCount = this.adjustedDownloadCount + diff;
                        }
                    }
                    if (this.originalRange.getOffset() >= 16L) {
                        tempOffsetAdjustment += 16;
                        if (this.adjustedDownloadCount != null) {
                            this.adjustedDownloadCount = this.adjustedDownloadCount + 16L;
                        }
                    }
                }
                this.offsetAdjustment = tempOffsetAdjustment;
                if (this.adjustedDownloadCount != null) {
                    this.adjustedDownloadCount = this.adjustedDownloadCount + (long)(16 - (int)(this.adjustedDownloadCount % 16L));
                }
                this.amountPlaintextToSkip = this.offsetAdjustment;
                break;
            }
            case "2.0": 
            case "2.1": {
                long authenticatedRegionDataLength = encryptionData.getEncryptedRegionInfo().getDataLength();
                long regionNumber = originalRange.getOffset() / authenticatedRegionDataLength;
                long regionStartOffset = regionNumber * (12L + authenticatedRegionDataLength + 16L);
                this.amountPlaintextToSkip = originalRange.getOffset() - regionNumber * authenticatedRegionDataLength;
                if (originalRange.getCount() != null) {
                    regionNumber = (originalRange.getOffset() + originalRange.getCount() - 1L) / authenticatedRegionDataLength;
                    long regionEndOffset = (regionNumber + 1L) * (12L + authenticatedRegionDataLength + 16L);
                    this.adjustedDownloadCount = regionEndOffset - regionStartOffset;
                }
                this.offsetAdjustment = (int)(originalRange.getOffset() - regionStartOffset);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unexpected protocol version"));
            }
        }
    }

    BlobRange getOriginalRange() {
        return this.originalRange;
    }

    int getOffsetAdjustment() {
        return this.offsetAdjustment;
    }

    int getAmountPlaintextToSkip() {
        return (int)this.amountPlaintextToSkip;
    }

    Long getAdjustedDownloadCount() {
        return this.adjustedDownloadCount;
    }

    void setAdjustedDownloadCount(long count) {
        this.adjustedDownloadCount = count;
    }

    BlobRange toBlobRange() {
        return new BlobRange(this.originalRange.getOffset() - (long)this.offsetAdjustment, this.adjustedDownloadCount);
    }
}

