/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class BlobContainerClient {
    private final BlobContainerAsyncClient client;
    public static final String ROOT_CONTAINER_NAME = "$root";
    public static final String STATIC_WEBSITE_CONTAINER_NAME = "$web";
    public static final String LOG_CONTAINER_NAME = "$logs";

    BlobContainerClient(BlobContainerAsyncClient client) {
        this.client = client;
    }

    public BlobClient getBlobClient(String blobName) {
        return new BlobClient(this.client.getBlobAsyncClient(blobName));
    }

    public BlobClient getBlobClient(String blobName, String snapshot) {
        return new BlobClient(this.client.getBlobAsyncClient(blobName, snapshot));
    }

    public BlobClient getBlobVersionClient(String blobName, String versionId) {
        return new BlobClient(this.client.getBlobVersionAsyncClient(blobName, versionId));
    }

    public String getBlobContainerName() {
        return this.client.getBlobContainerName();
    }

    public String getAccountUrl() {
        return this.client.getAccountUrl();
    }

    public String getBlobContainerUrl() {
        return this.client.getBlobContainerUrl();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public BlobServiceClient getServiceClient() {
        return this.client.getServiceClientBuilder().buildClient();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public HttpPipeline getHttpPipeline() {
        return this.client.getHttpPipeline();
    }

    public CpkInfo getCustomerProvidedKey() {
        return this.client.getCustomerProvidedKey();
    }

    public String getEncryptionScope() {
        return this.client.getEncryptionScope();
    }

    public boolean exists() {
        return (Boolean)this.existsWithResponse(null, Context.NONE).getValue();
    }

    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        Mono<Response<Boolean>> response = this.client.existsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void create() {
        this.createWithResponse(null, null, null, Context.NONE);
    }

    public Response<Void> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.createWithResponse(metadata, accessType, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE);
    }

    public Response<Void> deleteWithResponse(BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.deleteWithResponse(requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public BlobContainerProperties getProperties() {
        return (BlobContainerProperties)this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    public Response<BlobContainerProperties> getPropertiesWithResponse(String leaseId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.getPropertiesWithResponse(leaseId, context), (Duration)timeout);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setMetadataWithResponse(metadata, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public BlobContainerAccessPolicies getAccessPolicy() {
        return (BlobContainerAccessPolicies)this.getAccessPolicyWithResponse(null, null, Context.NONE).getValue();
    }

    public Response<BlobContainerAccessPolicies> getAccessPolicyWithResponse(String leaseId, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.getAccessPolicyWithResponse(leaseId, context), (Duration)timeout);
    }

    public void setAccessPolicy(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers) {
        this.setAccessPolicyWithResponse(accessType, identifiers, null, null, Context.NONE);
    }

    public Response<Void> setAccessPolicyWithResponse(PublicAccessType accessType, List<BlobSignedIdentifier> identifiers, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.client.setAccessPolicyWithResponse(accessType, identifiers, requestConditions, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public PagedIterable<BlobItem> listBlobs() {
        return this.listBlobs(new ListBlobsOptions(), null);
    }

    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, Duration timeout) {
        return this.listBlobs(options, null, timeout);
    }

    public PagedIterable<BlobItem> listBlobs(ListBlobsOptions options, String continuationToken, Duration timeout) {
        return new PagedIterable(this.client.listBlobsFlatWithOptionalTimeout(options, continuationToken, timeout));
    }

    public PagedIterable<BlobItem> listBlobsByHierarchy(String directory) {
        return this.listBlobsByHierarchy("/", new ListBlobsOptions().setPrefix(directory), null);
    }

    public PagedIterable<BlobItem> listBlobsByHierarchy(String delimiter, ListBlobsOptions options, Duration timeout) {
        return new PagedIterable(this.client.listBlobsHierarchyWithOptionalTimeout(delimiter, options, timeout));
    }

    public StorageAccountInfo getAccountInfo(Duration timeout) {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(timeout, Context.NONE).getValue();
    }

    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Mono<Response<StorageAccountInfo>> response = this.client.getAccountInfoWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey);
    }

    public String generateUserDelegationSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.client.generateUserDelegationSas(blobServiceSasSignatureValues, userDelegationKey, accountName, context);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues) {
        return this.client.generateSas(blobServiceSasSignatureValues);
    }

    public String generateSas(BlobServiceSasSignatureValues blobServiceSasSignatureValues, Context context) {
        return this.client.generateSas(blobServiceSasSignatureValues, context);
    }
}

