// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Map;

/** An Azure Storage blob. */
@JacksonXmlRootElement(localName = "Blob")
@Fluent
public final class BlobItemInternal {
    /*
     * The Name property.
     */
    @JsonProperty(value = "Name", required = true)
    private String name;

    /*
     * The Deleted property.
     */
    @JsonProperty(value = "Deleted", required = true)
    private boolean deleted;

    /*
     * The Snapshot property.
     */
    @JsonProperty(value = "Snapshot", required = true)
    private String snapshot;

    /*
     * The VersionId property.
     */
    @JsonProperty(value = "VersionId", required = true)
    private String versionId;

    /*
     * The IsCurrentVersion property.
     */
    @JsonProperty(value = "IsCurrentVersion")
    private Boolean isCurrentVersion;

    /*
     * Properties of a blob
     */
    @JsonProperty(value = "Properties", required = true)
    private BlobItemPropertiesInternal properties;

    /*
     * Dictionary of <string>
     */
    @JsonProperty(value = "Metadata")
    private Map<String, String> metadata;

    /*
     * Blob tags
     */
    @JsonProperty(value = "Tags")
    private BlobTags blobTags;

    /*
     * Dictionary of <string>
     */
    @JsonProperty(value = "OrMetadata")
    private Map<String, String> objectReplicationMetadata;

    /*
     * The HasVersionsOnly property.
     */
    @JsonProperty(value = "HasVersionsOnly")
    private Boolean hasVersionsOnly;

    /*
     * The IsPrefix property.
     */
    @JsonProperty(value = "IsPrefix")
    private Boolean isPrefix;

    /**
     * Get the name property: The Name property.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     *
     * @param name the name value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the deleted property: The Deleted property.
     *
     * @return the deleted value.
     */
    public boolean isDeleted() {
        return this.deleted;
    }

    /**
     * Set the deleted property: The Deleted property.
     *
     * @param deleted the deleted value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    /**
     * Get the snapshot property: The Snapshot property.
     *
     * @return the snapshot value.
     */
    public String getSnapshot() {
        return this.snapshot;
    }

    /**
     * Set the snapshot property: The Snapshot property.
     *
     * @param snapshot the snapshot value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    /**
     * Get the versionId property: The VersionId property.
     *
     * @return the versionId value.
     */
    public String getVersionId() {
        return this.versionId;
    }

    /**
     * Set the versionId property: The VersionId property.
     *
     * @param versionId the versionId value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    /**
     * Get the isCurrentVersion property: The IsCurrentVersion property.
     *
     * @return the isCurrentVersion value.
     */
    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    /**
     * Set the isCurrentVersion property: The IsCurrentVersion property.
     *
     * @param isCurrentVersion the isCurrentVersion value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }

    /**
     * Get the properties property: Properties of a blob.
     *
     * @return the properties value.
     */
    public BlobItemPropertiesInternal getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of a blob.
     *
     * @param properties the properties value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setProperties(BlobItemPropertiesInternal properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the metadata property: Dictionary of &lt;string&gt;.
     *
     * @return the metadata value.
     */
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Dictionary of &lt;string&gt;.
     *
     * @param metadata the metadata value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the blobTags property: Blob tags.
     *
     * @return the blobTags value.
     */
    public BlobTags getBlobTags() {
        return this.blobTags;
    }

    /**
     * Set the blobTags property: Blob tags.
     *
     * @param blobTags the blobTags value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setBlobTags(BlobTags blobTags) {
        this.blobTags = blobTags;
        return this;
    }

    /**
     * Get the objectReplicationMetadata property: Dictionary of &lt;string&gt;.
     *
     * @return the objectReplicationMetadata value.
     */
    public Map<String, String> getObjectReplicationMetadata() {
        return this.objectReplicationMetadata;
    }

    /**
     * Set the objectReplicationMetadata property: Dictionary of &lt;string&gt;.
     *
     * @param objectReplicationMetadata the objectReplicationMetadata value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setObjectReplicationMetadata(Map<String, String> objectReplicationMetadata) {
        this.objectReplicationMetadata = objectReplicationMetadata;
        return this;
    }

    /**
     * Get the hasVersionsOnly property: The HasVersionsOnly property.
     *
     * @return the hasVersionsOnly value.
     */
    public Boolean isHasVersionsOnly() {
        return this.hasVersionsOnly;
    }

    /**
     * Set the hasVersionsOnly property: The HasVersionsOnly property.
     *
     * @param hasVersionsOnly the hasVersionsOnly value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setHasVersionsOnly(Boolean hasVersionsOnly) {
        this.hasVersionsOnly = hasVersionsOnly;
        return this;
    }

    /**
     * Get the isPrefix property: The IsPrefix property.
     *
     * @return the isPrefix value.
     */
    public Boolean isPrefix() {
        return this.isPrefix;
    }

    /**
     * Set the isPrefix property: The IsPrefix property.
     *
     * @param isPrefix the isPrefix value to set.
     * @return the BlobItemInternal object itself.
     */
    public BlobItemInternal setIsPrefix(Boolean isPrefix) {
        this.isPrefix = isPrefix;
        return this;
    }
}
