/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.core.experimental.http.HttpAuthorization;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.util.Map;

public class BlobUploadFromUrlOptions {
    private final String sourceUrl;
    private BlobHttpHeaders headers;
    private Map<String, String> tags;
    private AccessTier tier;
    private byte[] contentMd5;
    private BlobRequestConditions destinationRequestConditions;
    private BlobRequestConditions sourceRequestConditions;
    private Boolean copySourceBlobProperties;
    private HttpAuthorization sourceAuthorization;

    public BlobUploadFromUrlOptions(String sourceUrl) {
        StorageImplUtils.assertNotNull((String)"copySource", (Object)sourceUrl);
        this.sourceUrl = sourceUrl;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public BlobHttpHeaders getHeaders() {
        return this.headers;
    }

    public BlobUploadFromUrlOptions setHeaders(BlobHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlobUploadFromUrlOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlobUploadFromUrlOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public BlobUploadFromUrlOptions setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        return this;
    }

    public BlobRequestConditions getDestinationRequestConditions() {
        return this.destinationRequestConditions;
    }

    public BlobUploadFromUrlOptions setDestinationRequestConditions(BlobRequestConditions destinationRequestConditions) {
        this.destinationRequestConditions = destinationRequestConditions;
        return this;
    }

    public BlobRequestConditions getSourceRequestConditions() {
        return this.sourceRequestConditions;
    }

    public BlobUploadFromUrlOptions setSourceRequestConditions(BlobRequestConditions sourceRequestConditions) {
        this.sourceRequestConditions = sourceRequestConditions;
        return this;
    }

    public Boolean isCopySourceBlobProperties() {
        return this.copySourceBlobProperties;
    }

    public BlobUploadFromUrlOptions setCopySourceBlobProperties(Boolean copySourceBlobProperties) {
        this.copySourceBlobProperties = copySourceBlobProperties;
        return this;
    }

    public HttpAuthorization getSourceAuthorization() {
        return this.sourceAuthorization;
    }

    public BlobUploadFromUrlOptions setSourceAuthorization(HttpAuthorization sourceAuthorization) {
        this.sourceAuthorization = sourceAuthorization;
        return this;
    }
}

