/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.ProgressReporter;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.options.BlockBlobCommitBlockListOptions;
import com.azure.storage.blob.options.BlockBlobSimpleUploadOptions;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.BufferStagingArea;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobAsyncClient
extends BlobAsyncClientBase {
    public static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final int BLOB_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final int BLOB_DEFAULT_HTBB_UPLOAD_BLOCK_SIZE = 0x800000;
    static final long BLOB_MAX_UPLOAD_BLOCK_SIZE = 0xFA000000L;
    private final ClientLogger logger = new ClientLogger(BlobAsyncClient.class);

    protected BlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey);
    }

    protected BlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope);
    }

    protected BlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    @Override
    public BlobAsyncClient getSnapshotClient(String snapshot) {
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope, this.getVersionId());
    }

    @Override
    public BlobAsyncClient getVersionClient(String versionId) {
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    @Override
    public BlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public BlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public AppendBlobAsyncClient getAppendBlobAsyncClient() {
        return this.prepareBuilder().buildAppendBlobAsyncClient();
    }

    public BlockBlobAsyncClient getBlockBlobAsyncClient() {
        return this.prepareBuilder().buildBlockBlobAsyncClient();
    }

    public PageBlobAsyncClient getPageBlobAsyncClient() {
        return this.prepareBuilder().buildPageBlobAsyncClient();
    }

    private SpecializedBlobClientBuilder prepareBuilder() {
        SpecializedBlobClientBuilder builder = new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(this.getBlobUrl()).snapshot(this.getSnapshotId()).serviceVersion(this.getServiceVersion());
        CpkInfo cpk = this.getCustomerProvidedKey();
        if (cpk != null) {
            builder.customerProvidedKey(new CustomerProvidedKey(cpk.getEncryptionKey()));
        }
        if (this.encryptionScope != null) {
            builder.encryptionScope(this.encryptionScope.getEncryptionScope());
        }
        return builder;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        try {
            return this.upload(data, parallelTransferOptions, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        try {
            BlobRequestConditions requestConditions;
            Mono overwriteCheck;
            if (overwrite) {
                overwriteCheck = Mono.empty();
                requestConditions = null;
            } else {
                overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return overwriteCheck.then(this.uploadWithResponse(data, parallelTransferOptions, null, null, null, requestConditions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(BinaryData data) {
        try {
            return this.upload(data, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlockBlobItem> upload(BinaryData data, boolean overwrite) {
        try {
            BlobRequestConditions requestConditions;
            Mono overwriteCheck;
            if (overwrite) {
                overwriteCheck = Mono.empty();
                requestConditions = null;
            } else {
                overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return overwriteCheck.then(this.uploadWithResponse((Flux<ByteBuffer>)Flux.just((Object)data.toByteBuffer()), null, null, null, null, requestConditions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.uploadWithResponse(new BlobParallelUploadOptions(data).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadWithResponse(BlobParallelUploadOptions options) {
        try {
            StorageImplUtils.assertNotNull((String)"options", (Object)options);
            ParallelTransferOptions parallelTransferOptions = ModelHelper.populateAndApplyDefaults(options.getParallelTransferOptions());
            BlobHttpHeaders headers = options.getHeaders();
            Map<String, String> metadata = options.getMetadata();
            Map<String, String> tags = options.getTags();
            AccessTier tier = options.getTier();
            BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
            boolean computeMd5 = options.isComputeMd5();
            BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
            Boolean legalHold = options.isLegalHold();
            BlockBlobAsyncClient blockBlobAsyncClient = this.getBlockBlobAsyncClient();
            Function<Flux, Mono> uploadInChunksFunction = stream -> this.uploadInChunks(blockBlobAsyncClient, (Flux<ByteBuffer>)stream, parallelTransferOptions, headers, metadata, tags, tier, requestConditions, computeMd5, immutabilityPolicy, legalHold);
            BiFunction<Flux, Long, Mono> uploadFullBlobFunction = (stream, length) -> this.uploadFullBlob(blockBlobAsyncClient, (Flux<ByteBuffer>)stream, (long)length, parallelTransferOptions, headers, metadata, tags, tier, requestConditions, computeMd5, immutabilityPolicy, legalHold);
            Flux data = options.getDataFlux();
            if (data == null && options.getOptionalLength() == null) {
                int chunkSize = (int)Math.min(0x4000000L, parallelTransferOptions.getBlockSizeLong());
                data = FluxUtil.toFluxByteBuffer((InputStream)options.getDataStream(), (int)chunkSize);
            } else if (data == null) {
                int chunkSize = (int)Math.min(0x4000000L, parallelTransferOptions.getBlockSizeLong());
                data = Utility.convertStreamToByteBuffer((InputStream)options.getDataStream(), (long)options.getOptionalLength(), (int)chunkSize, (boolean)false);
            }
            return UploadUtils.uploadFullOrChunked(data, (com.azure.storage.common.ParallelTransferOptions)ModelHelper.wrapBlobOptions(parallelTransferOptions), uploadInChunksFunction, uploadFullBlobFunction);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<BlockBlobItem>> uploadFullBlob(BlockBlobAsyncClient blockBlobAsyncClient, Flux<ByteBuffer> data, long length, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, BlobRequestConditions requestConditions, boolean computeMd5, BlobImmutabilityPolicy immutabilityPolicy, Boolean legalHold) {
        Flux<ByteBuffer> progressData = ProgressReporter.addProgressReporting(data, parallelTransferOptions.getProgressReceiver());
        return UploadUtils.computeMd5(progressData, (boolean)computeMd5, (ClientLogger)this.logger).map(fluxMd5Wrapper -> new BlockBlobSimpleUploadOptions((Flux<ByteBuffer>)fluxMd5Wrapper.getData(), length).setHeaders(headers).setMetadata(metadata).setTags(tags).setTier(tier).setRequestConditions(requestConditions).setContentMd5(fluxMd5Wrapper.getMd5()).setImmutabilityPolicy(immutabilityPolicy).setLegalHold(legalHold)).flatMap(blockBlobAsyncClient::uploadWithResponse);
    }

    private Mono<Response<BlockBlobItem>> uploadInChunks(BlockBlobAsyncClient blockBlobAsyncClient, Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, BlobRequestConditions requestConditions, boolean computeMd5, BlobImmutabilityPolicy immutabilityPolicy, Boolean legalHold) {
        AtomicLong totalProgress = new AtomicLong();
        ReentrantLock progressLock = new ReentrantLock();
        BufferStagingArea stagingArea = new BufferStagingArea(parallelTransferOptions.getBlockSizeLong().longValue(), 0xFA000000L);
        Flux chunkedSource = UploadUtils.chunkSource(data, (com.azure.storage.common.ParallelTransferOptions)ModelHelper.wrapBlobOptions(parallelTransferOptions));
        return chunkedSource.flatMapSequential(arg_0 -> ((BufferStagingArea)stagingArea).write(arg_0), 1, 1).concatWith((Publisher)Flux.defer(() -> ((BufferStagingArea)stagingArea).flush())).flatMapSequential(bufferAggregator -> {
            Flux<ByteBuffer> progressData = ProgressReporter.addParallelProgressReporting((Flux<ByteBuffer>)bufferAggregator.asFlux(), parallelTransferOptions.getProgressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            return UploadUtils.computeMd5(progressData, (boolean)computeMd5, (ClientLogger)this.logger).flatMap(fluxMd5Wrapper -> blockBlobAsyncClient.stageBlockWithResponse(blockId, (Flux<ByteBuffer>)fluxMd5Wrapper.getData(), bufferAggregator.length(), fluxMd5Wrapper.getMd5(), requestConditions.getLeaseId())).map(x -> blockId).flux();
        }, parallelTransferOptions.getMaxConcurrency().intValue(), 1).collect(Collectors.toList()).flatMap(ids -> blockBlobAsyncClient.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions((List<String>)ids).setHeaders(headers).setMetadata(metadata).setTags(tags).setTier(tier).setRequestConditions(requestConditions).setImmutabilityPolicy(immutabilityPolicy).setLegalHold(legalHold)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath) {
        try {
            return this.uploadFromFile(filePath, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, boolean overwrite) {
        try {
            Mono overwriteCheck = Mono.empty();
            BlobRequestConditions requestConditions = null;
            if (!overwrite) {
                if (UploadUtils.shouldUploadInChunks((String)filePath, (Long)5242880000L, (ClientLogger)this.logger)) {
                    overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
                }
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return overwriteCheck.then(this.uploadFromFile(filePath, null, null, null, null, requestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        return this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BlockBlobItem>> uploadFromFileWithResponse(BlobUploadFromFileOptions options) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        Long originalBlockSize = options.getParallelTransferOptions() == null ? null : options.getParallelTransferOptions().getBlockSizeLong();
        ParallelTransferOptions finalParallelTransferOptions = ModelHelper.populateAndApplyDefaults(options.getParallelTransferOptions());
        try {
            return Mono.using(() -> UploadUtils.uploadFileResourceSupplier((String)options.getFilePath(), (ClientLogger)this.logger), channel -> {
                try {
                    BlockBlobAsyncClient blockBlobAsyncClient = this.getBlockBlobAsyncClient();
                    long fileSize = channel.size();
                    if (UploadUtils.shouldUploadInChunks((String)options.getFilePath(), (Long)finalParallelTransferOptions.getMaxSingleUploadSizeLong(), (ClientLogger)this.logger)) {
                        return this.uploadFileChunks(fileSize, finalParallelTransferOptions, originalBlockSize, options.getHeaders(), options.getMetadata(), options.getTags(), options.getTier(), options.getRequestConditions(), (AsynchronousFileChannel)channel, blockBlobAsyncClient);
                    }
                    Flux<ByteBuffer> data = FluxUtil.readFile((AsynchronousFileChannel)channel);
                    if (finalParallelTransferOptions.getProgressReceiver() != null) {
                        data = ProgressReporter.addProgressReporting(data, finalParallelTransferOptions.getProgressReceiver());
                    }
                    return blockBlobAsyncClient.uploadWithResponse(new BlockBlobSimpleUploadOptions(data, fileSize).setHeaders(options.getHeaders()).setMetadata(options.getMetadata()).setTags(options.getTags()).setTier(options.getTier()).setRequestConditions(options.getRequestConditions()));
                }
                catch (IOException ex) {
                    return Mono.error((Throwable)ex);
                }
            }, channel -> UploadUtils.uploadFileCleanup((AsynchronousFileChannel)channel, (ClientLogger)this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<BlockBlobItem>> uploadFileChunks(long fileSize, ParallelTransferOptions parallelTransferOptions, Long originalBlockSize, BlobHttpHeaders headers, Map<String, String> metadata, Map<String, String> tags, AccessTier tier, BlobRequestConditions requestConditions, AsynchronousFileChannel channel, BlockBlobAsyncClient client) {
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        AtomicLong totalProgress = new AtomicLong();
        ReentrantLock progressLock = new ReentrantLock();
        TreeMap blockIds = new TreeMap();
        return Flux.fromIterable(this.sliceFile(fileSize, originalBlockSize, parallelTransferOptions.getBlockSizeLong())).flatMap(chunk -> {
            String blockId = this.getBlockID();
            blockIds.put(chunk.getOffset(), blockId);
            Flux<ByteBuffer> progressData = ProgressReporter.addParallelProgressReporting((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)channel, (long)chunk.getOffset(), (long)chunk.getCount()), parallelTransferOptions.getProgressReceiver(), progressLock, totalProgress);
            return client.stageBlockWithResponse(blockId, progressData, chunk.getCount(), null, finalRequestConditions.getLeaseId());
        }, parallelTransferOptions.getMaxConcurrency().intValue()).then(Mono.defer(() -> client.commitBlockListWithResponse(new BlockBlobCommitBlockListOptions(new ArrayList<String>(blockIds.values())).setHeaders(headers).setMetadata(metadata).setTags(tags).setTier(tier).setRequestConditions(finalRequestConditions))));
    }

    @Deprecated
    protected AsynchronousFileChannel uploadFileResourceSupplier(String filePath) {
        return UploadUtils.uploadFileResourceSupplier((String)filePath, (ClientLogger)this.logger);
    }

    private String getBlockID() {
        return Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<BlobRange> sliceFile(long fileSize, Long originalBlockSize, long blockSize) {
        ArrayList<BlobRange> ranges = new ArrayList<BlobRange>();
        if (fileSize > 0x6400000L && originalBlockSize == null) {
            blockSize = 0x800000L;
        }
        for (long pos = 0L; pos < fileSize; pos += blockSize) {
            long count = blockSize;
            if (pos + count > fileSize) {
                count = fileSize - pos;
            }
            ranges.add(new BlobRange(pos, count));
        }
        return ranges;
    }
}

