/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.azure.storage.blob.models.BlobServiceStatistics;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.PublicAccessType;
import com.azure.storage.blob.models.StorageAccountInfo;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.options.FindBlobsOptions;
import com.azure.storage.blob.options.UndeleteBlobContainerOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BlobServiceClientBuilder.class)
public final class BlobServiceClient {
    private final BlobServiceAsyncClient blobServiceAsyncClient;

    BlobServiceClient(BlobServiceAsyncClient blobServiceAsyncClient) {
        this.blobServiceAsyncClient = blobServiceAsyncClient;
    }

    public BlobContainerClient getBlobContainerClient(String containerName) {
        return new BlobContainerClient(this.blobServiceAsyncClient.getBlobContainerAsyncClient(containerName));
    }

    public HttpPipeline getHttpPipeline() {
        return this.blobServiceAsyncClient.getHttpPipeline();
    }

    public BlobServiceVersion getServiceVersion() {
        return this.blobServiceAsyncClient.getServiceVersion();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient createBlobContainer(String containerName) {
        return (BlobContainerClient)this.createBlobContainerWithResponse(containerName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> createBlobContainerWithResponse(String containerName, Map<String, String> metadata, PublicAccessType accessType, Context context) {
        BlobContainerClient client = this.getBlobContainerClient(containerName);
        return new SimpleResponse(client.createWithResponse(metadata, accessType, null, context), (Object)client);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient createBlobContainerIfNotExists(String containerName) {
        return (BlobContainerClient)this.createBlobContainerIfNotExistsWithResponse(containerName, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> createBlobContainerIfNotExistsWithResponse(String containerName, BlobContainerCreateOptions options, Context context) {
        BlobContainerClient client = this.getBlobContainerClient(containerName);
        return new SimpleResponse(client.createIfNotExistsWithResponse(options, null, context), (Object)client);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBlobContainer(String containerName) {
        this.deleteBlobContainerWithResponse(containerName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBlobContainerWithResponse(String containerName, Context context) {
        return (Response)this.blobServiceAsyncClient.deleteBlobContainerWithResponse(containerName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteBlobContainerIfExists(String containerName) {
        Response<Void> response = this.deleteBlobContainerIfExistsWithResponse(containerName, Context.NONE);
        return response.getStatusCode() == 202;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBlobContainerIfExistsWithResponse(String containerName, Context context) {
        return (Response)this.blobServiceAsyncClient.deleteBlobContainerIfExistsWithResponse(containerName, context).block();
    }

    public String getAccountUrl() {
        return this.blobServiceAsyncClient.getAccountUrl();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainers() {
        return this.listBlobContainers(new ListBlobContainersOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BlobContainerItem> listBlobContainers(ListBlobContainersOptions options, Duration timeout) {
        return new PagedIterable(this.blobServiceAsyncClient.listBlobContainersWithOptionalTimeout(options, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(String query) {
        return this.findBlobsByTags(new FindBlobsOptions(query), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaggedBlobItem> findBlobsByTags(FindBlobsOptions options, Duration timeout, Context context) {
        return new PagedIterable(this.blobServiceAsyncClient.findBlobsByTags(options, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceProperties getProperties() {
        return (BlobServiceProperties)this.getPropertiesWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceProperties> getPropertiesWithResponse(Duration timeout, Context context) {
        Mono<Response<BlobServiceProperties>> response = this.blobServiceAsyncClient.getPropertiesWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setProperties(BlobServiceProperties properties) {
        this.setPropertiesWithResponse(properties, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setPropertiesWithResponse(BlobServiceProperties properties, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.blobServiceAsyncClient.setPropertiesWithResponse(properties, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserDelegationKey getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return (UserDelegationKey)this.getUserDelegationKeyWithResponse(start, expiry, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UserDelegationKey> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry, Duration timeout, Context context) {
        Mono<Response<UserDelegationKey>> response = this.blobServiceAsyncClient.getUserDelegationKeyWithResponse(start, expiry, context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobServiceStatistics getStatistics() {
        return (BlobServiceStatistics)this.getStatisticsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobServiceStatistics> getStatisticsWithResponse(Duration timeout, Context context) {
        Mono<Response<BlobServiceStatistics>> response = this.blobServiceAsyncClient.getStatisticsWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInfo getAccountInfo() {
        return (StorageAccountInfo)this.getAccountInfoWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInfo> getAccountInfoWithResponse(Duration timeout, Context context) {
        Mono<Response<StorageAccountInfo>> response = this.blobServiceAsyncClient.getAccountInfoWithResponse(context);
        return (Response)StorageImplUtils.blockWithOptionalTimeout(response, (Duration)timeout);
    }

    public String getAccountName() {
        return this.blobServiceAsyncClient.getAccountName();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobContainerClient undeleteBlobContainer(String deletedContainerName, String deletedContainerVersion) {
        return (BlobContainerClient)this.undeleteBlobContainerWithResponse(new UndeleteBlobContainerOptions(deletedContainerName, deletedContainerVersion), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlobContainerClient> undeleteBlobContainerWithResponse(UndeleteBlobContainerOptions options, Duration timeout, Context context) {
        Mono response = this.blobServiceAsyncClient.undeleteBlobContainerWithResponse(options, context).map(r -> new SimpleResponse(r, (Object)this.getBlobContainerClient(((BlobContainerAsyncClient)r.getValue()).getBlobContainerName())));
        return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)response, (Duration)timeout);
    }
}

