/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.azure.storage.blob.models.PublicAccessType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class ContainersGetPropertiesHeaders {
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType xMsLeaseStatus;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-immutable-storage-with-versioning-enabled")
    private Boolean xMsImmutableStorageWithVersioningEnabled;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType xMsLeaseState;
    @JsonProperty(value="x-ms-deny-encryption-scope-override")
    private Boolean xMsDenyEncryptionScopeOverride;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-has-legal-hold")
    private Boolean xMsHasLegalHold;
    @JsonProperty(value="x-ms-default-encryption-scope")
    private String xMsDefaultEncryptionScope;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-has-immutability-policy")
    private Boolean xMsHasImmutabilityPolicy;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType xMsLeaseDuration;
    @JsonProperty(value="x-ms-blob-public-access")
    private PublicAccessType xMsBlobPublicAccess;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;

    public ContainersGetPropertiesHeaders(HttpHeaders rawHeaders) {
        if (rawHeaders.getValue("x-ms-lease-status") != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(rawHeaders.getValue("x-ms-lease-status"));
        }
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        if (rawHeaders.getValue("x-ms-immutable-storage-with-versioning-enabled") != null) {
            this.xMsImmutableStorageWithVersioningEnabled = Boolean.parseBoolean(rawHeaders.getValue("x-ms-immutable-storage-with-versioning-enabled"));
        }
        if (rawHeaders.getValue("x-ms-lease-state") != null) {
            this.xMsLeaseState = LeaseStateType.fromString(rawHeaders.getValue("x-ms-lease-state"));
        }
        if (rawHeaders.getValue("x-ms-deny-encryption-scope-override") != null) {
            this.xMsDenyEncryptionScopeOverride = Boolean.parseBoolean(rawHeaders.getValue("x-ms-deny-encryption-scope-override"));
        }
        if (rawHeaders.getValue("Last-Modified") != null) {
            this.lastModified = new DateTimeRfc1123(rawHeaders.getValue("Last-Modified"));
        }
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            if (!header.getName().startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(header.getName().substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
        if (rawHeaders.getValue("x-ms-has-legal-hold") != null) {
            this.xMsHasLegalHold = Boolean.parseBoolean(rawHeaders.getValue("x-ms-has-legal-hold"));
        }
        this.xMsDefaultEncryptionScope = rawHeaders.getValue("x-ms-default-encryption-scope");
        this.eTag = rawHeaders.getValue("ETag");
        if (rawHeaders.getValue("x-ms-has-immutability-policy") != null) {
            this.xMsHasImmutabilityPolicy = Boolean.parseBoolean(rawHeaders.getValue("x-ms-has-immutability-policy"));
        }
        if (rawHeaders.getValue("x-ms-lease-duration") != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(rawHeaders.getValue("x-ms-lease-duration"));
        }
        if (rawHeaders.getValue("x-ms-blob-public-access") != null) {
            this.xMsBlobPublicAccess = PublicAccessType.fromString(rawHeaders.getValue("x-ms-blob-public-access"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public ContainersGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public Boolean isXMsImmutableStorageWithVersioningEnabled() {
        return this.xMsImmutableStorageWithVersioningEnabled;
    }

    public ContainersGetPropertiesHeaders setXMsImmutableStorageWithVersioningEnabled(Boolean xMsImmutableStorageWithVersioningEnabled) {
        this.xMsImmutableStorageWithVersioningEnabled = xMsImmutableStorageWithVersioningEnabled;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public Boolean isXMsDenyEncryptionScopeOverride() {
        return this.xMsDenyEncryptionScopeOverride;
    }

    public ContainersGetPropertiesHeaders setXMsDenyEncryptionScopeOverride(Boolean xMsDenyEncryptionScopeOverride) {
        this.xMsDenyEncryptionScopeOverride = xMsDenyEncryptionScopeOverride;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public ContainersGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public ContainersGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public ContainersGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Boolean isXMsHasLegalHold() {
        return this.xMsHasLegalHold;
    }

    public ContainersGetPropertiesHeaders setXMsHasLegalHold(Boolean xMsHasLegalHold) {
        this.xMsHasLegalHold = xMsHasLegalHold;
        return this;
    }

    public String getXMsDefaultEncryptionScope() {
        return this.xMsDefaultEncryptionScope;
    }

    public ContainersGetPropertiesHeaders setXMsDefaultEncryptionScope(String xMsDefaultEncryptionScope) {
        this.xMsDefaultEncryptionScope = xMsDefaultEncryptionScope;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public ContainersGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Boolean isXMsHasImmutabilityPolicy() {
        return this.xMsHasImmutabilityPolicy;
    }

    public ContainersGetPropertiesHeaders setXMsHasImmutabilityPolicy(Boolean xMsHasImmutabilityPolicy) {
        this.xMsHasImmutabilityPolicy = xMsHasImmutabilityPolicy;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public ContainersGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public PublicAccessType getXMsBlobPublicAccess() {
        return this.xMsBlobPublicAccess;
    }

    public ContainersGetPropertiesHeaders setXMsBlobPublicAccess(PublicAccessType xMsBlobPublicAccess) {
        this.xMsBlobPublicAccess = xMsBlobPublicAccess;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public ContainersGetPropertiesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }
}

