// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Parameter group. */
@JacksonXmlRootElement(localName = "DirectoryHttpHeaders")
@Fluent
public final class DirectoryHttpHeaders {
    /*
     * Cache control for given resource
     */
    @JsonProperty(value = "cacheControl")
    private String cacheControl;

    /*
     * Content type for given resource
     */
    @JsonProperty(value = "contentType")
    private String contentType;

    /*
     * Content encoding for given resource
     */
    @JsonProperty(value = "contentEncoding")
    private String contentEncoding;

    /*
     * Content language for given resource
     */
    @JsonProperty(value = "contentLanguage")
    private String contentLanguage;

    /*
     * Content disposition for given resource
     */
    @JsonProperty(value = "contentDisposition")
    private String contentDisposition;

    /**
     * Get the cacheControl property: Cache control for given resource.
     *
     * @return the cacheControl value.
     */
    public String getCacheControl() {
        return this.cacheControl;
    }

    /**
     * Set the cacheControl property: Cache control for given resource.
     *
     * @param cacheControl the cacheControl value to set.
     * @return the DirectoryHttpHeaders object itself.
     */
    public DirectoryHttpHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    /**
     * Get the contentType property: Content type for given resource.
     *
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Content type for given resource.
     *
     * @param contentType the contentType value to set.
     * @return the DirectoryHttpHeaders object itself.
     */
    public DirectoryHttpHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the contentEncoding property: Content encoding for given resource.
     *
     * @return the contentEncoding value.
     */
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    /**
     * Set the contentEncoding property: Content encoding for given resource.
     *
     * @param contentEncoding the contentEncoding value to set.
     * @return the DirectoryHttpHeaders object itself.
     */
    public DirectoryHttpHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    /**
     * Get the contentLanguage property: Content language for given resource.
     *
     * @return the contentLanguage value.
     */
    public String getContentLanguage() {
        return this.contentLanguage;
    }

    /**
     * Set the contentLanguage property: Content language for given resource.
     *
     * @param contentLanguage the contentLanguage value to set.
     * @return the DirectoryHttpHeaders object itself.
     */
    public DirectoryHttpHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    /**
     * Get the contentDisposition property: Content disposition for given resource.
     *
     * @return the contentDisposition value.
     */
    public String getContentDisposition() {
        return this.contentDisposition;
    }

    /**
     * Set the contentDisposition property: Content disposition for given resource.
     *
     * @param contentDisposition the contentDisposition value to set.
     * @return the DirectoryHttpHeaders object itself.
     */
    public DirectoryHttpHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }
}
