/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class BlobsGetPropertiesHeaders {
    @JsonProperty(value="x-ms-is-current-version")
    private Boolean xMsIsCurrentVersion;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType xMsLeaseStatus;
    @JsonProperty(value="x-ms-copy-destination-snapshot")
    private String xMsCopyDestinationSnapshot;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType xMsLeaseState;
    @JsonProperty(value="x-ms-blob-sealed")
    private Boolean xMsBlobSealed;
    @JsonProperty(value="x-ms-version-id")
    private String xMsVersionId;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String xMsEncryptionKeySha256;
    @JsonProperty(value="x-ms-access-tier-change-time")
    private DateTimeRfc1123 xMsAccessTierChangeTime;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType xMsBlobType;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="x-ms-creation-time")
    private DateTimeRfc1123 xMsCreationTime;
    @JsonProperty(value="x-ms-incremental-copy")
    private Boolean xMsIncrementalCopy;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType xMsLeaseDuration;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-copy-id")
    private String xMsCopyId;
    @JsonProperty(value="x-ms-immutability-policy-until-date")
    private DateTimeRfc1123 xMsImmutabilityPolicyUntilDate;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long xMsBlobSequenceNumber;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer xMsBlobCommittedBlockCount;
    @JsonProperty(value="x-ms-legal-hold")
    private Boolean xMsLegalHold;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-or-policy-id")
    private String xMsOrPolicyId;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @HeaderCollection(value="x-ms-or-")
    private Map<String, String> xMsOr;
    @JsonProperty(value="x-ms-encryption-scope")
    private String xMsEncryptionScope;
    @JsonProperty(value="x-ms-tag-count")
    private Long xMsTagCount;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-access-tier-inferred")
    private Boolean xMsAccessTierInferred;
    @JsonProperty(value="x-ms-immutability-policy-mode")
    private BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode;
    @JsonProperty(value="x-ms-access-tier")
    private String xMsAccessTier;
    @JsonProperty(value="x-ms-copy-status-description")
    private String xMsCopyStatusDescription;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="x-ms-last-access-time")
    private DateTimeRfc1123 xMsLastAccessTime;
    @JsonProperty(value="x-ms-copy-source")
    private String xMsCopySource;
    @JsonProperty(value="x-ms-copy-progress")
    private String xMsCopyProgress;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-expiry-time")
    private DateTimeRfc1123 xMsExpiryTime;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 xMsCopyCompletionTime;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean xMsServerEncrypted;
    @JsonProperty(value="x-ms-rehydrate-priority")
    private String xMsRehydratePriority;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType xMsCopyStatus;
    @JsonProperty(value="x-ms-archive-status")
    private String xMsArchiveStatus;

    public BlobsGetPropertiesHeaders(HttpHeaders rawHeaders) {
        if (rawHeaders.getValue("x-ms-is-current-version") != null) {
            this.xMsIsCurrentVersion = Boolean.parseBoolean(rawHeaders.getValue("x-ms-is-current-version"));
        }
        if (rawHeaders.getValue("x-ms-lease-status") != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(rawHeaders.getValue("x-ms-lease-status"));
        }
        this.xMsCopyDestinationSnapshot = rawHeaders.getValue("x-ms-copy-destination-snapshot");
        if (rawHeaders.getValue("x-ms-lease-state") != null) {
            this.xMsLeaseState = LeaseStateType.fromString(rawHeaders.getValue("x-ms-lease-state"));
        }
        if (rawHeaders.getValue("x-ms-blob-sealed") != null) {
            this.xMsBlobSealed = Boolean.parseBoolean(rawHeaders.getValue("x-ms-blob-sealed"));
        }
        this.xMsVersionId = rawHeaders.getValue("x-ms-version-id");
        this.xMsEncryptionKeySha256 = rawHeaders.getValue("x-ms-encryption-key-sha256");
        if (rawHeaders.getValue("x-ms-access-tier-change-time") != null) {
            this.xMsAccessTierChangeTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-access-tier-change-time"));
        }
        if (rawHeaders.getValue("x-ms-blob-type") != null) {
            this.xMsBlobType = BlobType.fromString(rawHeaders.getValue("x-ms-blob-type"));
        }
        this.contentEncoding = rawHeaders.getValue("Content-Encoding");
        if (rawHeaders.getValue("x-ms-creation-time") != null) {
            this.xMsCreationTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-creation-time"));
        }
        if (rawHeaders.getValue("x-ms-incremental-copy") != null) {
            this.xMsIncrementalCopy = Boolean.parseBoolean(rawHeaders.getValue("x-ms-incremental-copy"));
        }
        if (rawHeaders.getValue("x-ms-lease-duration") != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(rawHeaders.getValue("x-ms-lease-duration"));
        }
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.xMsCopyId = rawHeaders.getValue("x-ms-copy-id");
        if (rawHeaders.getValue("x-ms-immutability-policy-until-date") != null) {
            this.xMsImmutabilityPolicyUntilDate = new DateTimeRfc1123(rawHeaders.getValue("x-ms-immutability-policy-until-date"));
        }
        if (rawHeaders.getValue("x-ms-blob-sequence-number") != null) {
            this.xMsBlobSequenceNumber = Long.parseLong(rawHeaders.getValue("x-ms-blob-sequence-number"));
        }
        if (rawHeaders.getValue("x-ms-blob-committed-block-count") != null) {
            this.xMsBlobCommittedBlockCount = Integer.parseInt(rawHeaders.getValue("x-ms-blob-committed-block-count"));
        }
        if (rawHeaders.getValue("x-ms-legal-hold") != null) {
            this.xMsLegalHold = Boolean.parseBoolean(rawHeaders.getValue("x-ms-legal-hold"));
        }
        if (rawHeaders.getValue("Content-MD5") != null) {
            this.contentMD5 = Base64.getDecoder().decode(rawHeaders.getValue("Content-MD5"));
        }
        this.xMsOrPolicyId = rawHeaders.getValue("x-ms-or-policy-id");
        this.cacheControl = rawHeaders.getValue("Cache-Control");
        this.eTag = rawHeaders.getValue("ETag");
        this.contentDisposition = rawHeaders.getValue("Content-Disposition");
        this.contentLanguage = rawHeaders.getValue("Content-Language");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        HashMap<String, String> xMsOrHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            if (!header.getName().startsWith("x-ms-or-")) continue;
            xMsOrHeaderCollection.put(header.getName().substring(8), header.getValue());
        }
        this.xMsOr = xMsOrHeaderCollection;
        this.xMsEncryptionScope = rawHeaders.getValue("x-ms-encryption-scope");
        if (rawHeaders.getValue("x-ms-tag-count") != null) {
            this.xMsTagCount = Long.parseLong(rawHeaders.getValue("x-ms-tag-count"));
        }
        if (rawHeaders.getValue("Last-Modified") != null) {
            this.lastModified = new DateTimeRfc1123(rawHeaders.getValue("Last-Modified"));
        }
        if (rawHeaders.getValue("x-ms-access-tier-inferred") != null) {
            this.xMsAccessTierInferred = Boolean.parseBoolean(rawHeaders.getValue("x-ms-access-tier-inferred"));
        }
        if (rawHeaders.getValue("x-ms-immutability-policy-mode") != null) {
            this.xMsImmutabilityPolicyMode = BlobImmutabilityPolicyMode.fromString(rawHeaders.getValue("x-ms-immutability-policy-mode"));
        }
        this.xMsAccessTier = rawHeaders.getValue("x-ms-access-tier");
        this.xMsCopyStatusDescription = rawHeaders.getValue("x-ms-copy-status-description");
        if (rawHeaders.getValue("Content-Length") != null) {
            this.contentLength = Long.parseLong(rawHeaders.getValue("Content-Length"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.contentType = rawHeaders.getValue("Content-Type");
        if (rawHeaders.getValue("x-ms-last-access-time") != null) {
            this.xMsLastAccessTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-last-access-time"));
        }
        this.xMsCopySource = rawHeaders.getValue("x-ms-copy-source");
        this.xMsCopyProgress = rawHeaders.getValue("x-ms-copy-progress");
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            if (!header.getName().startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(header.getName().substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
        if (rawHeaders.getValue("x-ms-expiry-time") != null) {
            this.xMsExpiryTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-expiry-time"));
        }
        if (rawHeaders.getValue("x-ms-copy-completion-time") != null) {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-copy-completion-time"));
        }
        this.acceptRanges = rawHeaders.getValue("Accept-Ranges");
        if (rawHeaders.getValue("x-ms-server-encrypted") != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(rawHeaders.getValue("x-ms-server-encrypted"));
        }
        this.xMsRehydratePriority = rawHeaders.getValue("x-ms-rehydrate-priority");
        if (rawHeaders.getValue("x-ms-copy-status") != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(rawHeaders.getValue("x-ms-copy-status"));
        }
        this.xMsArchiveStatus = rawHeaders.getValue("x-ms-archive-status");
    }

    public Boolean isXMsIsCurrentVersion() {
        return this.xMsIsCurrentVersion;
    }

    public BlobsGetPropertiesHeaders setXMsIsCurrentVersion(Boolean xMsIsCurrentVersion) {
        this.xMsIsCurrentVersion = xMsIsCurrentVersion;
        return this;
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public BlobsGetPropertiesHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getXMsCopyDestinationSnapshot() {
        return this.xMsCopyDestinationSnapshot;
    }

    public BlobsGetPropertiesHeaders setXMsCopyDestinationSnapshot(String xMsCopyDestinationSnapshot) {
        this.xMsCopyDestinationSnapshot = xMsCopyDestinationSnapshot;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public BlobsGetPropertiesHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public Boolean isXMsBlobSealed() {
        return this.xMsBlobSealed;
    }

    public BlobsGetPropertiesHeaders setXMsBlobSealed(Boolean xMsBlobSealed) {
        this.xMsBlobSealed = xMsBlobSealed;
        return this;
    }

    public String getXMsVersionId() {
        return this.xMsVersionId;
    }

    public BlobsGetPropertiesHeaders setXMsVersionId(String xMsVersionId) {
        this.xMsVersionId = xMsVersionId;
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public BlobsGetPropertiesHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public OffsetDateTime getXMsAccessTierChangeTime() {
        if (this.xMsAccessTierChangeTime == null) {
            return null;
        }
        return this.xMsAccessTierChangeTime.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsAccessTierChangeTime(OffsetDateTime xMsAccessTierChangeTime) {
        this.xMsAccessTierChangeTime = xMsAccessTierChangeTime == null ? null : new DateTimeRfc1123(xMsAccessTierChangeTime);
        return this;
    }

    public BlobType getXMsBlobType() {
        return this.xMsBlobType;
    }

    public BlobsGetPropertiesHeaders setXMsBlobType(BlobType xMsBlobType) {
        this.xMsBlobType = xMsBlobType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobsGetPropertiesHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public OffsetDateTime getXMsCreationTime() {
        if (this.xMsCreationTime == null) {
            return null;
        }
        return this.xMsCreationTime.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsCreationTime(OffsetDateTime xMsCreationTime) {
        this.xMsCreationTime = xMsCreationTime == null ? null : new DateTimeRfc1123(xMsCreationTime);
        return this;
    }

    public Boolean isXMsIncrementalCopy() {
        return this.xMsIncrementalCopy;
    }

    public BlobsGetPropertiesHeaders setXMsIncrementalCopy(Boolean xMsIncrementalCopy) {
        this.xMsIncrementalCopy = xMsIncrementalCopy;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public BlobsGetPropertiesHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsGetPropertiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public BlobsGetPropertiesHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public OffsetDateTime getXMsImmutabilityPolicyUntilDate() {
        if (this.xMsImmutabilityPolicyUntilDate == null) {
            return null;
        }
        return this.xMsImmutabilityPolicyUntilDate.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsImmutabilityPolicyUntilDate(OffsetDateTime xMsImmutabilityPolicyUntilDate) {
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate == null ? null : new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate);
        return this;
    }

    public Long getXMsBlobSequenceNumber() {
        return this.xMsBlobSequenceNumber;
    }

    public BlobsGetPropertiesHeaders setXMsBlobSequenceNumber(Long xMsBlobSequenceNumber) {
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber;
        return this;
    }

    public Integer getXMsBlobCommittedBlockCount() {
        return this.xMsBlobCommittedBlockCount;
    }

    public BlobsGetPropertiesHeaders setXMsBlobCommittedBlockCount(Integer xMsBlobCommittedBlockCount) {
        this.xMsBlobCommittedBlockCount = xMsBlobCommittedBlockCount;
        return this;
    }

    public Boolean isXMsLegalHold() {
        return this.xMsLegalHold;
    }

    public BlobsGetPropertiesHeaders setXMsLegalHold(Boolean xMsLegalHold) {
        this.xMsLegalHold = xMsLegalHold;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone((byte[])this.contentMD5);
    }

    public BlobsGetPropertiesHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone((byte[])contentMD5);
        return this;
    }

    public String getXMsOrPolicyId() {
        return this.xMsOrPolicyId;
    }

    public BlobsGetPropertiesHeaders setXMsOrPolicyId(String xMsOrPolicyId) {
        this.xMsOrPolicyId = xMsOrPolicyId;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobsGetPropertiesHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobsGetPropertiesHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobsGetPropertiesHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobsGetPropertiesHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsGetPropertiesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public Map<String, String> getXMsOr() {
        return this.xMsOr;
    }

    public BlobsGetPropertiesHeaders setXMsOr(Map<String, String> xMsOr) {
        this.xMsOr = xMsOr;
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public BlobsGetPropertiesHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }

    public Long getXMsTagCount() {
        return this.xMsTagCount;
    }

    public BlobsGetPropertiesHeaders setXMsTagCount(Long xMsTagCount) {
        this.xMsTagCount = xMsTagCount;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobsGetPropertiesHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Boolean isXMsAccessTierInferred() {
        return this.xMsAccessTierInferred;
    }

    public BlobsGetPropertiesHeaders setXMsAccessTierInferred(Boolean xMsAccessTierInferred) {
        this.xMsAccessTierInferred = xMsAccessTierInferred;
        return this;
    }

    public BlobImmutabilityPolicyMode getXMsImmutabilityPolicyMode() {
        return this.xMsImmutabilityPolicyMode;
    }

    public BlobsGetPropertiesHeaders setXMsImmutabilityPolicyMode(BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode) {
        this.xMsImmutabilityPolicyMode = xMsImmutabilityPolicyMode;
        return this;
    }

    public String getXMsAccessTier() {
        return this.xMsAccessTier;
    }

    public BlobsGetPropertiesHeaders setXMsAccessTier(String xMsAccessTier) {
        this.xMsAccessTier = xMsAccessTier;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public BlobsGetPropertiesHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobsGetPropertiesHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsGetPropertiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobsGetPropertiesHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public OffsetDateTime getXMsLastAccessTime() {
        if (this.xMsLastAccessTime == null) {
            return null;
        }
        return this.xMsLastAccessTime.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsLastAccessTime(OffsetDateTime xMsLastAccessTime) {
        this.xMsLastAccessTime = xMsLastAccessTime == null ? null : new DateTimeRfc1123(xMsLastAccessTime);
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public BlobsGetPropertiesHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public BlobsGetPropertiesHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public BlobsGetPropertiesHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobsGetPropertiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public OffsetDateTime getXMsExpiryTime() {
        if (this.xMsExpiryTime == null) {
            return null;
        }
        return this.xMsExpiryTime.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsExpiryTime(OffsetDateTime xMsExpiryTime) {
        this.xMsExpiryTime = xMsExpiryTime == null ? null : new DateTimeRfc1123(xMsExpiryTime);
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public BlobsGetPropertiesHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobsGetPropertiesHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public BlobsGetPropertiesHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getXMsRehydratePriority() {
        return this.xMsRehydratePriority;
    }

    public BlobsGetPropertiesHeaders setXMsRehydratePriority(String xMsRehydratePriority) {
        this.xMsRehydratePriority = xMsRehydratePriority;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public BlobsGetPropertiesHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getXMsArchiveStatus() {
        return this.xMsArchiveStatus;
    }

    public BlobsGetPropertiesHeaders setXMsArchiveStatus(String xMsArchiveStatus) {
        this.xMsArchiveStatus = xMsArchiveStatus;
        return this;
    }
}

