// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** Blob info from a Filter Blobs API call. */
@JacksonXmlRootElement(localName = "Blob")
@Fluent
public final class FilterBlobItem {
    /*
     * The Name property.
     */
    @JsonProperty(value = "Name", required = true)
    private String name;

    /*
     * The ContainerName property.
     */
    @JsonProperty(value = "ContainerName", required = true)
    private String containerName;

    /*
     * Blob tags
     */
    @JsonProperty(value = "Tags")
    private BlobTags tags;

    /*
     * The VersionId property.
     */
    @JsonProperty(value = "VersionId")
    private String versionId;

    /*
     * The IsCurrentVersion property.
     */
    @JsonProperty(value = "IsCurrentVersion")
    private Boolean isCurrentVersion;

    /** Creates an instance of FilterBlobItem class. */
    public FilterBlobItem() {}

    /**
     * Get the name property: The Name property.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The Name property.
     *
     * @param name the name value to set.
     * @return the FilterBlobItem object itself.
     */
    public FilterBlobItem setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the containerName property: The ContainerName property.
     *
     * @return the containerName value.
     */
    public String getContainerName() {
        return this.containerName;
    }

    /**
     * Set the containerName property: The ContainerName property.
     *
     * @param containerName the containerName value to set.
     * @return the FilterBlobItem object itself.
     */
    public FilterBlobItem setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    /**
     * Get the tags property: Blob tags.
     *
     * @return the tags value.
     */
    public BlobTags getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: Blob tags.
     *
     * @param tags the tags value to set.
     * @return the FilterBlobItem object itself.
     */
    public FilterBlobItem setTags(BlobTags tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the versionId property: The VersionId property.
     *
     * @return the versionId value.
     */
    public String getVersionId() {
        return this.versionId;
    }

    /**
     * Set the versionId property: The VersionId property.
     *
     * @param versionId the versionId value to set.
     * @return the FilterBlobItem object itself.
     */
    public FilterBlobItem setVersionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    /**
     * Get the isCurrentVersion property: The IsCurrentVersion property.
     *
     * @return the isCurrentVersion value.
     */
    public Boolean isCurrentVersion() {
        return this.isCurrentVersion;
    }

    /**
     * Set the isCurrentVersion property: The IsCurrentVersion property.
     *
     * @param isCurrentVersion the isCurrentVersion value to set.
     * @return the FilterBlobItem object itself.
     */
    public FilterBlobItem setIsCurrentVersion(Boolean isCurrentVersion) {
        this.isCurrentVersion = isCurrentVersion;
        return this;
    }
}
