// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The QueryFormat model.
 */
@Fluent
public final class QueryFormat implements XmlSerializable<QueryFormat> {
    /*
     * The quick query format type.
     */
    private QueryFormatType type;

    /*
     * Groups the settings used for interpreting the blob data if the blob is delimited text formatted.
     */
    private DelimitedTextConfiguration delimitedTextConfiguration;

    /*
     * json text configuration
     */
    private JsonTextConfiguration jsonTextConfiguration;

    /*
     * Groups the settings used for formatting the response if the response should be Arrow formatted.
     */
    private ArrowConfiguration arrowConfiguration;

    /*
     * parquet configuration
     */
    private Object parquetTextConfiguration;

    /**
     * Creates an instance of QueryFormat class.
     */
    public QueryFormat() {
    }

    /**
     * Get the type property: The quick query format type.
     * 
     * @return the type value.
     */
    public QueryFormatType getType() {
        return this.type;
    }

    /**
     * Set the type property: The quick query format type.
     * 
     * @param type the type value to set.
     * @return the QueryFormat object itself.
     */
    public QueryFormat setType(QueryFormatType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the delimitedTextConfiguration property: Groups the settings used for interpreting the blob data if the blob
     * is delimited text formatted.
     * 
     * @return the delimitedTextConfiguration value.
     */
    public DelimitedTextConfiguration getDelimitedTextConfiguration() {
        return this.delimitedTextConfiguration;
    }

    /**
     * Set the delimitedTextConfiguration property: Groups the settings used for interpreting the blob data if the blob
     * is delimited text formatted.
     * 
     * @param delimitedTextConfiguration the delimitedTextConfiguration value to set.
     * @return the QueryFormat object itself.
     */
    public QueryFormat setDelimitedTextConfiguration(DelimitedTextConfiguration delimitedTextConfiguration) {
        this.delimitedTextConfiguration = delimitedTextConfiguration;
        return this;
    }

    /**
     * Get the jsonTextConfiguration property: json text configuration.
     * 
     * @return the jsonTextConfiguration value.
     */
    public JsonTextConfiguration getJsonTextConfiguration() {
        return this.jsonTextConfiguration;
    }

    /**
     * Set the jsonTextConfiguration property: json text configuration.
     * 
     * @param jsonTextConfiguration the jsonTextConfiguration value to set.
     * @return the QueryFormat object itself.
     */
    public QueryFormat setJsonTextConfiguration(JsonTextConfiguration jsonTextConfiguration) {
        this.jsonTextConfiguration = jsonTextConfiguration;
        return this;
    }

    /**
     * Get the arrowConfiguration property: Groups the settings used for formatting the response if the response should
     * be Arrow formatted.
     * 
     * @return the arrowConfiguration value.
     */
    public ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    /**
     * Set the arrowConfiguration property: Groups the settings used for formatting the response if the response should
     * be Arrow formatted.
     * 
     * @param arrowConfiguration the arrowConfiguration value to set.
     * @return the QueryFormat object itself.
     */
    public QueryFormat setArrowConfiguration(ArrowConfiguration arrowConfiguration) {
        this.arrowConfiguration = arrowConfiguration;
        return this;
    }

    /**
     * Get the parquetTextConfiguration property: parquet configuration.
     * 
     * @return the parquetTextConfiguration value.
     */
    public Object getParquetTextConfiguration() {
        return this.parquetTextConfiguration;
    }

    /**
     * Set the parquetTextConfiguration property: parquet configuration.
     * 
     * @param parquetTextConfiguration the parquetTextConfiguration value to set.
     * @return the QueryFormat object itself.
     */
    public QueryFormat setParquetTextConfiguration(Object parquetTextConfiguration) {
        this.parquetTextConfiguration = parquetTextConfiguration;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueryFormat" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Type", this.type == null ? null : this.type.toString());
        xmlWriter.writeXml(this.delimitedTextConfiguration, "DelimitedTextConfiguration");
        xmlWriter.writeXml(this.jsonTextConfiguration, "JsonTextConfiguration");
        xmlWriter.writeXml(this.arrowConfiguration, "ArrowConfiguration");
        xmlWriter.writeStartElement("ParquetTextConfiguration").writeEndElement();
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueryFormat from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueryFormat if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the QueryFormat.
     */
    public static QueryFormat fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueryFormat from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueryFormat if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the QueryFormat.
     */
    public static QueryFormat fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "QueryFormat" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            QueryFormat deserializedQueryFormat = new QueryFormat();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Type".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.type = QueryFormatType.fromString(reader.getStringElement());
                } else if ("DelimitedTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.delimitedTextConfiguration
                        = DelimitedTextConfiguration.fromXml(reader, "DelimitedTextConfiguration");
                } else if ("JsonTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.jsonTextConfiguration
                        = JsonTextConfiguration.fromXml(reader, "JsonTextConfiguration");
                } else if ("ArrowConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.arrowConfiguration
                        = ArrowConfiguration.fromXml(reader, "ArrowConfiguration");
                } else if ("ParquetTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.parquetTextConfiguration = new Object();
                    xmlReader.skipElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueryFormat;
        });
    }
}
