// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.PageRange;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import java.util.ArrayList;
import java.util.List;

/** The PageListSegment model. */
@Fluent
public final class PageListSegment implements XmlSerializable<BlobHierarchyListSegment> {
    /*
     * The PageRanges property.
     */
    private List<PageRange> pageRanges = new ArrayList<>();

    /*
     * The ClearRanges property.
     */
    private List<ClearRange> clearRanges = new ArrayList<>();

    /*
     * The NextMarker property.
     */
    private String nextMarker;

    /**
     * Get the pageRanges property: The PageRanges property.
     *
     * @return the pageRanges value.
     */
    public List<PageRange> getPageRanges() {
        return this.pageRanges;
    }

    /**
     * Set the pageRanges property: The PageRanges property.
     *
     * @param pageRanges the pageRanges value to set.
     * @return the PageListSegment object itself.
     */
    public PageListSegment setPageRanges(List<PageRange> pageRanges) {
        this.pageRanges = pageRanges;
        return this;
    }

    /**
     * Get the clearRanges property: The ClearRanges property.
     *
     * @return the clearRanges value.
     */
    public List<ClearRange> getClearRanges() {
        return this.clearRanges;
    }

    /**
     * Set the clearRanges property: The ClearRanges property.
     *
     * @param clearRanges the clearRanges value to set.
     * @return the PageListSegment object itself.
     */
    public PageListSegment setClearRanges(List<ClearRange> clearRanges) {
        this.clearRanges = clearRanges;
        return this;
    }

    /**
     * Get the nextMarker property: The NextMarker property.
     *
     * @return the nextMarker value.
     */
    public String getNextMarker() {
        return this.nextMarker;
    }

    /**
     * Set the nextMarker property: The NextMarker property.
     *
     * @param nextMarker the nextMarker value to set.
     * @return the PageListSegment object itself.
     */
    public PageListSegment setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageListSegment" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.pageRanges != null) {
            for (PageRange element : this.pageRanges) {
                xmlWriter.writeXml(element, "PageRange");
            }
        }
        if (this.clearRanges != null) {
            for (ClearRange element : this.clearRanges) {
                xmlWriter.writeXml(element, "ClearRange");
            }
        }
        xmlWriter.writeStringElement(this.nextMarker, "NextMarker");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of PageListSegment from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @return An instance of PageListSegment if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the PageListSegment.
     */
    public static PageListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of PageListSegment from the XmlReader.
     *
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of PageListSegment if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object was missing any required properties.
     * @throws XMLStreamException If an error occurs while reading the PageListSegment.
     */
    public static PageListSegment fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "PageListSegment" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            PageListSegment deserializedPageListSegment = new PageListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("PageRange".equals(elementName.getLocalPart())) {
                    if (deserializedPageListSegment.pageRanges == null) {
                        deserializedPageListSegment.pageRanges = new ArrayList<>();
                    }
                    deserializedPageListSegment.pageRanges.add(PageRange.fromXml(reader, "PageRange"));
                } else if ("ClearRange".equals(elementName.getLocalPart())) {
                    if (deserializedPageListSegment.clearRanges == null) {
                        deserializedPageListSegment.clearRanges = new ArrayList<>();
                    }
                    deserializedPageListSegment.clearRanges.add(ClearRange.fromXml(reader, "ClearRange"));
                } else if ("NextMarker".equals(elementName.getLocalPart())) {
                    deserializedPageListSegment.nextMarker = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }
            return deserializedPageListSegment;
        });
    }
}
