// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.BlockBlobsCommitBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsGetBlockListHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsPutBlobFromUrlHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockFromURLHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsStageBlockHeaders;
import com.azure.storage.blob.implementation.models.BlockBlobsUploadHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobCopySourceTagsMode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.BlockLookupList;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import com.azure.storage.blob.implementation.util.ModelHelper;

/**
 * An instance of this class provides access to all the operations defined in BlockBlobs.
 */
public final class BlockBlobsImpl {

    /**
     * The proxy service used to perform REST calls.
     */
    private final BlockBlobsService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureBlobStorageImpl client;

    /**
     * Initializes an instance of BlockBlobsImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    BlockBlobsImpl(AzureBlobStorageImpl client) {
        this.service
            = RestProxy.create(BlockBlobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureBlobStorageBlockBlobs to be used by the proxy service to perform
     * REST calls.
     */
    @Host("{url}")
    @ServiceInterface(name = "AzureBlobStorageBloc")
    public interface BlockBlobsService {

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> upload(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> uploadNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> upload(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> uploadNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsUploadHeaders, Void> uploadSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> uploadNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrl(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-source-if-tags") String sourceIfTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-tags") String blobTagsString, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-copy-source-blob-properties") Boolean copySourceBlobProperties,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-copy-source-tag-option") BlobCopySourceTagsMode copySourceTags,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> putBlobFromUrlNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-source-if-tags") String sourceIfTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-tags") String blobTagsString, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-copy-source-blob-properties") Boolean copySourceBlobProperties,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-copy-source-tag-option") BlobCopySourceTagsMode copySourceTags,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void> putBlobFromUrlSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-source-if-tags") String sourceIfTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-tags") String blobTagsString, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-copy-source-blob-properties") Boolean copySourceBlobProperties,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-copy-source-tag-option") BlobCopySourceTagsMode copySourceTags,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> putBlobFromUrlNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @HeaderParam("x-ms-blob-type") String blobType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-source-if-tags") String sourceIfTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-tags") String blobTagsString, @HeaderParam("x-ms-copy-source") String copySource,
            @HeaderParam("x-ms-copy-source-blob-properties") Boolean copySourceBlobProperties,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("x-ms-copy-source-tag-option") BlobCopySourceTagsMode copySourceTags,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlock(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> stageBlockNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") Flux<ByteBuffer> body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlock(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> stageBlockNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsStageBlockHeaders, Void> stageBlockSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> stageBlockNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-structured-body") String structuredBodyType,
            @HeaderParam("x-ms-structured-content-length") Long structuredContentLength,
            @BodyParam("application/octet-stream") BinaryData body, @HeaderParam("Accept") String accept,
            Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURL(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> stageBlockFromURLNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void> stageBlockFromURLSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> stageBlockFromURLNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("blockid") String blockId,
            @HeaderParam("Content-Length") long contentLength, @HeaderParam("x-ms-copy-source") String sourceUrl,
            @HeaderParam("x-ms-source-range") String sourceRange,
            @HeaderParam("x-ms-source-content-md5") String sourceContentMD5,
            @HeaderParam("x-ms-source-content-crc64") String sourceContentcrc64, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-source-if-modified-since") DateTimeRfc1123 sourceIfModifiedSince,
            @HeaderParam("x-ms-source-if-unmodified-since") DateTimeRfc1123 sourceIfUnmodifiedSince,
            @HeaderParam("x-ms-source-if-match") String sourceIfMatch,
            @HeaderParam("x-ms-source-if-none-match") String sourceIfNoneMatch,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("x-ms-copy-source-authorization") String copySourceAuthorization,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockList(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @BodyParam("application/xml") BlockLookupList blocks,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<Void>> commitBlockListNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @BodyParam("application/xml") BlockLookupList blocks,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsCommitBlockListHeaders, Void> commitBlockListSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @BodyParam("application/xml") BlockLookupList blocks,
            @HeaderParam("Accept") String accept, Context context);

        @Put("/{containerName}/{blob}")
        @ExpectedResponses({ 201 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<Void> commitBlockListNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-blob-cache-control") String cacheControl,
            @HeaderParam("x-ms-blob-content-type") String contentType,
            @HeaderParam("x-ms-blob-content-encoding") String contentEncoding,
            @HeaderParam("x-ms-blob-content-language") String contentLanguage,
            @HeaderParam("x-ms-blob-content-md5") String contentMd5,
            @HeaderParam("Content-MD5") String transactionalContentMD5,
            @HeaderParam("x-ms-content-crc64") String transactionalContentCrc64,
            @HeaderParam("x-ms-meta-") Map<String, String> metadata, @HeaderParam("x-ms-lease-id") String leaseId,
            @HeaderParam("x-ms-blob-content-disposition") String contentDisposition,
            @HeaderParam("x-ms-encryption-key") String encryptionKey,
            @HeaderParam("x-ms-encryption-key-sha256") String encryptionKeySha256,
            @HeaderParam("x-ms-encryption-algorithm") EncryptionAlgorithmType encryptionAlgorithm,
            @HeaderParam("x-ms-encryption-scope") String encryptionScope,
            @HeaderParam("x-ms-access-tier") AccessTier tier,
            @HeaderParam("If-Modified-Since") DateTimeRfc1123 ifModifiedSince,
            @HeaderParam("If-Unmodified-Since") DateTimeRfc1123 ifUnmodifiedSince,
            @HeaderParam("If-Match") String ifMatch, @HeaderParam("If-None-Match") String ifNoneMatch,
            @HeaderParam("x-ms-if-tags") String ifTags, @HeaderParam("x-ms-version") String version,
            @HeaderParam("x-ms-client-request-id") String requestId, @HeaderParam("x-ms-tags") String blobTagsString,
            @HeaderParam("x-ms-immutability-policy-until-date") DateTimeRfc1123 immutabilityPolicyExpiry,
            @HeaderParam("x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode immutabilityPolicyMode,
            @HeaderParam("x-ms-legal-hold") Boolean legalHold, @BodyParam("application/xml") BlockLookupList blocks,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockList(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("blocklisttype") BlockListType listType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Mono<Response<BlockList>> getBlockListNoCustomHeaders(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("blocklisttype") BlockListType listType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        ResponseBase<BlockBlobsGetBlockListHeaders, BlockList> getBlockListSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("blocklisttype") BlockListType listType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);

        @Get("/{containerName}/{blob}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(BlobStorageExceptionInternal.class)
        Response<BlockList> getBlockListNoCustomHeadersSync(@HostParam("url") String url,
            @PathParam("containerName") String containerName, @PathParam("blob") String blob,
            @QueryParam("comp") String comp, @QueryParam("snapshot") String snapshot,
            @QueryParam("blocklisttype") BlockListType listType, @QueryParam("timeout") Integer timeout,
            @HeaderParam("x-ms-lease-id") String leaseId, @HeaderParam("x-ms-if-tags") String ifTags,
            @HeaderParam("x-ms-version") String version, @HeaderParam("x-ms-client-request-id") String requestId,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.upload(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .upload(this.client.getUrl(), containerName, blob, blobType, timeout, transactionalContentMD5Converted,
                contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl,
                metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch,
                ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, transactionalContentCrc64Converted, structuredBodyType,
                structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, transactionalContentCrc64,
            structuredBodyType, structuredContentLength, blobHttpHeaders, cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, transactionalContentCrc64,
            structuredBodyType, structuredContentLength, blobHttpHeaders, cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType,
                timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.upload(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsUploadHeaders, Void>> uploadWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .upload(this.client.getUrl(), containerName, blob, blobType, timeout, transactionalContentMD5Converted,
                contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl,
                metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
                encryptionScope, tier, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch,
                ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, transactionalContentCrc64Converted, structuredBodyType,
                structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, BinaryData body,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, transactionalContentCrc64,
            structuredBodyType, structuredContentLength, blobHttpHeaders, cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> uploadAsync(String containerName, String blob, long contentLength, BinaryData body,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return uploadWithResponseAsync(containerName, blob, contentLength, body, timeout, transactionalContentMD5,
            metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId,
            blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, transactionalContentCrc64,
            structuredBodyType, structuredContentLength, blobHttpHeaders, cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType,
                timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> uploadNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .uploadNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsUploadHeaders, Void> uploadWithResponse(String containerName, String blob,
        long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "BlockBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            return service.uploadSync(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void upload(String containerName, String blob, long contentLength, BinaryData body, Integer timeout,
        byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, byte[] transactionalContentCrc64,
        String structuredBodyType, Long structuredContentLength, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        uploadWithResponse(containerName, blob, contentLength, body, timeout, transactionalContentMD5, metadata,
            leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags, requestId, blobTagsString,
            immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold, transactionalContentCrc64, structuredBodyType,
            structuredContentLength, blobHttpHeaders, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Upload Block Blob operation updates the content of an existing block blob. Updating an existing block blob
     * overwrites any existing metadata on the blob. Partial updates are not supported with Put Blob; the content of the
     * existing blob is overwritten with the content of the new blob. To perform a partial update of the content of a
     * block blob, use the Put Block List operation.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> uploadNoCustomHeadersWithResponse(String containerName, String blob, long contentLength,
        BinaryData body, Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId,
        AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        byte[] transactionalContentCrc64, String structuredBodyType, Long structuredContentLength,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "BlockBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            return service.uploadNoCustomHeadersSync(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold,
                transactionalContentCrc64Converted, structuredBodyType, structuredContentLength, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrlWithResponseAsync(
        String containerName, String blob, long contentLength, String copySource, Integer timeout,
        byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5,
        String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization,
        BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return FluxUtil
            .withContext(context -> service.putBlobFromUrl(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
                this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource,
                copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void>> putBlobFromUrlWithResponseAsync(
        String containerName, String blob, long contentLength, String copySource, Integer timeout,
        byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5,
        String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization,
        BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return service
            .putBlobFromUrl(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
                this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource,
                copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> putBlobFromUrlAsync(String containerName, String blob, long contentLength, String copySource,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5,
        String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization,
        BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return putBlobFromUrlWithResponseAsync(containerName, blob, contentLength, copySource, timeout,
            transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
            requestId, sourceContentMD5, blobTagsString, copySourceBlobProperties, copySourceAuthorization,
            copySourceTags, blobHttpHeaders, cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> putBlobFromUrlAsync(String containerName, String blob, long contentLength, String copySource,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5,
        String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization,
        BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return putBlobFromUrlWithResponseAsync(containerName, blob, contentLength, copySource, timeout,
            transactionalContentMD5, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch,
            ifTags, sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
            requestId, sourceContentMD5, blobTagsString, copySourceBlobProperties, copySourceAuthorization,
            copySourceTags, blobHttpHeaders, cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> putBlobFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString,
        Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return FluxUtil
            .withContext(context -> service.putBlobFromUrlNoCustomHeaders(this.client.getUrl(), containerName, blob,
                blobType, timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding,
                contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                sourceIfTags, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString,
                copySource, copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> putBlobFromUrlNoCustomHeadersWithResponseAsync(String containerName, String blob,
        long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString,
        Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String blobType = "BlockBlob";
        final String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        return service
            .putBlobFromUrlNoCustomHeaders(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
                this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource,
                copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsPutBlobFromUrlHeaders, Void> putBlobFromUrlWithResponse(String containerName,
        String blob, long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString,
        Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "BlockBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            return service.putBlobFromUrlSync(this.client.getUrl(), containerName, blob, blobType, timeout,
                transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
                this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource,
                copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void putBlobFromUrl(String containerName, String blob, long contentLength, String copySource,
        Integer timeout, byte[] transactionalContentMD5, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5,
        String blobTagsString, Boolean copySourceBlobProperties, String copySourceAuthorization,
        BlobCopySourceTagsMode copySourceTags, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        putBlobFromUrlWithResponse(containerName, blob, contentLength, copySource, timeout, transactionalContentMD5,
            metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch, ifNoneMatch, ifTags,
            sourceIfModifiedSince, sourceIfUnmodifiedSince, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, requestId,
            sourceContentMD5, blobTagsString, copySourceBlobProperties, copySourceAuthorization, copySourceTags,
            blobHttpHeaders, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Put Blob from URL operation creates a new Block Blob where the contents of the blob are read from a given
     * URL. This API is supported beginning with the 2020-04-08 version. Partial updates are not supported with Put Blob
     * from URL; the content of an existing blob is overwritten with the content of the new blob. To perform partial
     * updates to a block blob's contents using a source URL, use the Put Block from URL API in conjunction with Put
     * Block List.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param contentLength The length of the request.
     * @param copySource Specifies the name of the source page blob snapshot. This value is a URL of up to 2 KB in
     * length that specifies a page blob snapshot. The value should be URL-encoded as it would appear in a request URI.
     * The source blob must either be public or must be authenticated via a shared access signature.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param sourceIfTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param copySourceBlobProperties Optional, default is true. Indicates if properties from the source blob should be
     * copied.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param copySourceTags Optional, default 'replace'. Indicates if source tags should be copied or replaced with the
     * tags specified by x-ms-tags.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> putBlobFromUrlNoCustomHeadersWithResponse(String containerName, String blob,
        long contentLength, String copySource, Integer timeout, byte[] transactionalContentMD5,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String sourceIfTags, String requestId, byte[] sourceContentMD5, String blobTagsString,
        Boolean copySourceBlobProperties, String copySourceAuthorization, BlobCopySourceTagsMode copySourceTags,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String blobType = "BlockBlob";
            final String accept = "application/xml";
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            return service.putBlobFromUrlNoCustomHeadersSync(this.client.getUrl(), containerName, blob, blobType,
                timeout, transactionalContentMD5Converted, contentLength, contentType, contentEncoding, contentLanguage,
                contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags,
                this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, copySource,
                copySourceBlobProperties, copySourceAuthorization, copySourceTags, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName,
        String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.stageBlock(this.client.getUrl(), containerName, blob, comp, blockId,
                contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(),
                requestId, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName,
        String blob, String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .stageBlock(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength,
        Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout,
        String leaseId, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, leaseId, requestId, structuredBodyType, structuredContentLength,
            cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength,
        Flux<ByteBuffer> body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout,
        String leaseId, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, leaseId, requestId, structuredBodyType, structuredContentLength,
            cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName,
            blob, comp, blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted,
            timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
            this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, Flux<ByteBuffer> body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName,
        String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil
            .withContext(context -> service.stageBlock(this.client.getUrl(), containerName, blob, comp, blockId,
                contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(),
                requestId, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockHeaders, Void>> stageBlockWithResponseAsync(String containerName,
        String blob, String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .stageBlock(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength,
        BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout,
        String leaseId, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        return stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, leaseId, requestId, structuredBodyType, structuredContentLength,
            cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockAsync(String containerName, String blob, String blockId, long contentLength,
        BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout,
        String leaseId, String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        return stageBlockWithResponseAsync(containerName, blob, blockId, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, leaseId, requestId, structuredBodyType, structuredContentLength,
            cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return FluxUtil.withContext(context -> service.stageBlockNoCustomHeaders(this.client.getUrl(), containerName,
            blob, comp, blockId, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted,
            timeout, leaseId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope,
            this.client.getVersion(), requestId, structuredBodyType, structuredContentLength, body, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        return service
            .stageBlockNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsStageBlockHeaders, Void> stageBlockWithResponse(String containerName, String blob,
        String blockId, long contentLength, BinaryData body, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Integer timeout, String leaseId, String requestId, String structuredBodyType,
        Long structuredContentLength, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "block";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            return service.stageBlockSync(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(), requestId,
                structuredBodyType, structuredContentLength, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stageBlock(String containerName, String blob, String blockId, long contentLength, BinaryData body,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Integer timeout, String leaseId,
        String requestId, String structuredBodyType, Long structuredContentLength, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        stageBlockWithResponse(containerName, blob, blockId, contentLength, body, transactionalContentMD5,
            transactionalContentCrc64, timeout, leaseId, requestId, structuredBodyType, structuredContentLength,
            cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param body Initial data.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param structuredBodyType Required if the request body is a structured message. Specifies the message schema
     * version and properties.
     * @param structuredContentLength Required if the request body is a structured message. Specifies the length of the
     * blob/file content inside the message body. Will always be smaller than Content-Length.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stageBlockNoCustomHeadersWithResponse(String containerName, String blob, String blockId,
        long contentLength, BinaryData body, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Integer timeout, String leaseId, String requestId, String structuredBodyType, Long structuredContentLength,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "block";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            return service.stageBlockNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, blockId,
                contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, timeout, leaseId,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, this.client.getVersion(),
                requestId, structuredBodyType, structuredContentLength, body, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURLWithResponseAsync(
        String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil
            .withContext(context -> service.stageBlockFromURL(this.client.getUrl(), containerName, blob, comp, blockId,
                contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void>> stageBlockFromURLWithResponseAsync(
        String containerName, String blob, String blockId, long contentLength, String sourceUrl, String sourceRange,
        byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, String leaseId,
        OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch,
        String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo,
        EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service
            .stageBlockFromURL(this.client.getUrl(), containerName, blob, comp, blockId, contentLength, sourceUrl,
                sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId,
                copySourceAuthorization, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockFromURLAsync(String containerName, String blob, String blockId, long contentLength,
        String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return stageBlockFromURLWithResponseAsync(containerName, blob, blockId, contentLength, sourceUrl, sourceRange,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, sourceIfModifiedSince, sourceIfUnmodifiedSince,
            sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stageBlockFromURLAsync(String containerName, String blob, String blockId, long contentLength,
        String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return stageBlockFromURLWithResponseAsync(containerName, blob, blockId, contentLength, sourceUrl, sourceRange,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, sourceIfModifiedSince, sourceIfUnmodifiedSince,
            sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam,
            context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince,
        OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId,
        String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return FluxUtil.withContext(context -> service.stageBlockFromURLNoCustomHeaders(this.client.getUrl(),
            containerName, blob, comp, blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted,
            sourceContentcrc64Converted, timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm,
            encryptionScope, leaseId, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch,
            sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stageBlockFromURLNoCustomHeadersWithResponseAsync(String containerName, String blob,
        String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince,
        OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId,
        String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "block";
        final String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        DateTimeRfc1123 sourceIfModifiedSinceConverted
            = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
            = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return service
            .stageBlockFromURLNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, blockId, contentLength,
                sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, sourceIfModifiedSinceConverted,
                sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId,
                copySourceAuthorization, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsStageBlockFromURLHeaders, Void> stageBlockFromURLWithResponse(String containerName,
        String blob, String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince,
        OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId,
        String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "block";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.stageBlockFromURLSync(this.client.getUrl(), containerName, blob, comp, blockId,
                contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout,
                encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stageBlockFromURL(String containerName, String blob, String blockId, long contentLength,
        String sourceUrl, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout,
        String leaseId, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince,
        String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        stageBlockFromURLWithResponse(containerName, blob, blockId, contentLength, sourceUrl, sourceRange,
            sourceContentMD5, sourceContentcrc64, timeout, leaseId, sourceIfModifiedSince, sourceIfUnmodifiedSince,
            sourceIfMatch, sourceIfNoneMatch, requestId, copySourceAuthorization, cpkInfo, encryptionScopeParam,
            Context.NONE);
    }

    /**
     * The Stage Block operation creates a new block to be committed as part of a blob where the contents are read from
     * a URL.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blockId A valid Base64 string value that identifies the block. Prior to encoding, the string must be less
     * than or equal to 64 bytes in size. For a given blob, the length of the value specified for the blockid parameter
     * must be the same size for each block.
     * @param contentLength The length of the request.
     * @param sourceUrl Specify a URL to the copy source.
     * @param sourceRange Bytes of source data in the specified range.
     * @param sourceContentMD5 Specify the md5 calculated for the range of bytes that must be read from the copy source.
     * @param sourceContentcrc64 Specify the crc64 calculated for the range of bytes that must be read from the copy
     * source.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param sourceIfModifiedSince Specify this header value to operate only on a blob if it has been modified since
     * the specified date/time.
     * @param sourceIfUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified
     * since the specified date/time.
     * @param sourceIfMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param sourceIfNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param copySourceAuthorization Only Bearer type is supported. Credentials should be a valid OAuth access token to
     * copy source.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stageBlockFromURLNoCustomHeadersWithResponse(String containerName, String blob,
        String blockId, long contentLength, String sourceUrl, String sourceRange, byte[] sourceContentMD5,
        byte[] sourceContentcrc64, Integer timeout, String leaseId, OffsetDateTime sourceIfModifiedSince,
        OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId,
        String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "block";
            final String accept = "application/xml";
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
            String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
            DateTimeRfc1123 sourceIfModifiedSinceConverted
                = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
            DateTimeRfc1123 sourceIfUnmodifiedSinceConverted
                = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
            return service.stageBlockFromURLNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp,
                blockId, contentLength, sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted,
                timeout, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId,
                sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch,
                this.client.getVersion(), requestId, copySourceAuthorization, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockListWithResponseAsync(
        String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil
            .withContext(context -> service.commitBlockList(this.client.getUrl(), containerName, blob, comp, timeout,
                cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, blocks, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsCommitBlockListHeaders, Void>> commitBlockListWithResponseAsync(
        String containerName, String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service
            .commitBlockList(this.client.getUrl(), containerName, blob, comp, timeout, cacheControl, contentType,
                contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted,
                transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> commitBlockListAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId,
        AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        return commitBlockListWithResponseAsync(containerName, blob, blocks, timeout, transactionalContentMD5,
            transactionalContentCrc64, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold,
            blobHttpHeaders, cpkInfo, encryptionScopeParam)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> commitBlockListAsync(String containerName, String blob, BlockLookupList blocks, Integer timeout,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId,
        AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        return commitBlockListWithResponseAsync(containerName, blob, blocks, timeout, transactionalContentMD5,
            transactionalContentCrc64, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold,
            blobHttpHeaders, cpkInfo, encryptionScopeParam, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> commitBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob,
        BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return FluxUtil
            .withContext(context -> service.commitBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob,
                comp, timeout, cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, blocks, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> commitBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob,
        BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted
            = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted
            = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted
            = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return service
            .commitBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, timeout, cacheControl,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted,
                transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, accept,
                context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsCommitBlockListHeaders, Void> commitBlockListWithResponse(String containerName,
        String blob, BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5,
        byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId, AccessTier tier,
        OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch,
        String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "blocklist";
            final String accept = "application/xml";
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.commitBlockListSync(this.client.getUrl(), containerName, blob, comp, timeout, cacheControl,
                contentType, contentEncoding, contentLanguage, contentMd5Converted, transactionalContentMD5Converted,
                transactionalContentCrc64Converted, metadata, leaseId, contentDisposition, encryptionKey,
                encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier, ifModifiedSinceConverted,
                ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId,
                blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, blocks, accept,
                context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void commitBlockList(String containerName, String blob, BlockLookupList blocks, Integer timeout,
        byte[] transactionalContentMD5, byte[] transactionalContentCrc64, Map<String, String> metadata, String leaseId,
        AccessTier tier, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch,
        String ifNoneMatch, String ifTags, String requestId, String blobTagsString,
        OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold,
        BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam) {
        commitBlockListWithResponse(containerName, blob, blocks, timeout, transactionalContentMD5,
            transactionalContentCrc64, metadata, leaseId, tier, ifModifiedSince, ifUnmodifiedSince, ifMatch,
            ifNoneMatch, ifTags, requestId, blobTagsString, immutabilityPolicyExpiry, immutabilityPolicyMode, legalHold,
            blobHttpHeaders, cpkInfo, encryptionScopeParam, Context.NONE);
    }

    /**
     * The Commit Block List operation writes a blob by specifying the list of block IDs that make up the blob. In order
     * to be written as part of a blob, a block must have been successfully written to the server in a prior Put Block
     * operation. You can call Put Block List to update a blob by uploading only those blocks that have changed, then
     * committing the new and existing blocks together. You can do this by specifying whether to commit a block from the
     * committed block list or from the uncommitted block list, or to commit the most recently uploaded version of the
     * block, whichever list it may belong to.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param blocks Blob Blocks.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param transactionalContentMD5 Specify the transactional md5 for the body, to be validated by the service.
     * @param transactionalContentCrc64 Specify the transactional crc64 for the body, to be validated by the service.
     * @param metadata Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value
     * pairs are specified, the operation will copy the metadata from the source blob or file to the destination blob.
     * If one or more name-value pairs are specified, the destination blob is created with the specified metadata, and
     * metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names
     * must adhere to the naming rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata
     * for more information.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param tier Optional. Indicates the tier to be set on the blob.
     * @param ifModifiedSince Specify this header value to operate only on a blob if it has been modified since the
     * specified date/time.
     * @param ifUnmodifiedSince Specify this header value to operate only on a blob if it has not been modified since
     * the specified date/time.
     * @param ifMatch Specify an ETag value to operate only on blobs with a matching value.
     * @param ifNoneMatch Specify an ETag value to operate only on blobs without a matching value.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param blobTagsString Optional. Used to set blob tags in various blob operations.
     * @param immutabilityPolicyExpiry Specifies the date time when the blobs immutability policy is set to expire.
     * @param immutabilityPolicyMode Specifies the immutability policy mode to set on the blob.
     * @param legalHold Specified if a legal hold should be set on the blob.
     * @param blobHttpHeaders Parameter group.
     * @param cpkInfo Parameter group.
     * @param encryptionScopeParam Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> commitBlockListNoCustomHeadersWithResponse(String containerName, String blob,
        BlockLookupList blocks, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64,
        Map<String, String> metadata, String leaseId, AccessTier tier, OffsetDateTime ifModifiedSince,
        OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId,
        String blobTagsString, OffsetDateTime immutabilityPolicyExpiry,
        BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders,
        CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        try {
            final String comp = "blocklist";
            final String accept = "application/xml";
            String cacheControlInternal = null;
            if (blobHttpHeaders != null) {
                cacheControlInternal = blobHttpHeaders.getCacheControl();
            }
            String cacheControl = cacheControlInternal;
            String contentTypeInternal = null;
            if (blobHttpHeaders != null) {
                contentTypeInternal = blobHttpHeaders.getContentType();
            }
            String contentType = contentTypeInternal;
            String contentEncodingInternal = null;
            if (blobHttpHeaders != null) {
                contentEncodingInternal = blobHttpHeaders.getContentEncoding();
            }
            String contentEncoding = contentEncodingInternal;
            String contentLanguageInternal = null;
            if (blobHttpHeaders != null) {
                contentLanguageInternal = blobHttpHeaders.getContentLanguage();
            }
            String contentLanguage = contentLanguageInternal;
            byte[] contentMd5Internal = null;
            if (blobHttpHeaders != null) {
                contentMd5Internal = blobHttpHeaders.getContentMd5();
            }
            byte[] contentMd5 = contentMd5Internal;
            String contentDispositionInternal = null;
            if (blobHttpHeaders != null) {
                contentDispositionInternal = blobHttpHeaders.getContentDisposition();
            }
            String contentDisposition = contentDispositionInternal;
            String encryptionKeyInternal = null;
            if (cpkInfo != null) {
                encryptionKeyInternal = cpkInfo.getEncryptionKey();
            }
            String encryptionKey = encryptionKeyInternal;
            String encryptionKeySha256Internal = null;
            if (cpkInfo != null) {
                encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
            }
            String encryptionKeySha256 = encryptionKeySha256Internal;
            EncryptionAlgorithmType encryptionAlgorithmInternal = null;
            if (cpkInfo != null) {
                encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
            }
            EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
            String encryptionScopeInternal = null;
            if (encryptionScopeParam != null) {
                encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
            }
            String encryptionScope = encryptionScopeInternal;
            String contentMd5Converted = Base64Util.encodeToString(contentMd5);
            String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
            String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
            DateTimeRfc1123 ifModifiedSinceConverted
                = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
            DateTimeRfc1123 ifUnmodifiedSinceConverted
                = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
            DateTimeRfc1123 immutabilityPolicyExpiryConverted
                = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
            return service.commitBlockListNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, timeout,
                cacheControl, contentType, contentEncoding, contentLanguage, contentMd5Converted,
                transactionalContentMD5Converted, transactionalContentCrc64Converted, metadata, leaseId,
                contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, tier,
                ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags,
                this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted,
                immutabilityPolicyMode, legalHold, blocks, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockListWithResponseAsync(
        String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId,
        String ifTags, String requestId) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        return FluxUtil
            .withContext(context -> service.getBlockList(this.client.getUrl(), containerName, blob, comp, snapshot,
                listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ResponseBase<BlockBlobsGetBlockListHeaders, BlockList>> getBlockListWithResponseAsync(
        String containerName, String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId,
        String ifTags, String requestId, Context context) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        return service
            .getBlockList(this.client.getUrl(), containerName, blob, comp, snapshot, listType, timeout, leaseId, ifTags,
                this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BlockList> getBlockListAsync(String containerName, String blob, BlockListType listType, String snapshot,
        Integer timeout, String leaseId, String ifTags, String requestId) {
        return getBlockListWithResponseAsync(containerName, blob, listType, snapshot, timeout, leaseId, ifTags,
            requestId).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BlockList> getBlockListAsync(String containerName, String blob, BlockListType listType, String snapshot,
        Integer timeout, String leaseId, String ifTags, String requestId, Context context) {
        return getBlockListWithResponseAsync(containerName, blob, listType, snapshot, timeout, leaseId, ifTags,
            requestId, context).onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BlockList>> getBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob,
        BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        return FluxUtil
            .withContext(context -> service.getBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, comp,
                snapshot, listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, accept, context))
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<BlockList>> getBlockListNoCustomHeadersWithResponseAsync(String containerName, String blob,
        BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId,
        Context context) {
        final String comp = "blocklist";
        final String accept = "application/xml";
        return service
            .getBlockListNoCustomHeaders(this.client.getUrl(), containerName, blob, comp, snapshot, listType, timeout,
                leaseId, ifTags, this.client.getVersion(), requestId, accept, context)
            .onErrorMap(BlobStorageExceptionInternal.class, ModelHelper::mapToBlobStorageException);
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link ResponseBase}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ResponseBase<BlockBlobsGetBlockListHeaders, BlockList> getBlockListWithResponse(String containerName,
        String blob, BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags,
        String requestId, Context context) {
        try {
            final String comp = "blocklist";
            final String accept = "application/xml";
            return service.getBlockListSync(this.client.getUrl(), containerName, blob, comp, snapshot, listType,
                timeout, leaseId, ifTags, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BlockList getBlockList(String containerName, String blob, BlockListType listType, String snapshot,
        Integer timeout, String leaseId, String ifTags, String requestId) {
        try {
            return getBlockListWithResponse(containerName, blob, listType, snapshot, timeout, leaseId, ifTags,
                requestId, Context.NONE).getValue();
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }

    /**
     * The Get Block List operation retrieves the list of blocks that have been uploaded as part of a block blob.
     *
     * @param containerName The container name.
     * @param blob The blob name.
     * @param listType Specifies whether to return the list of committed blocks, the list of uncommitted blocks, or both
     * lists together.
     * @param snapshot The snapshot parameter is an opaque DateTime value that, when present, specifies the blob
     * snapshot to retrieve. For more information on working with blob snapshots, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob"&gt;Creating
     * a Snapshot of a Blob.&lt;/a&gt;.
     * @param timeout The timeout parameter is expressed in seconds. For more information, see &lt;a
     * href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations"&gt;Setting
     * Timeouts for Blob Service Operations.&lt;/a&gt;.
     * @param leaseId If specified, the operation only succeeds if the resource's lease is active and matches this ID.
     * @param ifTags Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
     * @param requestId Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
     * analytics logs when storage analytics logging is enabled.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws BlobStorageExceptionInternal thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BlockList> getBlockListNoCustomHeadersWithResponse(String containerName, String blob,
        BlockListType listType, String snapshot, Integer timeout, String leaseId, String ifTags, String requestId,
        Context context) {
        try {
            final String comp = "blocklist";
            final String accept = "application/xml";
            return service.getBlockListNoCustomHeadersSync(this.client.getUrl(), containerName, blob, comp, snapshot,
                listType, timeout, leaseId, ifTags, this.client.getVersion(), requestId, accept, context);
        } catch (BlobStorageExceptionInternal internalException) {
            throw ModelHelper.mapToBlobStorageException(internalException);
        }
    }
}
