/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.specialized.AppendBlobClient;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.blob.specialized.PageBlobClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.UploadUtils;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

@ServiceClient(builder=BlobClientBuilder.class)
public class BlobClient
extends BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(BlobClient.class);
    public static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final int BLOB_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final int BLOB_DEFAULT_HTBB_UPLOAD_BLOCK_SIZE = 0x800000;
    private static final int DEFAULT_FILE_READ_CHUNK_SIZE = 65536;
    private final BlobAsyncClient client;
    private BlockBlobClient blockBlobClient;
    private AppendBlobClient appendBlobClient;
    private PageBlobClient pageBlobClient;

    protected BlobClient(BlobAsyncClient client) {
        super(client);
        this.client = client;
    }

    protected BlobClient(BlobAsyncClient client, HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(client, pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.client = client;
    }

    @Override
    public BlobClient getSnapshotClient(String snapshot) {
        BlobAsyncClient asyncClient = new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope, this.getVersionId());
        return new BlobClient(asyncClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope, this.getVersionId());
    }

    @Override
    public BlobClient getVersionClient(String versionId) {
        BlobAsyncClient asyncClient = new BlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), this.encryptionScope, versionId);
        return new BlobClient(asyncClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), this.encryptionScope, versionId);
    }

    @Override
    public BlobClient getEncryptionScopeClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new BlobClient(this.client.getEncryptionScopeAsyncClient(encryptionScope), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public BlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new BlobClient(this.client.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public AppendBlobClient getAppendBlobClient() {
        if (this.appendBlobClient == null) {
            this.appendBlobClient = new SpecializedBlobClientBuilder().blobClient(this).buildAppendBlobClient();
        }
        return this.appendBlobClient;
    }

    public BlockBlobClient getBlockBlobClient() {
        if (this.blockBlobClient == null) {
            this.blockBlobClient = new SpecializedBlobClientBuilder().blobClient(this).buildBlockBlobClient();
        }
        return this.blockBlobClient;
    }

    public PageBlobClient getPageBlobClient() {
        if (this.pageBlobClient == null) {
            this.pageBlobClient = new SpecializedBlobClientBuilder().blobClient(this).buildPageBlobClient();
        }
        return this.pageBlobClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(InputStream data) {
        this.uploadWithResponse(new BlobParallelUploadOptions(data), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(InputStream data, long length) {
        this.upload(data, length, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(InputStream data, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        this.uploadWithResponse(new BlobParallelUploadOptions(data).setRequestConditions(blobRequestConditions), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(InputStream data, long length, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        this.uploadWithResponse(data, length, null, null, null, null, blobRequestConditions, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(BinaryData data) {
        this.upload(data, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void upload(BinaryData data, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        this.uploadWithResponse(new BlobParallelUploadOptions(data).setRequestConditions(blobRequestConditions), null, Context.NONE);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadWithResponse(InputStream data, long length, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        this.uploadWithResponse(new BlobParallelUploadOptions(data, length).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, context);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(BlobParallelUploadOptions options, Context context) {
        Objects.requireNonNull(options);
        return this.uploadWithResponse(options, options.getTimeout(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadWithResponse(BlobParallelUploadOptions options, Duration timeout, Context context) {
        Objects.requireNonNull(options);
        Mono upload = this.client.uploadWithResponse(options).contextWrite((ContextView)FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath) {
        this.uploadFromFile(filePath, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, boolean overwrite) {
        BlobRequestConditions requestConditions = null;
        if (!overwrite) {
            if (UploadUtils.shouldUploadInChunks((String)filePath, (Long)0x10000000L, (ClientLogger)LOGGER) && this.exists().booleanValue()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob."));
            }
            requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
        }
        this.uploadFromFile(filePath, null, null, null, null, requestConditions, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, Duration timeout) {
        this.uploadFromFileWithResponse(new BlobUploadFromFileOptions(filePath).setParallelTransferOptions(parallelTransferOptions).setHeaders(headers).setMetadata(metadata).setTier(tier).setRequestConditions(requestConditions), timeout, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BlockBlobItem> uploadFromFileWithResponse(BlobUploadFromFileOptions options, Duration timeout, Context context) {
        Mono upload = this.client.uploadFromFileWithResponse(options).contextWrite((ContextView)FluxUtil.toReactorContext((Context)context));
        try {
            return (Response)StorageImplUtils.blockWithOptionalTimeout((Mono)upload, (Duration)timeout);
        }
        catch (UncheckedIOException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)e);
        }
    }
}

