/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.storage.blob.implementation.models.BlobHierarchyListSegment;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobPrefix;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;

final class CustomHierarchicalListingDeserializer
extends JsonDeserializer<BlobHierarchyListSegment> {
    CustomHierarchicalListingDeserializer() {
    }

    public BlobHierarchyListSegment deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<BlobItem> blobItems = new ArrayList<BlobItem>();
        ArrayList<BlobPrefix> blobPrefixes = new ArrayList<BlobPrefix>();
        JsonDeserializer blobItemDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(BlobItem.class));
        JsonDeserializer blobPrefixDeserializer = ctxt.findRootValueDeserializer(ctxt.constructType(BlobPrefix.class));
        JsonToken currentToken = p.nextToken();
        while (!currentToken.name().equals("END_OBJECT")) {
            p.nextToken();
            if (p.getCurrentName().equals("Blob")) {
                blobItems.add((BlobItem)blobItemDeserializer.deserialize(p, ctxt));
            } else if (p.getCurrentName().equals("BlobPrefix")) {
                blobPrefixes.add((BlobPrefix)blobPrefixDeserializer.deserialize(p, ctxt));
            }
            currentToken = p.nextToken();
        }
        return new BlobHierarchyListSegment().setBlobItems(blobItems).setBlobPrefixes(blobPrefixes);
    }
}

