/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.storage.blob.ProgressReceiver;
import com.azure.storage.common.implementation.StorageImplUtils;

public final class ParallelTransferOptions {
    private final Integer blockSize;
    private final Integer maxConcurrency;
    private final ProgressReceiver progressReceiver;
    private final Integer maxSingleUploadSize;

    public ParallelTransferOptions(Integer blockSize, Integer maxConcurrency, ProgressReceiver progressReceiver) {
        this(blockSize, maxConcurrency, progressReceiver, null);
    }

    public ParallelTransferOptions(Integer blockSize, Integer maxConcurrency, ProgressReceiver progressReceiver, Integer maxSingleUploadSize) {
        if (blockSize != null) {
            StorageImplUtils.assertInBounds((String)"blockSize", (long)blockSize.intValue(), (long)1L, (long)0x6400000L);
        }
        this.blockSize = blockSize;
        if (maxConcurrency != null) {
            StorageImplUtils.assertInBounds((String)"maxConcurrency", (long)maxConcurrency.intValue(), (long)1L, (long)Integer.MAX_VALUE);
        }
        this.maxConcurrency = maxConcurrency;
        this.progressReceiver = progressReceiver;
        if (maxSingleUploadSize != null) {
            StorageImplUtils.assertInBounds((String)"maxSingleUploadSize", (long)maxSingleUploadSize.intValue(), (long)1L, (long)0x10000000L);
        }
        this.maxSingleUploadSize = maxSingleUploadSize;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    @Deprecated
    public Integer getNumBuffers() {
        return this.maxConcurrency;
    }

    public ProgressReceiver getProgressReceiver() {
        return this.progressReceiver;
    }

    public Integer getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }

    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }
}

