/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.BlobExpiryOptions;
import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.storage.blob.implementation.models.BlobsAbortCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsAcquireLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsBreakLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsChangeLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsCreateSnapshotResponse;
import com.azure.storage.blob.implementation.models.BlobsDeleteResponse;
import com.azure.storage.blob.implementation.models.BlobsDownloadResponse;
import com.azure.storage.blob.implementation.models.BlobsGetAccessControlResponse;
import com.azure.storage.blob.implementation.models.BlobsGetAccountInfoResponse;
import com.azure.storage.blob.implementation.models.BlobsGetPropertiesResponse;
import com.azure.storage.blob.implementation.models.BlobsGetTagsResponse;
import com.azure.storage.blob.implementation.models.BlobsQueryResponse;
import com.azure.storage.blob.implementation.models.BlobsReleaseLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsRenameResponse;
import com.azure.storage.blob.implementation.models.BlobsRenewLeaseResponse;
import com.azure.storage.blob.implementation.models.BlobsSetAccessControlResponse;
import com.azure.storage.blob.implementation.models.BlobsSetExpiryResponse;
import com.azure.storage.blob.implementation.models.BlobsSetHTTPHeadersResponse;
import com.azure.storage.blob.implementation.models.BlobsSetMetadataResponse;
import com.azure.storage.blob.implementation.models.BlobsSetTagsResponse;
import com.azure.storage.blob.implementation.models.BlobsSetTierResponse;
import com.azure.storage.blob.implementation.models.BlobsStartCopyFromURLResponse;
import com.azure.storage.blob.implementation.models.BlobsUndeleteResponse;
import com.azure.storage.blob.implementation.models.DataLakeStorageErrorException;
import com.azure.storage.blob.implementation.models.DirectoryHttpHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.QueryRequest;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import com.azure.storage.blob.models.PathRenameMode;
import com.azure.storage.blob.models.RehydratePriority;
import java.net.URL;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class BlobsImpl {
    private BlobsService service;
    private AzureBlobStorageImpl client;

    public BlobsImpl(AzureBlobStorageImpl client) {
        this.service = (BlobsService)RestProxy.create(BlobsService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<BlobsDownloadResponse> downloadWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        String range = null;
        String leaseId = null;
        Boolean rangeGetContentMD5 = null;
        Boolean rangeGetContentCRC64 = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.download(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, range, leaseId, rangeGetContentMD5, rangeGetContentCRC64, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsDownloadResponse> downloadWithRestResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String range, String leaseId, Boolean rangeGetContentMD5, Boolean rangeGetContentCRC64, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, Context context) {
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.download(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, range, leaseId, rangeGetContentMD5, rangeGetContentCRC64, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getProperties(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsGetPropertiesResponse> getPropertiesWithRestResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, Context context) {
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getProperties(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsDeleteResponse> deleteWithRestResponseAsync(String containerName, String blob, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        String leaseId = null;
        DeleteSnapshotsOptionType deleteSnapshots = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.delete(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, leaseId, deleteSnapshots, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, context);
    }

    public Mono<BlobsDeleteResponse> deleteWithRestResponseAsync(String containerName, String blob, String snapshot, String versionId, Integer timeout, String leaseId, DeleteSnapshotsOptionType deleteSnapshots, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.delete(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, leaseId, deleteSnapshots, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, context);
    }

    public Mono<BlobsSetAccessControlResponse> setAccessControlWithRestResponseAsync(Context context) {
        Integer timeout = null;
        String leaseId = null;
        String owner = null;
        String group = null;
        String posixPermissions = null;
        String posixAcl = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String action = "setAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setAccessControl(this.client.getUrl(), timeout, leaseId, owner, group, posixPermissions, posixAcl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "setAccessControl", context);
    }

    public Mono<BlobsSetAccessControlResponse> setAccessControlWithRestResponseAsync(Integer timeout, String leaseId, String owner, String group, String posixPermissions, String posixAcl, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "setAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setAccessControl(this.client.getUrl(), timeout, leaseId, owner, group, posixPermissions, posixAcl, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "setAccessControl", context);
    }

    public Mono<BlobsGetAccessControlResponse> getAccessControlWithRestResponseAsync(Context context) {
        Integer timeout = null;
        Boolean upn = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String requestId = null;
        String action = "getAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.getAccessControl(this.client.getUrl(), timeout, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "getAccessControl", context);
    }

    public Mono<BlobsGetAccessControlResponse> getAccessControlWithRestResponseAsync(Integer timeout, Boolean upn, String leaseId, String ifMatch, String ifNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, Context context) {
        String action = "getAccessControl";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.getAccessControl(this.client.getUrl(), timeout, upn, leaseId, ifMatch, ifNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, requestId, this.client.getVersion(), "getAccessControl", context);
    }

    public Mono<BlobsRenameResponse> renameWithRestResponseAsync(String filesystem, String path, String renameSource, Context context) {
        Integer timeout = null;
        String directoryProperties = null;
        String posixPermissions = null;
        String posixUmask = null;
        String leaseId = null;
        String sourceLeaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String requestId = null;
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        return this.service.rename(filesystem, path, this.client.getUrl(), timeout, this.client.getPathRenameMode(), renameSource, directoryProperties, posixPermissions, posixUmask, leaseId, sourceLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<BlobsRenameResponse> renameWithRestResponseAsync(String filesystem, String path, String renameSource, Integer timeout, String directoryProperties, String posixPermissions, String posixUmask, String leaseId, String sourceLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, DirectoryHttpHeaders directoryHttpHeaders, Context context) {
        String cacheControl = null;
        if (directoryHttpHeaders != null) {
            cacheControl = directoryHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (directoryHttpHeaders != null) {
            contentType = directoryHttpHeaders.getContentType();
        }
        String contentEncoding = null;
        if (directoryHttpHeaders != null) {
            contentEncoding = directoryHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (directoryHttpHeaders != null) {
            contentLanguage = directoryHttpHeaders.getContentLanguage();
        }
        String contentDisposition = null;
        if (directoryHttpHeaders != null) {
            contentDisposition = directoryHttpHeaders.getContentDisposition();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.rename(filesystem, path, this.client.getUrl(), timeout, this.client.getPathRenameMode(), renameSource, directoryProperties, posixPermissions, posixUmask, leaseId, sourceLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, cacheControl, contentType, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<BlobsUndeleteResponse> undeleteWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        String requestId = null;
        String comp = "undelete";
        return this.service.undelete(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "undelete", context);
    }

    public Mono<BlobsUndeleteResponse> undeleteWithRestResponseAsync(String containerName, String blob, Integer timeout, String requestId, Context context) {
        String comp = "undelete";
        return this.service.undelete(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, "undelete", context);
    }

    public Mono<BlobsSetExpiryResponse> setExpiryWithRestResponseAsync(BlobExpiryOptions expiryOptions, Context context) {
        Integer timeout = null;
        String requestId = null;
        String expiresOn = null;
        String comp = "expiry";
        return this.service.setExpiry(this.client.getUrl(), timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "expiry", context);
    }

    public Mono<BlobsSetExpiryResponse> setExpiryWithRestResponseAsync(BlobExpiryOptions expiryOptions, Integer timeout, String requestId, String expiresOn, Context context) {
        String comp = "expiry";
        return this.service.setExpiry(this.client.getUrl(), timeout, this.client.getVersion(), requestId, expiryOptions, expiresOn, "expiry", context);
    }

    public Mono<BlobsSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "properties";
        String cacheControl = null;
        String contentType = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentDisposition = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String contentMd5Converted = null;
        return this.service.setHTTPHeaders(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "properties", cacheControl, contentType, contentMd5Converted, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<BlobsSetHTTPHeadersResponse> setHTTPHeadersWithRestResponseAsync(String containerName, String blob, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, BlobHttpHeaders blobHttpHeaders, Context context) {
        String comp = "properties";
        String cacheControl = null;
        if (blobHttpHeaders != null) {
            cacheControl = blobHttpHeaders.getCacheControl();
        }
        String contentType = null;
        if (blobHttpHeaders != null) {
            contentType = blobHttpHeaders.getContentType();
        }
        byte[] contentMd5 = null;
        if (blobHttpHeaders != null) {
            contentMd5 = blobHttpHeaders.getContentMd5();
        }
        String contentEncoding = null;
        if (blobHttpHeaders != null) {
            contentEncoding = blobHttpHeaders.getContentEncoding();
        }
        String contentLanguage = null;
        if (blobHttpHeaders != null) {
            contentLanguage = blobHttpHeaders.getContentLanguage();
        }
        String contentDisposition = null;
        if (blobHttpHeaders != null) {
            contentDisposition = blobHttpHeaders.getContentDisposition();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String contentMd5Converted = Base64Util.encodeToString((byte[])contentMd5);
        return this.service.setHTTPHeaders(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "properties", cacheControl, contentType, contentMd5Converted, contentEncoding, contentLanguage, contentDisposition, context);
    }

    public Mono<BlobsSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "metadata";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.setMetadata(containerName, blob, this.client.getUrl(), timeout, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "metadata", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlobsSetMetadataResponse> setMetadataWithRestResponseAsync(String containerName, String blob, Integer timeout, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "metadata";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.setMetadata(containerName, blob, this.client.getUrl(), timeout, metadata, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "metadata", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlobsAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        Integer duration = null;
        String proposedLeaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "lease";
        String action = "acquire";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.acquireLease(containerName, blob, this.client.getUrl(), timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "acquire", context);
    }

    public Mono<BlobsAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(String containerName, String blob, Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "acquire";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.acquireLease(containerName, blob, this.client.getUrl(), timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "acquire", context);
    }

    public Mono<BlobsReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, Context context) {
        Integer timeout = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "lease";
        String action = "release";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.releaseLease(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "release", context);
    }

    public Mono<BlobsReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "release";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.releaseLease(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "release", context);
    }

    public Mono<BlobsRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, Context context) {
        Integer timeout = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "lease";
        String action = "renew";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.renewLease(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "renew", context);
    }

    public Mono<BlobsRenewLeaseResponse> renewLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "renew";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.renewLease(containerName, blob, this.client.getUrl(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "renew", context);
    }

    public Mono<BlobsChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, String proposedLeaseId, Context context) {
        Integer timeout = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "lease";
        String action = "change";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.changeLease(containerName, blob, this.client.getUrl(), timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "change", context);
    }

    public Mono<BlobsChangeLeaseResponse> changeLeaseWithRestResponseAsync(String containerName, String blob, String leaseId, String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "change";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.changeLease(containerName, blob, this.client.getUrl(), timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "change", context);
    }

    public Mono<BlobsBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        Integer breakPeriod = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "lease";
        String action = "break";
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.breakLease(containerName, blob, this.client.getUrl(), timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "break", context);
    }

    public Mono<BlobsBreakLeaseResponse> breakLeaseWithRestResponseAsync(String containerName, String blob, Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, Context context) {
        String comp = "lease";
        String action = "break";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.breakLease(containerName, blob, this.client.getUrl(), timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "lease", "break", context);
    }

    public Mono<BlobsCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String leaseId = null;
        String requestId = null;
        String comp = "snapshot";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        String encryptionScope = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.createSnapshot(containerName, blob, this.client.getUrl(), timeout, metadata, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, leaseId, this.client.getVersion(), requestId, "snapshot", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, context);
    }

    public Mono<BlobsCreateSnapshotResponse> createSnapshotWithRestResponseAsync(String containerName, String blob, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScope, Context context) {
        String comp = "snapshot";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        String encryptionScope1 = null;
        if (encryptionScope != null) {
            encryptionScope1 = encryptionScope.getEncryptionScope();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.createSnapshot(containerName, blob, this.client.getUrl(), timeout, metadata, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, leaseId, this.client.getVersion(), requestId, "snapshot", encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope1, context);
    }

    public Mono<BlobsStartCopyFromURLResponse> startCopyFromURLWithRestResponseAsync(String containerName, String blob, URL copySource, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        AccessTier tier = null;
        RehydratePriority rehydratePriority = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String sourceIfTags = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String leaseId = null;
        String requestId = null;
        String blobTagsString = null;
        Boolean sealBlob = null;
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.startCopyFromURL(containerName, blob, this.client.getUrl(), timeout, metadata, tier, rehydratePriority, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, blobTagsString, sealBlob, context);
    }

    public Mono<BlobsStartCopyFromURLResponse> startCopyFromURLWithRestResponseAsync(String containerName, String blob, URL copySource, Integer timeout, Map<String, String> metadata, AccessTier tier, RehydratePriority rehydratePriority, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String sourceIfTags, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, String blobTagsString, Boolean sealBlob, Context context) {
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.startCopyFromURL(containerName, blob, this.client.getUrl(), timeout, metadata, tier, rehydratePriority, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, sourceIfTags, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, blobTagsString, sealBlob, context);
    }

    public Mono<BlobsCopyFromURLResponse> copyFromURLWithRestResponseAsync(String containerName, String blob, URL copySource, Context context) {
        Integer timeout = null;
        Map<String, String> metadata = null;
        AccessTier tier = null;
        String sourceIfMatch = null;
        String sourceIfNoneMatch = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String leaseId = null;
        String requestId = null;
        String blobTagsString = null;
        String xMsRequiresSync = "true";
        DateTimeRfc1123 sourceIfModifiedSinceConverted = null;
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        String sourceContentMD5Converted = null;
        return this.service.copyFromURL(containerName, blob, this.client.getUrl(), timeout, metadata, tier, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, "true", context);
    }

    public Mono<BlobsCopyFromURLResponse> copyFromURLWithRestResponseAsync(String containerName, String blob, URL copySource, Integer timeout, Map<String, String> metadata, AccessTier tier, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String leaseId, String requestId, byte[] sourceContentMD5, String blobTagsString, Context context) {
        String xMsRequiresSync = "true";
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        String sourceContentMD5Converted = Base64Util.encodeToString((byte[])sourceContentMD5);
        return this.service.copyFromURL(containerName, blob, this.client.getUrl(), timeout, metadata, tier, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, copySource, leaseId, this.client.getVersion(), requestId, sourceContentMD5Converted, blobTagsString, "true", context);
    }

    public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURLWithRestResponseAsync(String containerName, String blob, String copyId, Context context) {
        Integer timeout = null;
        String leaseId = null;
        String requestId = null;
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        return this.service.abortCopyFromURL(containerName, blob, this.client.getUrl(), copyId, timeout, leaseId, this.client.getVersion(), requestId, "copy", "abort", context);
    }

    public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURLWithRestResponseAsync(String containerName, String blob, String copyId, Integer timeout, String leaseId, String requestId, Context context) {
        String comp = "copy";
        String copyActionAbortConstant = "abort";
        return this.service.abortCopyFromURL(containerName, blob, this.client.getUrl(), copyId, timeout, leaseId, this.client.getVersion(), requestId, "copy", "abort", context);
    }

    public Mono<BlobsSetTierResponse> setTierWithRestResponseAsync(String containerName, String blob, AccessTier tier, Context context) {
        String snapshot = null;
        String versionId = null;
        Integer timeout = null;
        RehydratePriority rehydratePriority = null;
        String requestId = null;
        String leaseId = null;
        String ifTags = null;
        String comp = "tier";
        return this.service.setTier(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, tier, rehydratePriority, this.client.getVersion(), requestId, leaseId, ifTags, "tier", context);
    }

    public Mono<BlobsSetTierResponse> setTierWithRestResponseAsync(String containerName, String blob, AccessTier tier, String snapshot, String versionId, Integer timeout, RehydratePriority rehydratePriority, String requestId, String leaseId, String ifTags, Context context) {
        String comp = "tier";
        return this.service.setTier(containerName, blob, this.client.getUrl(), snapshot, versionId, timeout, tier, rehydratePriority, this.client.getVersion(), requestId, leaseId, ifTags, "tier", context);
    }

    public Mono<BlobsGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(String containerName, String blob, Context context) {
        String restype = "account";
        String comp = "properties";
        return this.service.getAccountInfo(containerName, blob, this.client.getUrl(), this.client.getVersion(), "account", "properties", context);
    }

    public Mono<BlobsQueryResponse> queryWithRestResponseAsync(String containerName, String blob, Context context) {
        QueryRequest queryRequest = null;
        String snapshot = null;
        Integer timeout = null;
        String leaseId = null;
        String ifMatch = null;
        String ifNoneMatch = null;
        String ifTags = null;
        String requestId = null;
        String comp = "query";
        String encryptionKey = null;
        String encryptionKeySha256 = null;
        EncryptionAlgorithmType encryptionAlgorithm = null;
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        return this.service.query(containerName, blob, this.client.getUrl(), queryRequest, snapshot, timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "query", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsQueryResponse> queryWithRestResponseAsync(String containerName, String blob, QueryRequest queryRequest, String snapshot, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, Context context) {
        String comp = "query";
        String encryptionKey = null;
        if (cpkInfo != null) {
            encryptionKey = cpkInfo.getEncryptionKey();
        }
        String encryptionKeySha256 = null;
        if (cpkInfo != null) {
            encryptionKeySha256 = cpkInfo.getEncryptionKeySha256();
        }
        EncryptionAlgorithmType encryptionAlgorithm = null;
        if (cpkInfo != null) {
            encryptionAlgorithm = cpkInfo.getEncryptionAlgorithm();
        }
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.query(containerName, blob, this.client.getUrl(), queryRequest, snapshot, timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, "query", encryptionKey, encryptionKeySha256, encryptionAlgorithm, context);
    }

    public Mono<BlobsGetTagsResponse> getTagsWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        String requestId = null;
        String snapshot = null;
        String versionId = null;
        String ifTags = null;
        String comp = "tags";
        return this.service.getTags(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, snapshot, versionId, ifTags, "tags", context);
    }

    public Mono<BlobsGetTagsResponse> getTagsWithRestResponseAsync(String containerName, String blob, Integer timeout, String requestId, String snapshot, String versionId, String ifTags, Context context) {
        String comp = "tags";
        return this.service.getTags(containerName, blob, this.client.getUrl(), timeout, this.client.getVersion(), requestId, snapshot, versionId, ifTags, "tags", context);
    }

    public Mono<BlobsSetTagsResponse> setTagsWithRestResponseAsync(String containerName, String blob, Context context) {
        Integer timeout = null;
        String versionId = null;
        String requestId = null;
        String ifTags = null;
        BlobTags tags = null;
        String comp = "tags";
        String transactionalContentMD5Converted = null;
        String transactionalContentCrc64Converted = null;
        return this.service.setTags(containerName, blob, this.client.getUrl(), this.client.getVersion(), timeout, versionId, transactionalContentMD5Converted, transactionalContentCrc64Converted, requestId, ifTags, tags, "tags", context);
    }

    public Mono<BlobsSetTagsResponse> setTagsWithRestResponseAsync(String containerName, String blob, Integer timeout, String versionId, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String requestId, String ifTags, BlobTags tags, Context context) {
        String comp = "tags";
        String transactionalContentMD5Converted = Base64Util.encodeToString((byte[])transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString((byte[])transactionalContentCrc64);
        return this.service.setTags(containerName, blob, this.client.getUrl(), this.client.getVersion(), timeout, versionId, transactionalContentMD5Converted, transactionalContentCrc64Converted, requestId, ifTags, tags, "tags", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageBlobs")
    private static interface BlobsService {
        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsDownloadResponse> download(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-range") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="x-ms-range-get-content-md5") Boolean var9, @HeaderParam(value="x-ms-range-get-content-crc64") Boolean var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-version") String var16, @HeaderParam(value="x-ms-client-request-id") String var17, @HeaderParam(value="x-ms-encryption-key") String var18, @HeaderParam(value="x-ms-encryption-key-sha256") String var19, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var20, Context var21);

        @Head(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetPropertiesResponse> getProperties(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @HeaderParam(value="x-ms-encryption-key") String var15, @HeaderParam(value="x-ms-encryption-key-sha256") String var16, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var17, Context var18);

        @Delete(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsDeleteResponse> delete(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-delete-snapshots") DeleteSnapshotsOptionType var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-if-tags") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, Context var16);

        @Patch(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<BlobsSetAccessControlResponse> setAccessControl(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-owner") String var4, @HeaderParam(value="x-ms-group") String var5, @HeaderParam(value="x-ms-permissions") String var6, @HeaderParam(value="x-ms-acl") String var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="x-ms-client-request-id") String var12, @HeaderParam(value="x-ms-version") String var13, @QueryParam(value="action") String var14, Context var15);

        @Head(value="{filesystem}/{path}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<BlobsGetAccessControlResponse> getAccessControl(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @QueryParam(value="upn") Boolean var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-version") String var10, @QueryParam(value="action") String var11, Context var12);

        @Put(value="{filesystem}/{path}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=DataLakeStorageErrorException.class)
        public Mono<BlobsRenameResponse> rename(@PathParam(value="filesystem") String var1, @PathParam(value="path") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @QueryParam(value="mode") PathRenameMode var5, @HeaderParam(value="x-ms-rename-source") String var6, @HeaderParam(value="x-ms-properties") String var7, @HeaderParam(value="x-ms-permissions") String var8, @HeaderParam(value="x-ms-umask") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-source-lease-id") String var11, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Match") String var14, @HeaderParam(value="If-None-Match") String var15, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var16, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var17, @HeaderParam(value="x-ms-source-if-match") String var18, @HeaderParam(value="x-ms-source-if-none-match") String var19, @HeaderParam(value="x-ms-version") String var20, @HeaderParam(value="x-ms-client-request-id") String var21, @HeaderParam(value="x-ms-cache-control") String var22, @HeaderParam(value="x-ms-content-type") String var23, @HeaderParam(value="x-ms-content-encoding") String var24, @HeaderParam(value="x-ms-content-language") String var25, @HeaderParam(value="x-ms-content-disposition") String var26, Context var27);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsUndeleteResponse> undelete(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetExpiryResponse> setExpiry(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="x-ms-expiry-option") BlobExpiryOptions var5, @HeaderParam(value="x-ms-expiry-time") String var6, @QueryParam(value="comp") String var7, Context var8);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetHTTPHeadersResponse> setHTTPHeaders(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-blob-cache-control") String var14, @HeaderParam(value="x-ms-blob-content-type") String var15, @HeaderParam(value="x-ms-blob-content-md5") String var16, @HeaderParam(value="x-ms-blob-content-encoding") String var17, @HeaderParam(value="x-ms-blob-content-language") String var18, @HeaderParam(value="x-ms-blob-content-disposition") String var19, Context var20);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetMetadataResponse> setMetadata(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="x-ms-if-tags") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-encryption-key") String var15, @HeaderParam(value="x-ms-encryption-key-sha256") String var16, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var17, @HeaderParam(value="x-ms-encryption-scope") String var18, Context var19);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsAcquireLeaseResponse> acquireLease(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-duration") Integer var5, @HeaderParam(value="x-ms-proposed-lease-id") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="x-ms-if-tags") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-lease-action") String var15, Context var16);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsReleaseLeaseResponse> releaseLease(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-lease-action") String var14, Context var15);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsRenewLeaseResponse> renewLease(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-lease-action") String var14, Context var15);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsChangeLeaseResponse> changeLease(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="x-ms-proposed-lease-id") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="x-ms-if-tags") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-lease-action") String var15, Context var16);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsBreakLeaseResponse> breakLease(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-lease-break-period") Integer var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13, @HeaderParam(value="x-ms-lease-action") String var14, Context var15);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsCreateSnapshotResponse> createSnapshot(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-version") String var12, @HeaderParam(value="x-ms-client-request-id") String var13, @QueryParam(value="comp") String var14, @HeaderParam(value="x-ms-encryption-key") String var15, @HeaderParam(value="x-ms-encryption-key-sha256") String var16, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var17, @HeaderParam(value="x-ms-encryption-scope") String var18, Context var19);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsStartCopyFromURLResponse> startCopyFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-access-tier") AccessTier var6, @HeaderParam(value="x-ms-rehydrate-priority") RehydratePriority var7, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var9, @HeaderParam(value="x-ms-source-if-match") String var10, @HeaderParam(value="x-ms-source-if-none-match") String var11, @HeaderParam(value="x-ms-source-if-tags") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-if-tags") String var17, @HeaderParam(value="x-ms-copy-source") URL var18, @HeaderParam(value="x-ms-lease-id") String var19, @HeaderParam(value="x-ms-version") String var20, @HeaderParam(value="x-ms-client-request-id") String var21, @HeaderParam(value="x-ms-tags") String var22, @HeaderParam(value="x-ms-seal-blob") Boolean var23, Context var24);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsCopyFromURLResponse> copyFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-meta-") Map<String, String> var5, @HeaderParam(value="x-ms-access-tier") AccessTier var6, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var8, @HeaderParam(value="x-ms-source-if-match") String var9, @HeaderParam(value="x-ms-source-if-none-match") String var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-if-tags") String var15, @HeaderParam(value="x-ms-copy-source") URL var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-version") String var18, @HeaderParam(value="x-ms-client-request-id") String var19, @HeaderParam(value="x-ms-source-content-md5") String var20, @HeaderParam(value="x-ms-tags") String var21, @HeaderParam(value="x-ms-requires-sync") String var22, Context var23);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURL(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="copyid") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @HeaderParam(value="x-ms-copy-action") String var10, Context var11);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetTierResponse> setTier(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="snapshot") String var4, @QueryParam(value="versionid") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-access-tier") AccessTier var7, @HeaderParam(value="x-ms-rehydrate-priority") RehydratePriority var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @QueryParam(value="comp") String var13, Context var14);

        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetAccountInfoResponse> getAccountInfo(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-version") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6, Context var7);

        @Post(value="{containerName}/{blob}")
        @ExpectedResponses(value={200, 206})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsQueryResponse> query(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @BodyParam(value="application/xml; charset=utf-8") QueryRequest var4, @QueryParam(value="snapshot") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="If-None-Match") String var11, @HeaderParam(value="x-ms-if-tags") String var12, @HeaderParam(value="x-ms-version") String var13, @HeaderParam(value="x-ms-client-request-id") String var14, @QueryParam(value="comp") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, Context var19);

        @Get(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsGetTagsResponse> getTags(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="snapshot") String var7, @QueryParam(value="versionid") String var8, @HeaderParam(value="x-ms-if-tags") String var9, @QueryParam(value="comp") String var10, Context var11);

        @Put(value="{containerName}/{blob}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<BlobsSetTagsResponse> setTags(@PathParam(value="containerName") String var1, @PathParam(value="blob") String var2, @HostParam(value="url") String var3, @HeaderParam(value="x-ms-version") String var4, @QueryParam(value="timeout") Integer var5, @QueryParam(value="versionid") String var6, @HeaderParam(value="Content-MD5") String var7, @HeaderParam(value="x-ms-content-crc64") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @HeaderParam(value="x-ms-if-tags") String var10, @BodyParam(value="application/xml; charset=utf-8") BlobTags var11, @QueryParam(value="comp") String var12, Context var13);
    }
}

