/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.implementation.util.BlobHeadersAndQueryParameters;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.credentials.SasTokenCredential;
import com.azure.storage.common.implementation.policy.SasTokenCredentialPolicy;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RequestRetryPolicy;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BuilderHelper {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-storage-blob.properties");
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";

    public static HttpPipeline buildPipeline(StorageSharedKeyCredential storageSharedKeyCredential, TokenCredential tokenCredential, SasTokenCredential sasTokenCredential, String endpoint, RequestRetryOptions retryOptions, HttpLogOptions logOptions, HttpClient httpClient, List<HttpPipelinePolicy> additionalPolicies, Configuration configuration, ClientLogger logger) {
        Object credentialPolicy;
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(BuilderHelper.getUserAgentPolicy(configuration, logOptions));
        policies.add(new RequestIdPolicy());
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(new RequestRetryPolicy(retryOptions));
        policies.add(new AddDatePolicy());
        if (storageSharedKeyCredential != null) {
            credentialPolicy = new StorageSharedKeyCredentialPolicy(storageSharedKeyCredential);
        } else if (tokenCredential != null) {
            BuilderHelper.httpsValidation(tokenCredential, "bearer token", endpoint, logger);
            credentialPolicy = new BearerTokenAuthenticationPolicy(tokenCredential, new String[]{"https://storage.azure.com/.default"});
        } else {
            credentialPolicy = sasTokenCredential != null ? new SasTokenCredentialPolicy(sasTokenCredential) : null;
        }
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(additionalPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        HttpLogOptions defaultOptions = new HttpLogOptions();
        BlobHeadersAndQueryParameters.getBlobHeaders().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedHeaderName(arg_0));
        BlobHeadersAndQueryParameters.getBlobQueryParameters().forEach(arg_0 -> ((HttpLogOptions)defaultOptions).addAllowedQueryParamName(arg_0));
        return defaultOptions;
    }

    public static String getEndpoint(BlobUrlParts parts) throws MalformedURLException {
        if (ModelHelper.determineAuthorityIsIpStyle(parts.getHost())) {
            return String.format("%s://%s/%s", parts.getScheme(), parts.getHost(), parts.getAccountName());
        }
        return String.format("%s://%s", parts.getScheme(), parts.getHost());
    }

    public static void httpsValidation(Object objectToCheck, String objectName, String endpoint, ClientLogger logger) {
        if (objectToCheck != null && !BlobUrlParts.parse(endpoint).getScheme().equals("https")) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Using a(n) " + objectName + " requires https"));
        }
    }

    private static UserAgentPolicy getUserAgentPolicy(Configuration configuration, HttpLogOptions logOptions) {
        configuration = configuration == null ? Configuration.NONE : configuration;
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        return new UserAgentPolicy(logOptions.getApplicationId(), clientName, clientVersion, configuration);
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").addOptionalEcho("x-ms-encryption-key-sha256").build();
    }
}

