/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.common.ParallelTransferOptions;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.nio.file.OpenOption;
import java.util.Set;

public class BlobDownloadToFileOptions {
    private final String filePath;
    private BlobRange range;
    private ParallelTransferOptions parallelTransferOptions;
    private DownloadRetryOptions downloadRetryOptions;
    private BlobRequestConditions requestConditions;
    private boolean rangeGetContentMd5;
    private Set<OpenOption> openOptions;

    public BlobDownloadToFileOptions(String filePath) {
        StorageImplUtils.assertNotNull((String)"filePath", (Object)filePath);
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public BlobRange getRange() {
        return this.range;
    }

    public ParallelTransferOptions getParallelTransferOptions() {
        return this.parallelTransferOptions;
    }

    public DownloadRetryOptions getDownloadRetryOptions() {
        return this.downloadRetryOptions;
    }

    public BlobRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public boolean isRangeGetContentMd5() {
        return this.rangeGetContentMd5;
    }

    public Set<OpenOption> getOpenOptions() {
        return this.openOptions;
    }

    public BlobDownloadToFileOptions setRange(BlobRange range) {
        this.range = range;
        return this;
    }

    public BlobDownloadToFileOptions setParallelTransferOptions(ParallelTransferOptions parallelTransferOptions) {
        this.parallelTransferOptions = parallelTransferOptions;
        return this;
    }

    public BlobDownloadToFileOptions setDownloadRetryOptions(DownloadRetryOptions downloadRetryOptions) {
        this.downloadRetryOptions = downloadRetryOptions;
        return this;
    }

    public BlobDownloadToFileOptions setRequestConditions(BlobRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public BlobDownloadToFileOptions setRangeGetContentMd5(boolean rangeGetContentMd5) {
        this.rangeGetContentMd5 = rangeGetContentMd5;
        return this;
    }

    public BlobDownloadToFileOptions setOpenOptions(Set<OpenOption> openOptions) {
        this.openOptions = openOptions;
        return this;
    }
}

