// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * the quick query body.
 */
@JacksonXmlRootElement(localName = "QueryRequest")
@Fluent
public final class QueryRequest {
    /*
     * the query type
     */
    @JsonProperty(value = "QueryType", required = true)
    private String queryType;

    /*
     * a query statement
     */
    @JsonProperty(value = "Expression", required = true)
    private String expression;

    /*
     * The inputSerialization property.
     */
    @JsonProperty(value = "InputSerialization")
    private QuerySerialization inputSerialization;

    /*
     * The outputSerialization property.
     */
    @JsonProperty(value = "OutputSerialization")
    private QuerySerialization outputSerialization;

    /**
     * Creates an instance of QueryRequest class.
     */
    public QueryRequest() {
        queryType = "SQL";
    }

    /**
     * Get the queryType property: the query type.
     *
     * @return the queryType value.
     */
    public String getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: the query type.
     *
     * @param queryType the queryType value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setQueryType(String queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the expression property: a query statement.
     *
     * @return the expression value.
     */
    public String getExpression() {
        return this.expression;
    }

    /**
     * Set the expression property: a query statement.
     *
     * @param expression the expression value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Get the inputSerialization property: The inputSerialization property.
     *
     * @return the inputSerialization value.
     */
    public QuerySerialization getInputSerialization() {
        return this.inputSerialization;
    }

    /**
     * Set the inputSerialization property: The inputSerialization property.
     *
     * @param inputSerialization the inputSerialization value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setInputSerialization(QuerySerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
        return this;
    }

    /**
     * Get the outputSerialization property: The outputSerialization property.
     *
     * @return the outputSerialization value.
     */
    public QuerySerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    /**
     * Set the outputSerialization property: The outputSerialization property.
     *
     * @param outputSerialization the outputSerialization value to set.
     * @return the QueryRequest object itself.
     */
    public QueryRequest setOutputSerialization(QuerySerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
        return this;
    }
}
