/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation.connectionstring;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettings;
import com.azure.storage.common.implementation.connectionstring.ConnectionSettingsFilter;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;

final class StorageServiceConnectionString {
    StorageServiceConnectionString() {
    }

    static StorageConnectionString tryCreate(ConnectionSettings settings, ClientLogger logger) {
        ConnectionSettingsFilter automaticEndpointsMatchSpec = StorageServiceConnectionString.automaticEndpointsMatchSpec();
        ConnectionSettingsFilter explicitEndpointsMatchSpec = StorageServiceConnectionString.explicitEndpointsMatchSpec();
        boolean matchesAutomaticEndpointsSpec = ConnectionSettingsFilter.matchesSpecification(settings, automaticEndpointsMatchSpec);
        boolean matchesExplicitEndpointsSpec = ConnectionSettingsFilter.matchesSpecification(settings, explicitEndpointsMatchSpec);
        if (matchesAutomaticEndpointsSpec || matchesExplicitEndpointsSpec) {
            if (matchesAutomaticEndpointsSpec && !settings.hasSetting("DefaultEndpointsProtocol")) {
                settings.setSetting("DefaultEndpointsProtocol", "https");
            }
            String blobEndpoint = settings.getSettingValue("BlobEndpoint");
            String queueEndpoint = settings.getSettingValue("QueueEndpoint");
            String tableEndpoint = settings.getSettingValue("TableEndpoint");
            String fileEndpoint = settings.getSettingValue("FileEndpoint");
            String blobSecondaryEndpoint = settings.getSettingValue("BlobSecondaryEndpoint");
            String queueSecondaryEndpoint = settings.getSettingValue("QueueSecondaryEndpoint");
            String tableSecondaryEndpoint = settings.getSettingValue("TableSecondaryEndpoint");
            String fileSecondaryEndpoint = settings.getSettingValue("FileSecondaryEndpoint");
            if (StorageServiceConnectionString.isValidPrimarySecondaryPair(blobEndpoint, blobSecondaryEndpoint).booleanValue() && StorageServiceConnectionString.isValidPrimarySecondaryPair(queueEndpoint, queueSecondaryEndpoint).booleanValue() && StorageServiceConnectionString.isValidPrimarySecondaryPair(tableEndpoint, tableSecondaryEndpoint).booleanValue() && StorageServiceConnectionString.isValidPrimarySecondaryPair(fileEndpoint, fileSecondaryEndpoint).booleanValue()) {
                return new StorageConnectionString(StorageAuthenticationSettings.fromConnectionSettings(settings), StorageEndpoint.fromStorageSettings(settings, "blob", "BlobEndpoint", "BlobSecondaryEndpoint", matchesAutomaticEndpointsSpec, logger), StorageEndpoint.fromStorageSettings(settings, "queue", "QueueEndpoint", "QueueSecondaryEndpoint", matchesAutomaticEndpointsSpec, logger), StorageEndpoint.fromStorageSettings(settings, "table", "TableEndpoint", "TableSecondaryEndpoint", matchesAutomaticEndpointsSpec, logger), StorageEndpoint.fromStorageSettings(settings, "file", "FileEndpoint", "FileSecondaryEndpoint", matchesAutomaticEndpointsSpec, logger), settings.getSettingValue("AccountName"));
            }
        }
        return null;
    }

    private static ConnectionSettingsFilter automaticEndpointsMatchSpec() {
        return ConnectionSettingsFilter.matchesExactly(ConnectionSettingsFilter.matchesAll(ConnectionSettingsFilter.matchesOne(ConnectionSettingsFilter.matchesAll(StorageServiceConnectionString.requireAccountKey()), StorageServiceConnectionString.requireSas()), StorageServiceConnectionString.requireAccountName(), StorageServiceConnectionString.optionalEndpoints(), StorageServiceConnectionString.optionalEndpointProtocolAndSuffix()));
    }

    private static ConnectionSettingsFilter explicitEndpointsMatchSpec() {
        ConnectionSettingsFilter validCredentials = ConnectionSettingsFilter.matchesOne(StorageServiceConnectionString.requireAccountNameAndKeyNoSas(), StorageServiceConnectionString.requireSasOptionalAccountNameNoAccountKey(), StorageServiceConnectionString.noAccountNameNoAccountKeyNoSas());
        return ConnectionSettingsFilter.matchesExactly(ConnectionSettingsFilter.matchesAll(validCredentials, StorageServiceConnectionString.requireAtLeastOnePrimaryEndpoint(), StorageServiceConnectionString.optionalSecondaryEndpoints()));
    }

    private static ConnectionSettingsFilter requireAccountName() {
        return ConnectionSettingsFilter.allRequired("AccountName");
    }

    private static ConnectionSettingsFilter requireAccountKey() {
        return ConnectionSettingsFilter.allRequired("AccountKey");
    }

    private static ConnectionSettingsFilter requireSas() {
        return ConnectionSettingsFilter.allRequired("SharedAccessSignature");
    }

    private static ConnectionSettingsFilter requireAccountNameAndKey() {
        return ConnectionSettingsFilter.allRequired("AccountName", "AccountKey");
    }

    private static ConnectionSettingsFilter optionalAccountName() {
        return ConnectionSettingsFilter.optional("AccountName");
    }

    private static ConnectionSettingsFilter noAccountKey() {
        return ConnectionSettingsFilter.none("AccountKey");
    }

    private static ConnectionSettingsFilter noSas() {
        return ConnectionSettingsFilter.none("SharedAccessSignature");
    }

    private static ConnectionSettingsFilter requireAccountNameAndKeyNoSas() {
        return ConnectionSettingsFilter.matchesAll(StorageServiceConnectionString.requireAccountNameAndKey(), StorageServiceConnectionString.noSas());
    }

    private static ConnectionSettingsFilter requireSasOptionalAccountNameNoAccountKey() {
        return ConnectionSettingsFilter.matchesAll(StorageServiceConnectionString.requireSas(), StorageServiceConnectionString.optionalAccountName(), StorageServiceConnectionString.noAccountKey());
    }

    private static ConnectionSettingsFilter noAccountNameNoAccountKeyNoSas() {
        return ConnectionSettingsFilter.none("AccountName", "AccountKey", "SharedAccessSignature");
    }

    private static ConnectionSettingsFilter optionalEndpointProtocolAndSuffix() {
        return ConnectionSettingsFilter.optional("DefaultEndpointsProtocol", "EndpointSuffix");
    }

    private static ConnectionSettingsFilter optionalEndpoints() {
        return ConnectionSettingsFilter.optional("BlobEndpoint", "BlobSecondaryEndpoint", "QueueEndpoint", "QueueSecondaryEndpoint", "TableEndpoint", "TableSecondaryEndpoint", "FileEndpoint", "FileSecondaryEndpoint");
    }

    private static ConnectionSettingsFilter requireAtLeastOnePrimaryEndpoint() {
        return ConnectionSettingsFilter.atLeastOne("BlobEndpoint", "QueueEndpoint", "TableEndpoint", "FileEndpoint");
    }

    private static ConnectionSettingsFilter optionalSecondaryEndpoints() {
        return ConnectionSettingsFilter.optional("BlobSecondaryEndpoint", "QueueSecondaryEndpoint", "TableSecondaryEndpoint", "FileSecondaryEndpoint");
    }

    private static Boolean isValidPrimarySecondaryPair(String primary, String secondary) {
        if (primary != null) {
            return true;
        }
        if (secondary == null) {
            return true;
        }
        return false;
    }
}

