/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ScrubEtagPolicy
implements HttpPipelinePolicy {
    private static final String ETAG = "eTag";
    private HttpResponse innerHttpResponse;
    private HttpHeaders headers;

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> Mono.just((Object)this.scrubETagHeader((HttpResponse)response)));
    }

    private HttpResponse scrubETagHeader(HttpResponse unprocessedResponse) {
        HttpHeader eTagHeader = unprocessedResponse.getHeaders().get(ETAG);
        if (eTagHeader == null) {
            return unprocessedResponse;
        }
        String eTag = eTagHeader.getValue();
        eTag = eTag.replace("\"", "");
        this.headers = unprocessedResponse.getHeaders();
        this.headers.put(eTagHeader.getName(), eTag);
        this.innerHttpResponse = unprocessedResponse;
        return new InnerHttpResponse(unprocessedResponse.getRequest());
    }

    private final class InnerHttpResponse
    extends HttpResponse {
        protected InnerHttpResponse(HttpRequest request) {
            super(request);
        }

        public int getStatusCode() {
            return ScrubEtagPolicy.this.innerHttpResponse.getStatusCode();
        }

        public String getHeaderValue(String name) {
            return ScrubEtagPolicy.this.innerHttpResponse.getHeaderValue(name);
        }

        public HttpHeaders getHeaders() {
            return ScrubEtagPolicy.this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return ScrubEtagPolicy.this.innerHttpResponse.getBody();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return ScrubEtagPolicy.this.innerHttpResponse.getBodyAsByteArray();
        }

        public Mono<String> getBodyAsString() {
            return ScrubEtagPolicy.this.innerHttpResponse.getBodyAsString();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return ScrubEtagPolicy.this.innerHttpResponse.getBodyAsString(charset);
        }
    }
}

