/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.Utility;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StorageImplUtils {
    private static final ClientLogger LOGGER = new ClientLogger(StorageImplUtils.class);
    private static final String ARGUMENT_NULL_OR_EMPTY = "The argument must not be null or an empty string. Argument name: %s.";
    private static final String PARAMETER_NOT_IN_RANGE = "The value of the parameter '%s' should be between %s and %s.";
    private static final String NO_PATH_SEGMENTS = "URL %s does not contain path segments.";

    public static Map<String, String> parseQueryString(String queryString) {
        return StorageImplUtils.parseQueryStringHelper(queryString, Utility::urlDecode);
    }

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        return StorageImplUtils.parseQueryStringHelper(queryString, value -> Utility.urlDecode(value).split(","));
    }

    private static <T> Map<String, T> parseQueryStringHelper(String queryString, Function<String, T> valueParser) {
        TreeMap<String, T> pieces = new TreeMap<String, T>();
        if (CoreUtils.isNullOrEmpty((CharSequence)queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf("=");
            String key = Utility.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            T value = valueParser.apply(kvp.substring(equalIndex + 1));
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static <T> T blockWithOptionalTimeout(Mono<T> response, Duration timeout) {
        if (timeout == null) {
            return (T)response.block();
        }
        return (T)response.block(timeout);
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> Flux<T> applyOptionalTimeout(Flux<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new NullPointerException(String.format(Locale.ROOT, ARGUMENT_NULL_OR_EMPTY, param));
        }
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Locale.ROOT, PARAMETER_NOT_IN_RANGE, param, min, max)));
        }
    }

    public static String computeHMac256(String base64Key, String stringToSign) {
        try {
            byte[] key = Base64.getDecoder().decode(base64Key);
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            hmacSHA256.init(new SecretKeySpec(key, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes(StandardCharsets.UTF_8);
            return Base64.getEncoder().encodeToString(hmacSHA256.doFinal(utf8Bytes));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL appendToUrlPath(String baseURL, String name) {
        UrlBuilder builder = UrlBuilder.parse((String)baseURL);
        if (builder.getPath() == null) {
            builder.setPath("/");
        } else if (!builder.getPath().endsWith("/")) {
            builder.setPath(builder.getPath() + "/");
        }
        builder.setPath(builder.getPath() + name);
        try {
            return builder.toUrl();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static URL stripLastPathSegment(URL baseUrl) {
        UrlBuilder builder = UrlBuilder.parse((URL)baseUrl);
        if (builder.getPath() == null || !builder.getPath().contains("/")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, NO_PATH_SEGMENTS, baseUrl));
        }
        builder.setPath(builder.getPath().substring(0, builder.getPath().lastIndexOf("/")));
        try {
            return builder.toUrl();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String getAccountName(URL url) {
        UrlBuilder builder = UrlBuilder.parse((URL)url);
        String accountName = null;
        String host = builder.getHost();
        if (!CoreUtils.isNullOrEmpty((CharSequence)host)) {
            int accountNameIndex = host.indexOf(46);
            accountName = accountNameIndex == -1 ? host : host.substring(0, accountNameIndex);
        }
        return accountName;
    }
}

