/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.sas;

import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Function;

public abstract class BaseSasQueryParameters {
    protected String version;
    protected SasProtocol protocol;
    protected OffsetDateTime startTime;
    protected OffsetDateTime expiryTime;
    protected SasIpRange sasIpRange;
    protected String permissions;
    protected String signature;

    public BaseSasQueryParameters(Map<String, String[]> queryParamsMap, boolean removeSASParametersFromMap) {
        this.version = this.getQueryParameter(queryParamsMap, "sv", removeSASParametersFromMap);
        this.protocol = this.getQueryParameter(queryParamsMap, "spr", removeSASParametersFromMap, SasProtocol::parse);
        this.startTime = this.getQueryParameter(queryParamsMap, "st", removeSASParametersFromMap, Utility::parseDate);
        this.expiryTime = this.getQueryParameter(queryParamsMap, "se", removeSASParametersFromMap, Utility::parseDate);
        this.sasIpRange = this.getQueryParameter(queryParamsMap, "sip", removeSASParametersFromMap, SasIpRange::parse);
        this.permissions = this.getQueryParameter(queryParamsMap, "sp", removeSASParametersFromMap);
        this.signature = this.getQueryParameter(queryParamsMap, "sig", removeSASParametersFromMap);
    }

    protected String getQueryParameter(Map<String, String[]> parameters, String name, boolean remove) {
        return this.getQueryParameter(parameters, name, remove, value -> value);
    }

    protected <T> T getQueryParameter(Map<String, String[]> parameters, String name, boolean remove, Function<String, T> converter) {
        String[] parameterValue = parameters.get(name);
        if (parameterValue == null) {
            return null;
        }
        if (remove) {
            parameters.remove(name);
        }
        return converter.apply(parameterValue[0]);
    }

    public BaseSasQueryParameters(String version, SasProtocol protocol, OffsetDateTime startTime, OffsetDateTime expiryTime, SasIpRange sasIpRange, String permissions, String signature) {
        this.version = version;
        this.protocol = protocol;
        this.startTime = startTime;
        this.expiryTime = expiryTime;
        this.sasIpRange = sasIpRange;
        this.permissions = permissions;
        this.signature = signature;
    }

    public String getVersion() {
        return this.version;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getSignature() {
        return this.signature;
    }

    protected void tryAppendQueryParameter(StringBuilder sb, String param, Object value) {
        if (value != null) {
            if (sb.length() != 0) {
                sb.append('&');
            }
            sb.append(Utility.urlEncode(param)).append('=').append(Utility.urlEncode(value.toString()));
        }
    }

    protected String formatQueryParameterDate(OffsetDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Constants.ISO_8601_UTC_DATE_FORMATTER.format(dateTime);
    }

    public abstract String encode();
}

