/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common;

import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Utility {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String INVALID_DATE_STRING = "Invalid Date String: %s.";
    public static final String STORAGE_TRACING_NAMESPACE_VALUE = "Microsoft.Storage";
    private static final String MAX_PRECISION_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String ISO8601_PATTERN_NO_SECONDS = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final int MAX_PRECISION_DATESTRING_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS".replaceAll("'", "").length();

    public static String urlDecode(String stringToDecode) {
        if (CoreUtils.isNullOrEmpty((CharSequence)stringToDecode)) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToDecode.length(); ++m) {
                if (stringToDecode.charAt(m) != '+') continue;
                if (m > startDex) {
                    outBuilder.append(Utility.decode(stringToDecode.substring(startDex, m)));
                }
                outBuilder.append("+");
                startDex = m + 1;
            }
            if (startDex != stringToDecode.length()) {
                outBuilder.append(Utility.decode(stringToDecode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return Utility.decode(stringToDecode);
    }

    private static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        if (stringToEncode.contains(" ")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToEncode.length(); ++m) {
                if (stringToEncode.charAt(m) != ' ') continue;
                if (m > startDex) {
                    outBuilder.append(Utility.encode(stringToEncode.substring(startDex, m)));
                }
                outBuilder.append("%20");
                startDex = m + 1;
            }
            if (startDex != stringToEncode.length()) {
                outBuilder.append(Utility.encode(stringToEncode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return Utility.encode(stringToEncode);
    }

    private static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String encodeUrlPath(String url) {
        UrlBuilder builder = UrlBuilder.parse((String)url);
        String path = builder.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        path = Utility.urlEncode(Utility.urlDecode(path));
        builder.setPath(path);
        return builder.toString();
    }

    public static OffsetDateTime parseDate(String dateString) {
        String pattern = MAX_PRECISION_PATTERN;
        switch (dateString.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                dateString = dateString.substring(0, MAX_PRECISION_DATESTRING_LENGTH);
                break;
            }
            case 23: {
                dateString = dateString.replace("Z", "0");
                break;
            }
            case 22: {
                dateString = dateString.replace("Z", "00");
                break;
            }
            case 20: {
                pattern = ISO8601_PATTERN;
                break;
            }
            case 17: {
                pattern = ISO8601_PATTERN_NO_SECONDS;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, INVALID_DATE_STRING, dateString));
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.ROOT);
        return LocalDateTime.parse(dateString, formatter).atZone(ZoneOffset.UTC).toOffsetDateTime();
    }

    public static Flux<ByteBuffer> convertStreamToByteBuffer(InputStream data, long length, int blockSize) {
        return Utility.convertStreamToByteBuffer(data, length, blockSize, true);
    }

    public static Flux<ByteBuffer> convertStreamToByteBuffer(InputStream data, long length, int blockSize, boolean markAndReset) {
        if (markAndReset) {
            data.mark(Integer.MAX_VALUE);
        }
        return Flux.defer(() -> {
            long[] currentTotalLength = new long[1];
            if (markAndReset) {
                try {
                    data.reset();
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(e));
                }
            }
            return Flux.range((int)0, (int)((int)Math.ceil((double)length / (double)blockSize))).map(i -> i * blockSize).concatMap(pos -> Mono.fromCallable(() -> {
                long count = (long)(pos + blockSize) > length ? length - (long)pos.intValue() : (long)blockSize;
                byte[] cache = new byte[(int)count];
                int numOfBytes = 0;
                int offset = 0;
                int len = (int)count;
                while (numOfBytes != -1 && (long)offset < count) {
                    numOfBytes = data.read(cache, offset, len);
                    offset += numOfBytes;
                    len -= numOfBytes;
                    if (numOfBytes == -1) continue;
                    currentTotalLength[0] = currentTotalLength[0] + (long)numOfBytes;
                }
                if (numOfBytes == -1 && currentTotalLength[0] < length) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new UnexpectedLengthException(String.format("Request body emitted %d bytes, less than the expected %d bytes.", currentTotalLength[0], length), currentTotalLength[0], length));
                }
                return ByteBuffer.wrap(cache);
            })).doOnComplete(() -> {
                try {
                    if (data.read() != -1) {
                        long totalLength = currentTotalLength[0] + (long)data.available();
                        throw LOGGER.logExceptionAsError((RuntimeException)new UnexpectedLengthException(String.format("Request body emitted %d bytes, more than the expected %d bytes.", totalLength, length), totalLength, length));
                    }
                    if (currentTotalLength[0] > length) {
                        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Read more data than was requested. Size of data read: %d. Size of data requested: %d", currentTotalLength[0], length)));
                    }
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("I/O errors occurs. Error details: " + e.getMessage()));
                }
            });
        });
    }

    public static String appendQueryParameter(String url, String key, String value) {
        url = url.contains("?") ? String.format("%s&%s=%s", url, key, value) : String.format("%s?%s=%s", url, key, value);
        return url;
    }
}

