/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import java.util.Optional;

public final class DevopsPipeline {
    private static final DevopsPipeline INSTANCE = DevopsPipeline.readFromEnvironment();
    private final String jobName;
    private final String buildId;
    private final String definitionName;
    private final String buildReason;
    private final String teamProject;
    private final boolean setsDevVersion;

    private DevopsPipeline(String jobName, String buildId, String definitionName, String buildReason, String teamProject, boolean setsDevVersion) {
        this.jobName = jobName;
        this.buildId = buildId;
        this.definitionName = definitionName;
        this.buildReason = buildReason;
        this.teamProject = teamProject;
        this.setsDevVersion = setsDevVersion;
    }

    public static Optional<DevopsPipeline> getInstance() {
        return Optional.ofNullable(INSTANCE);
    }

    private static DevopsPipeline readFromEnvironment() {
        boolean isRunningOnAgent = Boolean.parseBoolean(System.getenv().getOrDefault("TF_BUILD", "false"));
        if (isRunningOnAgent) {
            String jobName = System.getenv("AGENT_JOBNAME");
            String buildId = System.getenv("BUILD_BUILDID");
            String definitionName = System.getenv("BUILD_DEFINITIONNAME");
            String buildReason = System.getenv("BUILD_REASON");
            String teamProject = System.getenv("SYSTEM_TEAMPROJECT");
            String setDevVersionString = System.getenv("SETDEVVERSION");
            boolean setDevVersion = Boolean.parseBoolean(setDevVersionString);
            return new DevopsPipeline(jobName, buildId, definitionName, buildReason, teamProject, setDevVersion);
        }
        return null;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public String getBuildReason() {
        return this.buildReason;
    }

    public String getTeamProject() {
        return this.teamProject;
    }

    public boolean getSetsDevVersion() {
        return this.setsDevVersion;
    }

    public boolean releasesToMavenCentral() {
        return this.definitionName.equals("java - storage") && this.buildReason.equalsIgnoreCase("manual") && !this.setsDevVersion;
    }
}

