/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.storage.common.test.shared.ServiceVersionValidationPolicy;
import com.azure.storage.common.test.shared.StorageResourceNamer;
import com.azure.storage.common.test.shared.TestDataFactory;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.TestHttpClientType;
import com.azure.storage.common.test.shared.TestNameProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import okhttp3.ConnectionPool;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="StorageSpec.groovy", line=26)
public class StorageSpec
extends Specification
implements GroovyObject {
    private static final TestEnvironment ENVIRONMENT;
    private static final HttpClient NETTY_HTTP_CLIENT;
    private static final HttpClient OK_HTTP_CLIENT;
    private static final ClientLogger LOGGER;
    @FieldMetadata(line=32, name="interceptorManager", ordinal=0, initializer=false)
    private InterceptorManager interceptorManager;
    @FieldMetadata(line=33, name="namer", ordinal=1, initializer=false)
    private StorageResourceNamer namer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public StorageSpec() {
        MetaClass metaClass;
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private Object setup() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        Object testName = callSiteArray[0].call(TestNameProvider.class, callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this)));
        Object object = callSiteArray[3].callConstructor(InterceptorManager.class, testName, callSiteArray[4].callGetProperty((Object)ENVIRONMENT));
        this.interceptorManager = (InterceptorManager)ScriptBytecodeAdapter.castToType((Object)object, InterceptorManager.class);
        Object object2 = callSiteArray[5].callConstructor(StorageResourceNamer.class, testName, callSiteArray[6].callGetProperty((Object)ENVIRONMENT), callSiteArray[7].call((Object)this.interceptorManager));
        this.namer = (StorageResourceNamer)ScriptBytecodeAdapter.castToType((Object)object2, StorageResourceNamer.class);
        return callSiteArray[8].call((Object)LOGGER, (Object)"Test {} will use {} resource prefix.", testName, callSiteArray[9].callGetProperty((Object)this.namer));
    }

    private Object cleanup() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return callSiteArray[10].call((Object)this.interceptorManager);
    }

    protected static TestEnvironment getEnv() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return ENVIRONMENT;
    }

    protected StorageResourceNamer getNamer() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        callSiteArray[11].call(Objects.class, (Object)this.namer, (Object)"namer has not been initialized yet");
        return this.namer;
    }

    protected Object getData() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return callSiteArray[12].call(TestDataFactory.class);
    }

    protected <T> T instrument(T builder) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[13].call(builder, callSiteArray[14].callCurrent((GroovyObject)this));
        } else {
            callSiteArray[15].call(builder, (Object)this.getHttpClient());
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[16].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[17].callGetProperty(TestMode.class))) {
            callSiteArray[18].call(builder, callSiteArray[19].call((Object)this.interceptorManager));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[20].callGetProperty((Object)ENVIRONMENT), null)) {
            public final class _instrument_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _instrument_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"serviceVersion") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)1);
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)"serviceVersion") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)1);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _instrument_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "parameterCount";
                    stringArray[2] = "name";
                    stringArray[3] = "parameterCount";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _instrument_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_instrument_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _instrument_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Class serviceVersionClass = (Class)ScriptBytecodeAdapter.asType((Object)callSiteArray[21].call(callSiteArray[22].callGetProperty(callSiteArray[23].call(callSiteArray[24].callGetProperty(callSiteArray[25].callGetProperty(builder)), (Object)new _instrument_closure1((Object)this, (Object)this))), (Object)0), Class.class);
            Object parsedServiceVersion = callSiteArray[26].call(Enum.class, (Object)serviceVersionClass, callSiteArray[27].callGetProperty((Object)ENVIRONMENT));
            callSiteArray[28].call(builder, parsedServiceVersion);
            callSiteArray[29].call(builder, callSiteArray[30].callConstructor(ServiceVersionValidationPolicy.class, callSiteArray[31].callGetProperty(parsedServiceVersion)));
        }
        HttpLogOptions httpLogOptions = (HttpLogOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call(builder), HttpLogOptions.class);
        callSiteArray[33].call((Object)httpLogOptions, callSiteArray[34].callGetProperty(HttpLogDetailLevel.class));
        callSiteArray[35].call(builder, (Object)httpLogOptions);
        return builder;
    }

    protected HttpPipelinePolicy getRecordPolicy() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[36].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[37].callGetProperty(TestMode.class))) {
            return (HttpPipelinePolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[38].call((Object)this.interceptorManager), HttpPipelinePolicy.class);
        }
        public final class _getRecordPolicy_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getRecordPolicy_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getRecordPolicy_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object context, Object next) {
                CallSite[] callSiteArray = _getRecordPolicy_closure2.$getCallSiteArray();
                return callSiteArray[0].call(next);
            }

            public Object call(Object context, Object next) {
                CallSite[] callSiteArray = _getRecordPolicy_closure2.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, context, next);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRecordPolicy_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "process";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _getRecordPolicy_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_getRecordPolicy_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getRecordPolicy_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (HttpPipelinePolicy)ScriptBytecodeAdapter.castToType((Object)((Object)new _getRecordPolicy_closure2((Object)this, (Object)this)), HttpPipelinePolicy.class);
    }

    protected HttpClient getHttpClient() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[39].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[40].callGetProperty(TestMode.class))) {
            Object object = callSiteArray[41].callGetProperty((Object)ENVIRONMENT);
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[42].callGetProperty(TestHttpClientType.class))) {
                return NETTY_HTTP_CLIENT;
            }
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[43].callGetProperty(TestHttpClientType.class))) {
                return OK_HTTP_CLIENT;
            }
            throw (Throwable)callSiteArray[44].callConstructor(IllegalArgumentException.class, callSiteArray[45].call((Object)"Unknown http client type: ", callSiteArray[46].callGetProperty((Object)ENVIRONMENT)));
        }
        return (HttpClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].call((Object)this.interceptorManager), HttpClient.class);
    }

    private static String getAuthToken() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[48].callGetProperty(callSiteArray[49].callGetProperty(StorageSpec.class)), (Object)callSiteArray[50].callGetProperty(TestMode.class))) {
            return "recordingBearerToken";
        }
        public final class _getAuthToken_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAuthToken_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getAuthToken_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getAuthToken_closure3.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getAuthToken_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAuthToken_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "getToken";
                return new CallSiteArray(_getAuthToken_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAuthToken_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[51].call(callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].callConstructor(EnvironmentCredentialBuilder.class)), callSiteArray[56].call(callSiteArray[57].callConstructor(TokenRequestContext.class), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"https://storage.azure.com/.default"}))), (Object)new _getAuthToken_closure3(StorageSpec.class, StorageSpec.class))));
    }

    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times, Duration delay) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        Object i = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)times, (boolean)false)), Iterator.class);
        while (iterator.hasNext()) {
            i = iterator.next();
            Object object = callSiteArray[59].call(action);
            try {
                return (T)object;
            }
            catch (Exception e) {
                block7: {
                    if (!(!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call(retryPredicate, (Object)e)))) break block7;
                    throw (Throwable)e;
                }
                callSiteArray[61].call(Thread.class, callSiteArray[62].call((Object)delay));
            }
        }
        return null;
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return this.retry(action, retryPredicate, times, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[63].call(Duration.class, (Object)10), Duration.class));
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return this.retry(action, retryPredicate, 6, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[64].call(Duration.class, (Object)10), Duration.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != StorageSpec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = StorageSpec.$getCallSiteArray()[65].call(TestEnvironment.class);
        ENVIRONMENT = (TestEnvironment)ScriptBytecodeAdapter.castToType((Object)object, TestEnvironment.class);
        Object object2 = StorageSpec.$getCallSiteArray()[66].call(StorageSpec.$getCallSiteArray()[67].callConstructor(NettyAsyncHttpClientBuilder.class));
        NETTY_HTTP_CLIENT = (HttpClient)ScriptBytecodeAdapter.castToType((Object)object2, HttpClient.class);
        Object object3 = StorageSpec.$getCallSiteArray()[68].call(StorageSpec.$getCallSiteArray()[69].call(StorageSpec.$getCallSiteArray()[70].callConstructor(OkHttpAsyncHttpClientBuilder.class), StorageSpec.$getCallSiteArray()[71].callConstructor(ConnectionPool.class, (Object)50, (Object)5, StorageSpec.$getCallSiteArray()[72].callGetProperty(TimeUnit.class))));
        OK_HTTP_CLIENT = (HttpClient)ScriptBytecodeAdapter.castToType((Object)object3, HttpClient.class);
        Object object4 = StorageSpec.$getCallSiteArray()[73].callConstructor(ClientLogger.class, StorageSpec.class);
        LOGGER = (ClientLogger)ScriptBytecodeAdapter.castToType((Object)object4, ClientLogger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getTestName";
        stringArray[1] = "getCurrentIteration";
        stringArray[2] = "specificationContext";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "testMode";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "testMode";
        stringArray[7] = "getRecordedData";
        stringArray[8] = "info";
        stringArray[9] = "resourcePrefix";
        stringArray[10] = "close";
        stringArray[11] = "requireNonNull";
        stringArray[12] = "getInstance";
        stringArray[13] = "httpClient";
        stringArray[14] = "getHttpClient";
        stringArray[15] = "httpClient";
        stringArray[16] = "testMode";
        stringArray[17] = "RECORD";
        stringArray[18] = "addPolicy";
        stringArray[19] = "getRecordPolicy";
        stringArray[20] = "serviceVersion";
        stringArray[21] = "getAt";
        stringArray[22] = "parameterTypes";
        stringArray[23] = "find";
        stringArray[24] = "methods";
        stringArray[25] = "class";
        stringArray[26] = "valueOf";
        stringArray[27] = "serviceVersion";
        stringArray[28] = "serviceVersion";
        stringArray[29] = "addPolicy";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "version";
        stringArray[32] = "getDefaultHttpLogOptions";
        stringArray[33] = "setLogLevel";
        stringArray[34] = "HEADERS";
        stringArray[35] = "httpLogOptions";
        stringArray[36] = "testMode";
        stringArray[37] = "RECORD";
        stringArray[38] = "getRecordPolicy";
        stringArray[39] = "testMode";
        stringArray[40] = "PLAYBACK";
        stringArray[41] = "httpClientType";
        stringArray[42] = "NETTY";
        stringArray[43] = "OK_HTTP";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "plus";
        stringArray[46] = "httpClientType";
        stringArray[47] = "getPlaybackClient";
        stringArray[48] = "testMode";
        stringArray[49] = "env";
        stringArray[50] = "PLAYBACK";
        stringArray[51] = "block";
        stringArray[52] = "map";
        stringArray[53] = "getToken";
        stringArray[54] = "build";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "setScopes";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "iterator";
        stringArray[59] = "get";
        stringArray[60] = "call";
        stringArray[61] = "sleep";
        stringArray[62] = "toMillis";
        stringArray[63] = "ofSeconds";
        stringArray[64] = "ofSeconds";
        stringArray[65] = "getInstance";
        stringArray[66] = "build";
        stringArray[67] = "<$constructor$>";
        stringArray[68] = "build";
        stringArray[69] = "connectionPool";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "MINUTES";
        stringArray[73] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[74];
        StorageSpec.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StorageSpec.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StorageSpec.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

