/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.test.TestMode;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.test.shared.TestAccount;
import com.azure.storage.common.test.shared.TestHttpClientType;
import java.util.Locale;

public final class TestEnvironment {
    private static final ClientLogger LOGGER = new ClientLogger(TestEnvironment.class);
    private static final TestEnvironment INSTANCE = new TestEnvironment();
    private final TestHttpClientType httpClientType;
    private final TestMode testMode = TestEnvironment.readTestModeFromEnvironment();
    private final String serviceVersion = this.readServiceVersionFromEnvironment();
    private final String resourceGroupName;
    private final String subscriptionId;
    private final TestAccount primaryAccount;
    private final TestAccount secondaryAccount;
    private final TestAccount managedDiskAccount;
    private final TestAccount premiumAccount;
    private final TestAccount versionedAccount;
    private final TestAccount dataLakeAccount;
    private final TestAccount premiumFileAccount;
    private final TestAccount softDeleteAccount;
    private final TestAccount dataLakeSoftDeleteAccount;

    private TestEnvironment() {
        this.httpClientType = TestEnvironment.readHttpClientTypeFromEnvironment();
        System.out.println(String.format("Tests will run with %s http client", new Object[]{this.httpClientType}));
        this.resourceGroupName = Configuration.getGlobalConfiguration().get("STORAGE_RESOURCE_GROUP_NAME");
        this.subscriptionId = Configuration.getGlobalConfiguration().get("STORAGE_SUBSCRIPTION_ID");
        this.primaryAccount = TestEnvironment.readTestAccountFromEnvironment("PRIMARY_STORAGE_", this.testMode);
        this.secondaryAccount = TestEnvironment.readTestAccountFromEnvironment("SECONDARY_STORAGE_", this.testMode);
        this.managedDiskAccount = TestEnvironment.readTestAccountFromEnvironment("MANAGED_DISK_STORAGE_", this.testMode);
        this.premiumAccount = TestEnvironment.readTestAccountFromEnvironment("PREMIUM_STORAGE_", this.testMode);
        this.versionedAccount = TestEnvironment.readTestAccountFromEnvironment("VERSIONED_STORAGE_", this.testMode);
        this.dataLakeAccount = TestEnvironment.readTestAccountFromEnvironment("STORAGE_DATA_LAKE_", this.testMode);
        this.premiumFileAccount = TestEnvironment.readTestAccountFromEnvironment("PREMIUM_STORAGE_FILE_", this.testMode);
        this.softDeleteAccount = TestEnvironment.readTestAccountFromEnvironment("SOFT_DELETE_STORAGE_", this.testMode);
        this.dataLakeSoftDeleteAccount = TestEnvironment.readTestAccountFromEnvironment("STORAGE_DATA_LAKE_SOFT_DELETE_", this.testMode);
    }

    public static TestEnvironment getInstance() {
        return INSTANCE;
    }

    private static TestMode readTestModeFromEnvironment() {
        TestMode testMode;
        String azureTestMode = Configuration.getGlobalConfiguration().get("AZURE_TEST_MODE");
        if (azureTestMode != null) {
            try {
                testMode = TestMode.valueOf((String)azureTestMode.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error("Could not parse '{}' into TestMode. Using 'Playback' mode.", new Object[]{azureTestMode});
                testMode = TestMode.PLAYBACK;
            }
        } else {
            LOGGER.info("Environment variable '{}' has not been set yet. Using 'Playback' mode.", new Object[]{"AZURE_TEST_MODE"});
            testMode = TestMode.PLAYBACK;
        }
        System.out.println(String.format("--------%s---------", testMode));
        return testMode;
    }

    private String readServiceVersionFromEnvironment() {
        String serviceVersion = Configuration.getGlobalConfiguration().get("AZURE_LIVE_TEST_SERVICE_VERSION");
        if (serviceVersion == null || serviceVersion.trim().isEmpty()) {
            System.out.println("Tests will run with default service version");
            return null;
        }
        System.out.println(String.format("Tests will run with %s service version", serviceVersion));
        return serviceVersion;
    }

    private static TestAccount readTestAccountFromEnvironment(String prefix, TestMode testMode) {
        String name = "azstoragesdkaccount";
        String key = "astorageaccountkey";
        String connectionString = "DefaultEndpointsProtocol=https;AccountName=teststorage;AccountKey=atestaccountkey;EndpointSuffix=core.windows.net";
        if (testMode != TestMode.PLAYBACK) {
            name = Configuration.getGlobalConfiguration().get(String.valueOf(prefix) + "ACCOUNT_NAME");
            key = Configuration.getGlobalConfiguration().get(String.valueOf(prefix) + "ACCOUNT_KEY");
            connectionString = Configuration.getGlobalConfiguration().get(String.valueOf(prefix) + "CONNECTION_STRING");
            if (connectionString == null || connectionString.trim().isEmpty()) {
                connectionString = String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", name, key);
            }
        }
        String blobEndpoint = String.format("https://%s.blob.core.windows.net", name);
        String blobEndpointSecondary = String.format("https://%s-secondary.blob.core.windows.net", name);
        String dataLakeEndpoint = String.format("https://%s.dfs.core.windows.net", name);
        String queueEndpoint = String.format("https://%s.queue.core.windows.net", name);
        String fileEndpoint = String.format("https://%s.file.core.windows.net", name);
        return new TestAccount(name, key, connectionString, blobEndpoint, blobEndpointSecondary, dataLakeEndpoint, queueEndpoint, fileEndpoint);
    }

    private static TestHttpClientType readHttpClientTypeFromEnvironment() {
        String httpClients = (String)Configuration.getGlobalConfiguration().get("AZURE_TEST_HTTP_CLIENTS", (Object)"netty");
        switch (httpClients.toLowerCase()) {
            case "netty": {
                return TestHttpClientType.NETTY;
            }
            case "okhttp": {
                return TestHttpClientType.OK_HTTP;
            }
        }
        throw new IllegalArgumentException("Unknown value of AZURE_TEST_HTTP_CLIENTS: " + httpClients);
    }

    public TestMode getTestMode() {
        return this.testMode;
    }

    public TestAccount getPrimaryAccount() {
        return this.primaryAccount;
    }

    public TestAccount getSecondaryAccount() {
        return this.secondaryAccount;
    }

    public TestAccount getPremiumAccount() {
        return this.premiumAccount;
    }

    public TestAccount getVersionedAccount() {
        return this.versionedAccount;
    }

    public TestAccount getManagedDiskAccount() {
        return this.managedDiskAccount;
    }

    public TestAccount getDataLakeAccount() {
        return this.dataLakeAccount;
    }

    public TestAccount getPremiumFileAccount() {
        return this.premiumFileAccount;
    }

    public TestAccount getSoftDeleteAccount() {
        return this.softDeleteAccount;
    }

    public TestAccount getDataLakeSoftDeleteAccount() {
        return this.dataLakeSoftDeleteAccount;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public TestHttpClientType getHttpClientType() {
        return this.httpClientType;
    }
}

