/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.storage.common.test.shared.ServiceVersionValidationPolicy;
import com.azure.storage.common.test.shared.StorageResourceNamer;
import com.azure.storage.common.test.shared.TestDataFactory;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.TestHttpClientType;
import com.azure.storage.common.test.shared.TestNameProvider;
import com.azure.storage.common.test.shared.ThreadDumper;
import com.azure.storage.common.test.shared.policy.NoOpHttpPipelinePolicy;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import okhttp3.ConnectionPool;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="StorageSpec.groovy", line=27)
public class StorageSpec
extends Specification
implements GroovyObject {
    private static final TestEnvironment ENVIRONMENT;
    private static final HttpClient NETTY_HTTP_CLIENT;
    private static final HttpClient OK_HTTP_CLIENT;
    private static final ClientLogger LOGGER;
    @FieldMetadata(line=38, name="interceptorManager", ordinal=0, initializer=false)
    private InterceptorManager interceptorManager;
    @FieldMetadata(line=39, name="namer", ordinal=1, initializer=false)
    private StorageResourceNamer namer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public StorageSpec() {
        MetaClass metaClass;
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = StorageSpec.$getCallSiteArray()[0].call(TestEnvironment.class);
        ENVIRONMENT = (TestEnvironment)ScriptBytecodeAdapter.castToType((Object)object, TestEnvironment.class);
        Object object2 = StorageSpec.$getCallSiteArray()[1].call(StorageSpec.$getCallSiteArray()[2].callConstructor(NettyAsyncHttpClientBuilder.class));
        NETTY_HTTP_CLIENT = (HttpClient)ScriptBytecodeAdapter.castToType((Object)object2, HttpClient.class);
        Object object3 = StorageSpec.$getCallSiteArray()[3].call(StorageSpec.$getCallSiteArray()[4].call(StorageSpec.$getCallSiteArray()[5].callConstructor(OkHttpAsyncHttpClientBuilder.class), StorageSpec.$getCallSiteArray()[6].callConstructor(ConnectionPool.class, (Object)50, (Object)5, StorageSpec.$getCallSiteArray()[7].callGetProperty(TimeUnit.class))));
        OK_HTTP_CLIENT = (HttpClient)ScriptBytecodeAdapter.castToType((Object)object3, HttpClient.class);
        Object object4 = StorageSpec.$getCallSiteArray()[8].callConstructor(ClientLogger.class, StorageSpec.class);
        LOGGER = (ClientLogger)ScriptBytecodeAdapter.castToType((Object)object4, ClientLogger.class);
        StorageSpec.$getCallSiteArray()[9].call(ThreadDumper.class);
    }

    private Object setup() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        Object testName = callSiteArray[10].call(TestNameProvider.class, callSiteArray[11].call(callSiteArray[12].callGroovyObjectGetProperty((Object)this)));
        Object object = callSiteArray[13].callConstructor(InterceptorManager.class, testName, callSiteArray[14].callGetProperty((Object)ENVIRONMENT));
        this.interceptorManager = (InterceptorManager)ScriptBytecodeAdapter.castToType((Object)object, InterceptorManager.class);
        Object object2 = callSiteArray[15].callConstructor(StorageResourceNamer.class, testName, callSiteArray[16].callGetProperty((Object)ENVIRONMENT), callSiteArray[17].call((Object)this.interceptorManager));
        this.namer = (StorageResourceNamer)ScriptBytecodeAdapter.castToType((Object)object2, StorageResourceNamer.class);
        return callSiteArray[18].call((Object)LOGGER, (Object)"Test {} will use {} resource prefix.", testName, callSiteArray[19].callGetProperty((Object)this.namer));
    }

    private Object cleanup() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return callSiteArray[20].call((Object)this.interceptorManager);
    }

    protected static TestEnvironment getEnvironment() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return ENVIRONMENT;
    }

    protected StorageResourceNamer getNamer() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        callSiteArray[21].call(Objects.class, (Object)this.namer, (Object)"namer has not been initialized yet");
        return this.namer;
    }

    protected Object getData() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return callSiteArray[22].call(TestDataFactory.class);
    }

    protected <T> T instrument(T builder) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[23].call(builder, callSiteArray[24].callCurrent((GroovyObject)this));
        } else {
            callSiteArray[25].call(builder, (Object)this.getHttpClient());
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[26].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[27].callGetProperty(TestMode.class))) {
            callSiteArray[28].call(builder, callSiteArray[29].call((Object)this.interceptorManager));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[30].callGetProperty((Object)ENVIRONMENT), null)) {
            public final class _instrument_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _instrument_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)"serviceVersion") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[1].callGetProperty(it), (Object)1);
                    }
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)"serviceVersion") && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty(it), (Object)1);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _instrument_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _instrument_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "name";
                    stringArray[1] = "parameterCount";
                    stringArray[2] = "name";
                    stringArray[3] = "parameterCount";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _instrument_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_instrument_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _instrument_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            Class serviceVersionClass = (Class)ScriptBytecodeAdapter.asType((Object)callSiteArray[31].call(callSiteArray[32].callGetProperty(callSiteArray[33].call(callSiteArray[34].callGetProperty(callSiteArray[35].callGetProperty(builder)), (Object)new _instrument_closure1((Object)this, (Object)this))), (Object)0), Class.class);
            Object parsedServiceVersion = callSiteArray[36].call(Enum.class, (Object)serviceVersionClass, callSiteArray[37].callGetProperty((Object)ENVIRONMENT));
            callSiteArray[38].call(builder, parsedServiceVersion);
            callSiteArray[39].call(builder, callSiteArray[40].callConstructor(ServiceVersionValidationPolicy.class, callSiteArray[41].callGetProperty(parsedServiceVersion)));
        }
        HttpLogOptions httpLogOptions = (HttpLogOptions)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(builder), HttpLogOptions.class);
        callSiteArray[43].call((Object)httpLogOptions, callSiteArray[44].callGetProperty(HttpLogDetailLevel.class));
        callSiteArray[45].call(builder, (Object)httpLogOptions);
        return builder;
    }

    protected HttpPipelinePolicy getRecordPolicy() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[46].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[47].callGetProperty(TestMode.class))) {
            return (HttpPipelinePolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)this.interceptorManager), HttpPipelinePolicy.class);
        }
        return (HttpPipelinePolicy)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callGetProperty(NoOpHttpPipelinePolicy.class), HttpPipelinePolicy.class);
    }

    protected HttpClient getHttpClient() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[50].callGetProperty((Object)ENVIRONMENT), (Object)callSiteArray[51].callGetProperty(TestMode.class))) {
            Object object = callSiteArray[52].callGetProperty((Object)ENVIRONMENT);
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[53].callGetProperty(TestHttpClientType.class))) {
                return NETTY_HTTP_CLIENT;
            }
            if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[54].callGetProperty(TestHttpClientType.class))) {
                return OK_HTTP_CLIENT;
            }
            throw (Throwable)callSiteArray[55].callConstructor(IllegalArgumentException.class, callSiteArray[56].call((Object)"Unknown http client type: ", callSiteArray[57].callGetProperty((Object)ENVIRONMENT)));
        }
        return (HttpClient)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)this.interceptorManager), HttpClient.class);
    }

    private static String getAuthToken() {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[59].callGetProperty(callSiteArray[60].callGetProperty(StorageSpec.class)), (Object)callSiteArray[61].callGetProperty(TestMode.class))) {
            return "recordingBearerToken";
        }
        public final class _getAuthToken_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAuthToken_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _getAuthToken_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _getAuthToken_closure2.$getCallSiteArray();
                return callSiteArray[0].call(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _getAuthToken_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAuthToken_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "getToken";
                return new CallSiteArray(_getAuthToken_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAuthToken_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].callConstructor(EnvironmentCredentialBuilder.class)), callSiteArray[67].call(callSiteArray[68].callConstructor(TokenRequestContext.class), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"https://storage.azure.com/.default"}))), (Object)new _getAuthToken_closure2(StorageSpec.class, StorageSpec.class))));
    }

    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times, Duration delay) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        Object i = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].call((Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)times, (boolean)false)), Iterator.class);
        while (iterator.hasNext()) {
            i = iterator.next();
            Object object = callSiteArray[70].call(action);
            try {
                return (T)object;
            }
            catch (Exception e) {
                block7: {
                    if (!(!retryPredicate.test(e))) break block7;
                    throw (Throwable)e;
                }
                callSiteArray[71].call(Thread.class, callSiteArray[72].call((Object)delay));
            }
        }
        return null;
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return this.retry(action, retryPredicate, times, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].call(Duration.class, (Object)10), Duration.class));
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate) {
        CallSite[] callSiteArray = StorageSpec.$getCallSiteArray();
        return this.retry(action, retryPredicate, 6, (Duration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].call(Duration.class, (Object)10), Duration.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != StorageSpec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getInstance";
        stringArray[1] = "build";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "build";
        stringArray[4] = "connectionPool";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "MINUTES";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "initialize";
        stringArray[10] = "getTestName";
        stringArray[11] = "getCurrentIteration";
        stringArray[12] = "specificationContext";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "testMode";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "testMode";
        stringArray[17] = "getRecordedData";
        stringArray[18] = "info";
        stringArray[19] = "resourcePrefix";
        stringArray[20] = "close";
        stringArray[21] = "requireNonNull";
        stringArray[22] = "getInstance";
        stringArray[23] = "httpClient";
        stringArray[24] = "getHttpClient";
        stringArray[25] = "httpClient";
        stringArray[26] = "testMode";
        stringArray[27] = "RECORD";
        stringArray[28] = "addPolicy";
        stringArray[29] = "getRecordPolicy";
        stringArray[30] = "serviceVersion";
        stringArray[31] = "getAt";
        stringArray[32] = "parameterTypes";
        stringArray[33] = "find";
        stringArray[34] = "methods";
        stringArray[35] = "class";
        stringArray[36] = "valueOf";
        stringArray[37] = "serviceVersion";
        stringArray[38] = "serviceVersion";
        stringArray[39] = "addPolicy";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "version";
        stringArray[42] = "getDefaultHttpLogOptions";
        stringArray[43] = "setLogLevel";
        stringArray[44] = "HEADERS";
        stringArray[45] = "httpLogOptions";
        stringArray[46] = "testMode";
        stringArray[47] = "RECORD";
        stringArray[48] = "getRecordPolicy";
        stringArray[49] = "INSTANCE";
        stringArray[50] = "testMode";
        stringArray[51] = "PLAYBACK";
        stringArray[52] = "httpClientType";
        stringArray[53] = "NETTY";
        stringArray[54] = "OK_HTTP";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "plus";
        stringArray[57] = "httpClientType";
        stringArray[58] = "getPlaybackClient";
        stringArray[59] = "testMode";
        stringArray[60] = "environment";
        stringArray[61] = "PLAYBACK";
        stringArray[62] = "block";
        stringArray[63] = "map";
        stringArray[64] = "getToken";
        stringArray[65] = "build";
        stringArray[66] = "<$constructor$>";
        stringArray[67] = "setScopes";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "iterator";
        stringArray[70] = "get";
        stringArray[71] = "sleep";
        stringArray[72] = "toMillis";
        stringArray[73] = "ofSeconds";
        stringArray[74] = "ofSeconds";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[75];
        StorageSpec.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StorageSpec.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StorageSpec.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

