/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.util.BinaryData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import reactor.core.publisher.Flux;

public final class TestDataFactory {
    private static final TestDataFactory INSTANCE = new TestDataFactory();
    private final String defaultText;
    private final byte[] defaultBytes;
    private final BinaryData defaultBinaryData;

    private TestDataFactory() {
        this.defaultText = "default";
        this.defaultBytes = this.defaultText.getBytes(StandardCharsets.UTF_8);
        this.defaultBinaryData = BinaryData.fromString((String)this.defaultText);
    }

    public static TestDataFactory getInstance() {
        return INSTANCE;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public byte[] getDefaultBytes() {
        return Arrays.copyOf(this.defaultBytes, this.defaultBytes.length);
    }

    public ByteBuffer getDefaultData() {
        return ByteBuffer.wrap(this.defaultBytes).asReadOnlyBuffer();
    }

    public InputStream getDefaultInputStream() {
        return new ByteArrayInputStream(this.defaultBytes);
    }

    public BinaryData getDefaultBinaryData() {
        return this.defaultBinaryData;
    }

    public int getDefaultDataSize() {
        return this.defaultBytes.length;
    }

    public long getDefaultDataSizeLong() {
        return this.defaultBytes.length;
    }

    public Flux<ByteBuffer> getDefaultFlux() {
        return Flux.just((Object)this.getDefaultData());
    }
}

