/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.util.logging.ClientLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ThreadDumper {
    private static final ClientLogger LOGGER = new ClientLogger(ThreadDumper.class);
    private static volatile ScheduledExecutorService executorService;
    private static final int INITIAL_DELAY_IN_MINUTES = 30;
    private static final int RATE_IN_MINUTES = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize() {
        if (executorService != null) return;
        Class<ThreadDumper> clazz = ThreadDumper.class;
        synchronized (ThreadDumper.class) {
            if (executorService != null) return;
            executorService = Executors.newScheduledThreadPool(1, r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            });
            Runtime.getRuntime().addShutdownHook(new Thread(() -> executorService.shutdown()));
            executorService.scheduleAtFixedRate(ThreadDumper::printThreadStacks, 30L, 1L, TimeUnit.MINUTES);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void printThreadStacks() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder("============= THREAD DUMP START =========");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        dump.append("============= THREAD DUMP END =========");
        String output = dump.toString();
        System.out.println(output);
        LOGGER.info(output);
    }
}

