/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.test.TestMode;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.PlaybackOnly;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class PlaybackOnlyExtension
implements IAnnotationDrivenExtension<PlaybackOnly> {
    public void visitFeatureAnnotation(PlaybackOnly annotation, FeatureInfo feature) {
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.PLAYBACK) {
            feature.skip(String.format("Test ignored in %s mode", testMode));
        }
    }

    public void visitSpecAnnotation(PlaybackOnly annotation, SpecInfo spec) {
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.PLAYBACK) {
            spec.skip(String.format("Test ignored in %s mode", testMode));
        }
    }
}

