/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared;

import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.test.InterceptorManager;
import com.azure.core.test.TestMode;
import com.azure.core.test.ThreadDumper;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.EnvironmentCredentialBuilder;
import com.azure.storage.common.test.shared.ServiceVersionValidationPolicy;
import com.azure.storage.common.test.shared.StorageResourceNamer;
import com.azure.storage.common.test.shared.TestDataFactory;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.TestHttpClientType;
import com.azure.storage.common.test.shared.TestNameProvider;
import com.azure.storage.common.test.shared.policy.NoOpHttpPipelinePolicy;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import okhttp3.ConnectionPool;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="StorageSpec.groovy", line=28)
public class StorageSpec
extends Specification
implements GroovyObject {
    private static final TestEnvironment ENVIRONMENT;
    private static final HttpClient NETTY_HTTP_CLIENT;
    private static final HttpClient OK_HTTP_CLIENT;
    private static final ClientLogger LOGGER;
    @FieldMetadata(line=39, name="interceptorManager", ordinal=0, initializer=false)
    private InterceptorManager interceptorManager;
    @FieldMetadata(line=40, name="namer", ordinal=1, initializer=false)
    private StorageResourceNamer namer;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public StorageSpec() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getInstance", 0, TestEnvironment.class);
        ENVIRONMENT = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, NettyAsyncHttpClientBuilder.class));
        NETTY_HTTP_CLIENT = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "connectionPool", 0, IndyInterface.bootstrap("init", "<init>", 0, OkHttpAsyncHttpClientBuilder.class), IndyInterface.bootstrap("init", "<init>", 0, ConnectionPool.class, 50, 5, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class))));
        OK_HTTP_CLIENT = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("init", "<init>", 0, ClientLogger.class, StorageSpec.class);
        LOGGER = IndyInterface.bootstrap("cast", "()", 0, callSite4);
        IndyInterface.bootstrap("invoke", "initialize", 0, ThreadDumper.class);
    }

    private Object setup() {
        CallSite testName = IndyInterface.bootstrap("invoke", "getTestName", 0, TestNameProvider.class, IndyInterface.bootstrap("invoke", "getCurrentIteration", 0, IndyInterface.bootstrap("getProperty", "specificationContext", 12, this)));
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, InterceptorManager.class, testName, IndyInterface.bootstrap("getProperty", "testMode", 0, ENVIRONMENT));
        this.interceptorManager = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, StorageResourceNamer.class, testName, IndyInterface.bootstrap("getProperty", "testMode", 0, ENVIRONMENT), IndyInterface.bootstrap("invoke", "getRecordedData", 0, this.interceptorManager));
        this.namer = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        return IndyInterface.bootstrap("invoke", "info", 0, LOGGER, "Test {} will use {} resource prefix.", testName, IndyInterface.bootstrap("getProperty", "resourcePrefix", 0, this.namer));
    }

    private Object cleanup() {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.interceptorManager, null)) {
            return IndyInterface.bootstrap("invoke", "close", 0, this.interceptorManager);
        }
        return null;
    }

    protected static TestEnvironment getEnvironment() {
        return ENVIRONMENT;
    }

    protected StorageResourceNamer getNamer() {
        IndyInterface.bootstrap("invoke", "requireNonNull", 0, Objects.class, this.namer, "namer has not been initialized yet");
        return this.namer;
    }

    protected Object getData() {
        return IndyInterface.bootstrap("invoke", "getInstance", 0, TestDataFactory.class);
    }

    protected <T> T instrument(T builder) {
        IndyInterface.bootstrap("invoke", "httpClient", 0, builder, IndyInterface.bootstrap("invoke", "getHttpClient", 2, this));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "testMode", 0, ENVIRONMENT), (Object)IndyInterface.bootstrap("getProperty", "RECORD", 0, TestMode.class))) {
            IndyInterface.bootstrap("invoke", "addPolicy", 0, builder, IndyInterface.bootstrap("invoke", "getRecordPolicy", 0, this.interceptorManager));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "serviceVersion", 0, ENVIRONMENT), null)) {
            public final class _instrument_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _instrument_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)"serviceVersion") && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "parameterCount", 0, it), (Object)1);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _instrument_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Class serviceVersionClass = (Class)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "parameterTypes", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "methods", 0, IndyInterface.bootstrap("getProperty", "class", 0, builder)), new _instrument_closure1((Object)this, (Object)this))), false), Class.class));
            CallSite parsedServiceVersion = IndyInterface.bootstrap("invoke", "valueOf", 0, Enum.class, serviceVersionClass, IndyInterface.bootstrap("getProperty", "serviceVersion", 0, ENVIRONMENT));
            IndyInterface.bootstrap("invoke", "serviceVersion", 0, builder, parsedServiceVersion);
            IndyInterface.bootstrap("invoke", "addPolicy", 0, builder, IndyInterface.bootstrap("init", "<init>", 0, ServiceVersionValidationPolicy.class, IndyInterface.bootstrap("getProperty", "version", 0, parsedServiceVersion)));
        }
        CallSite httpLogOptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getDefaultHttpLogOptions", 0, builder));
        IndyInterface.bootstrap("invoke", "setLogLevel", 0, httpLogOptions, IndyInterface.bootstrap("getProperty", "HEADERS", 0, HttpLogDetailLevel.class));
        IndyInterface.bootstrap("invoke", "httpLogOptions", 0, builder, httpLogOptions);
        return builder;
    }

    protected HttpPipelinePolicy getRecordPolicy() {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "testMode", 0, ENVIRONMENT), (Object)IndyInterface.bootstrap("getProperty", "RECORD", 0, TestMode.class))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRecordPolicy", 0, this.interceptorManager));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "INSTANCE", 0, NoOpHttpPipelinePolicy.class));
    }

    protected HttpClient getHttpClient() {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "testMode", 0, ENVIRONMENT), (Object)IndyInterface.bootstrap("getProperty", "PLAYBACK", 0, TestMode.class))) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "httpClientType", 0, ENVIRONMENT);
            if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "NETTY", 0, TestHttpClientType.class))) {
                return NETTY_HTTP_CLIENT;
            }
            if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)IndyInterface.bootstrap("getProperty", "OK_HTTP", 0, TestHttpClientType.class))) {
                return OK_HTTP_CLIENT;
            }
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, IndyInterface.bootstrap("invoke", "plus", 0, "Unknown http client type: ", IndyInterface.bootstrap("getProperty", "httpClientType", 0, ENVIRONMENT))));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getPlaybackClient", 0, this.interceptorManager));
    }

    private static String getAuthToken() {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "testMode", 0, IndyInterface.bootstrap("getProperty", "environment", 8, StorageSpec.class)), (Object)IndyInterface.bootstrap("getProperty", "PLAYBACK", 0, TestMode.class))) {
            return "recordingBearerToken";
        }
        public final class _getAuthToken_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAuthToken_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getToken", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAuthToken_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "block", 0, IndyInterface.bootstrap("invoke", "map", 0, IndyInterface.bootstrap("invoke", "getToken", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("init", "<init>", 0, EnvironmentCredentialBuilder.class)), IndyInterface.bootstrap("invoke", "setScopes", 0, IndyInterface.bootstrap("init", "<init>", 0, TokenRequestContext.class), ScriptBytecodeAdapter.createList((Object[])new Object[]{"https://storage.azure.com/.default"}))), new _getAuthToken_closure2(StorageSpec.class, StorageSpec.class))));
    }

    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times, Duration delay) {
        Object i = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ScriptBytecodeAdapter.createRange((Object)0, (Object)times, (boolean)false, (boolean)true)));
        while (callSite.hasNext()) {
            i = callSite.next();
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "get", 0, action);
            try {
                return (T)callSite2;
            }
            catch (Exception e) {
                if (!retryPredicate.test(e)) {
                    throw (Throwable)e;
                }
                IndyInterface.bootstrap("invoke", "sleep", 0, Thread.class, IndyInterface.bootstrap("invoke", "toMillis", 0, delay));
            }
        }
        return null;
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate, int times) {
        return this.retry(action, retryPredicate, times, (Duration)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ofSeconds", 0, Duration.class, 10))));
    }

    @Generated
    protected <T, E extends Exception> T retry(Supplier<T> action, Predicate<E> retryPredicate) {
        return this.retry(action, retryPredicate, 6, (Duration)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ofSeconds", 0, Duration.class, 10))));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != StorageSpec.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

