/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.RequiredServiceVersion;
import java.lang.reflect.InvocationTargetException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class RequiredServiceVersionExtension
implements IAnnotationDrivenExtension<RequiredServiceVersion> {
    public void visitFeatureAnnotation(RequiredServiceVersion annotation, FeatureInfo feature) {
        String minServiceVersion;
        Enum targetServiceVersion = this.getTargetServiceVersion(annotation.clazz());
        if (this.shouldSkip(targetServiceVersion, minServiceVersion = annotation.min(), annotation.clazz())) {
            feature.skip(String.format("Test ignored to run with %s service version", targetServiceVersion));
        }
    }

    public void visitSpecAnnotation(RequiredServiceVersion annotation, SpecInfo spec) {
        String minServiceVersion;
        Enum targetServiceVersion = this.getTargetServiceVersion(annotation.clazz());
        if (this.shouldSkip(targetServiceVersion, minServiceVersion = annotation.min(), annotation.clazz())) {
            spec.skip(String.format("Test ignored to run with %s service version", targetServiceVersion));
        }
    }

    private Enum getTargetServiceVersion(Class clazz) {
        String targetServiceVersionFromEnvironment = TestEnvironment.getInstance().getServiceVersion();
        if (targetServiceVersionFromEnvironment != null) {
            return Enum.valueOf(clazz, targetServiceVersionFromEnvironment);
        }
        try {
            return (Enum)clazz.getMethod("getLatest", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldSkip(Enum targetServiceVersion, String minServiceVersion, Class clazz) {
        int minOrdinal;
        int targetOrdinal = targetServiceVersion.ordinal();
        return targetOrdinal < (minOrdinal = ((Enum)Enum.valueOf(clazz, minServiceVersion)).ordinal());
    }
}

