/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.test.TestMode;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.LiveOnly;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class LiveOnlyExtension
implements IAnnotationDrivenExtension<LiveOnly> {
    public void visitFeatureAnnotation(LiveOnly annotation, FeatureInfo feature) {
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.LIVE) {
            feature.skip(String.format("Test ignored in %s mode", testMode));
        }
    }

    public void visitSpecAnnotation(LiveOnly annotation, SpecInfo spec) {
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.LIVE) {
            spec.skip(String.format("Test ignored in %s mode", testMode));
        }
    }
}

