/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.test.TestMode;
import com.azure.storage.common.test.shared.TestEnvironment;
import com.azure.storage.common.test.shared.extensions.PlaybackOnly;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;

public class PlaybackOnlyExtension
implements IAnnotationDrivenExtension<PlaybackOnly> {
    public void visitFeatureAnnotation(PlaybackOnly annotation, FeatureInfo feature) {
        this.validateExpiryTime(annotation);
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.PLAYBACK) {
            feature.skip(String.format("Test ignored in %s mode", testMode));
        }
    }

    public void visitSpecAnnotation(PlaybackOnly annotation, SpecInfo spec) {
        this.validateExpiryTime(annotation);
        TestMode testMode = TestEnvironment.getInstance().getTestMode();
        if (testMode != TestMode.PLAYBACK) {
            spec.skip(String.format("Test ignored in %s mode", testMode));
        }
    }

    private void validateExpiryTime(PlaybackOnly annotation) {
        String expiryStr = annotation.expiryTime();
        if ("".equals(expiryStr)) {
            return;
        }
        OffsetDateTime expiry = LocalDate.parse(expiryStr, DateTimeFormatter.ofPattern("yyyy-MM-dd")).atTime(0, 0).atZone(ZoneId.of(ZoneId.SHORT_IDS.get("PST"))).toOffsetDateTime();
        OffsetDateTime now = OffsetDateTime.now(ZoneId.of(ZoneId.SHORT_IDS.get("PST")));
        if (now.isAfter(expiry)) {
            throw new RuntimeException("PlaybackOnly has expired. Test must be reenabled");
        }
    }
}

