/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.extensions;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.test.shared.TestNameProvider;
import org.spockframework.runtime.extension.AbstractGlobalExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.model.SpecInfo;

public final class TestHeaderExtension
extends AbstractGlobalExtension {
    private static final ClientLogger LOGGER = new ClientLogger(TestHeaderExtension.class);

    public void visitSpec(SpecInfo specInfo) {
        specInfo.getAllFeatures().forEach(feature -> feature.addIterationInterceptor((IMethodInterceptor)new TestHeaderIterationInterceptor()));
    }

    private static class TestHeaderIterationInterceptor
    implements IMethodInterceptor {
        private TestHeaderIterationInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void intercept(IMethodInvocation invocation) throws Throwable {
            String testName = TestNameProvider.getTestName(invocation.getIteration());
            System.out.printf("%s is starting%n", testName);
            LOGGER.info("{} is starting", new Object[]{testName});
            long startTimestamp = System.currentTimeMillis();
            try {
                invocation.proceed();
            }
            catch (Throwable throwable) {
                long duration = System.currentTimeMillis() - startTimestamp;
                System.out.printf("%s finished and took %d ms%n", testName, duration);
                LOGGER.info("{} finished and took {} ms", new Object[]{testName, duration});
                throw throwable;
            }
            long duration = System.currentTimeMillis() - startTimestamp;
            System.out.printf("%s finished and took %d ms%n", testName, duration);
            LOGGER.info("{} finished and took {} ms", new Object[]{testName, duration});
        }
    }
}

