/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.test.shared.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.Objects;
import java.util.function.Predicate;
import reactor.core.publisher.Mono;

public final class RequestAssertionPolicy
implements HttpPipelinePolicy {
    private final Predicate<HttpRequest> requestPredicate;
    private final String message;

    public RequestAssertionPolicy(Predicate<HttpRequest> requestPredicate, String message) {
        this.requestPredicate = Objects.requireNonNull(requestPredicate);
        this.message = Objects.requireNonNull(message);
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!this.requestPredicate.test(context.getHttpRequest())) {
            return Mono.error((Throwable)new IllegalStateException(this.message));
        }
        return next.process();
    }

    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (!this.requestPredicate.test(context.getHttpRequest())) {
            throw new IllegalStateException(this.message);
        }
        return next.processSync();
    }

    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

